#if !defined(lint) && !defined(CODECENTER)
static char *rcsid = "$Header: /vol/dwb/src/mumail-2.4b/RCS/MmMailProcs.c,v 1.2 1994/03/31 17:57:24 dwb Exp $";
#endif


/*
 * $Log: MmMailProcs.c,v $
 * Revision 1.2  1994/03/31  17:57:24  dwb
 *  MuMail 2.4 Beta
 *
 * Revision 1.1  1993/11/15  18:52:56  dwb
 * Initial revision
 *
 *
 */

/*---------------------------------------------------------------------------+
| This file is part of Mumail, 
| Copyright (c) 1992-1993 by Muhammad M. Saggaf.
| Copyright (c) 1994 by David W. Boyd. All rights reserved
|
| See the file COPYING (1-COPYING) or the manual page mumail(1)
| for a full statement of rights and permissions.
+---------------------------------------------------------------------------*/

/*                               -*- Mode: C -*- 
 * MmMailProcs.c --- Handles mail-sensitie headers, folders, and letters
 * Author          : Muhammad M. Saggaf
 * Created On      : April 1993
 * Last Modified By: system admin
 * Last Modified On: Tue Jun 29 23:33:52 1993
 * Update Count    : 25
 * Status          : Mostly OK, needs some cleaning up
 */

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Xaw/AsciiText.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <ctype.h>
#include <math.h>
#include <time.h>
#include <errno.h>
#include "MuGeneric.h"
#include "MmDecl.h"

time_t          ArpaToUnixDate();
String          GetNameFromAddressLine();

char*
GetNextLetterStart(mailBuffer)
	 String          mailBuffer;
{
  static String          curBufPos;
  String                 bufPtr;

  if (mailBuffer == NULL) mailBuffer = curBufPos;

/*  if ((bufPtr = MuStrstr(mailBuffer, "\n\nFrom ")))
	{curBufPos = bufPtr + 7; return bufPtr + 2;}*/

  for (bufPtr = mailBuffer; *bufPtr;) {
	while((*bufPtr && *bufPtr != NEWLINE) ||
		  (*(bufPtr+1) && *(bufPtr+1) != NEWLINE)) bufPtr++;
	if (*bufPtr && strncmp(++bufPtr, "\nFrom ", 6) == 0)
	  {curBufPos = bufPtr + 6; return bufPtr + 1;}
  }
  return NULL;
}

char*
GetNextLetter(mailBuffer)
	 String          mailBuffer;
{
  static String          nextLetterStart;
  String                 letterStart;

  if (mailBuffer == NULL) letterStart = nextLetterStart;
  else if ((letterStart = GetNextLetterStart(mailBuffer)) == NULL) 
	return (nextLetterStart = NULL);

  /* This would be NULL if nextLetterStart from the previous call was so */
  if (letterStart) {
	if ((nextLetterStart = GetNextLetterStart(NULL)))
	  *(nextLetterStart - 1) = CNULL;
	/* Folders should always end in a blank line. If we don't subtract
	   the 1, the last message will grow in size each time the folder
	   is saved, since the extra blank line would be considered part
	   of the message */
	else *(strend(letterStart) - 1) = CNULL;
  }	

  return letterStart;
}

Boolean
FindHeaderField(title, var, def, rawLetter, headersBuf, offset)
	 String          title,
                     *var,
                     def,
                     rawLetter,
                     headersBuf;
	 int             *offset;
{
  static String            emptyString = "";
  register String          fieldStart, curPtr;
  static int               n;
  int                      titleLen, i;
  Boolean                  found;

/*  if (offset > 0) n = offset;*/
  n = *offset;

  /* Here we just keep using strstr until we find the required header 
	 provided that it's at the start of a line (or keep looping). */

  fieldStart = headersBuf;
  while ((fieldStart = CaseStrstr(fieldStart, title)) &&
		 fieldStart != headersBuf &&
		 (*(fieldStart-1) != NEWLINE)) fieldStart++;

  /* If a default value is provaided, use it. Otherwise set the letter
	 component to an empty string. */

  if (fieldStart == NULL) {
	found = False;
	if (def) *var = def;
	else *var = emptyString;
  }

  else {
	found = True;
    titleLen = strlen(title);

	/* This loop advances until the first non-space character (or till 
	   end of line), filling all the headers buffer from the start of
	   the recognized header title until the stop character with newlines.
	   This is so that the header starts with non-white space. Note that
	   we are allowing the header title here to have spaces */

	for (i = 0, curPtr = fieldStart;
		 *curPtr && (i < titleLen ||
		 (isspace(*curPtr) && *curPtr != NEWLINE));
		 i++, curPtr++) *curPtr = NEWLINE;

	/* Here we just copy the header to the folder buffer (its permanent
	   location) and set all corresponding characters in the headers 
	   buffer to newlines. This code unfolds folded headers into a single
	   line. */
	
	for (i = ++n; *curPtr && 
		 (*curPtr != NEWLINE || 
		  (*(curPtr+1) && isspace(*(curPtr+1))));
		 curPtr++) {
	  if (*curPtr != NEWLINE) rawLetter[i++] = *curPtr;
	  *curPtr = NEWLINE;
	}

	/* Then we set the letter componenet address to the start of that 
	   header in the folders buffer, and NULL-terminate the header */

	*var = rawLetter+n;
	rawLetter[n = i] = CNULL;
  }

  *offset = n;
  return found;
}	

#define MIME_100_TYPE_TEXT_PLAIN_S "text/plain"
#define MIME_0_TYPE_TEXT_S         "text"

void
SetLetterContentType(letter)
	 Letter          *letter;
{
  String          typeS = letter->mime.contentTypeS;

  if (*typeS == CNULL || 
	  (letter->mime.mimeVersion < 100 && 
	   CaseNStrSame(typeS, MIME_0_TYPE_TEXT_S, strlen(MIME_0_TYPE_TEXT_S))) ||
	  (letter->mime.mimeVersion >= 100 && 
	   CaseNStrSame(typeS, MIME_100_TYPE_TEXT_PLAIN_S, 
					strlen(MIME_100_TYPE_TEXT_PLAIN_S))))
	letter->mime.contentType = CONTENT_TYPE_TEXT_PLAIN;

  else letter->mime.contentType = CONTENT_TYPE_OTHER;
}

Letter*
ExtractLetterComponents(rawLetter, defaultLet)
	 String          rawLetter;
	 Letter          *defaultLet;
{
  static Letter      *letter;
  String             headersBuf,
                     headersEnd,
                     curPtr;
  int                n = 0, i;
  Boolean            digest = False, found;

  if (rawLetter == NULL) return NULL;

  letter = XtNew(LETTER);
  letter->totalLength = strlen(rawLetter) + 1;
  letter->status = 0;
  /* This is redundant, but just a reminder */
  letter->status &= ~(LETTER_DELETED | LETTER_TAGGED | LETTER_RETAG);

  /* Isolate the headers */
  if ((headersEnd = Strstr(rawLetter, "\n\n"))) *headersEnd = CNULL;
  letter->content = headersEnd + 2;

  headersBuf = XtNewString(rawLetter);

  if (strncmp(rawLetter, "From ", 5) == 0) {
	letter->delimiter = rawLetter;
	for (i = 0; rawLetter[i] && rawLetter[i] != NEWLINE; i++)
	  headersBuf[i] = NEWLINE;
	rawLetter[n = i] = CNULL;
  }  
  /* No delimiter - must be a digest */
  else {
	digest = True;
	letter->delimiter = defaultLet->delimiter;
  }

#define FindField(title,var,def)\
  {found = FindHeaderField(title,&var,def,rawLetter,headersBuf,&n);}

  FindField(FROM_TITLE, letter->from, defaultLet->from);
  /* Some digests do not conform to RFC-1153 specs and put `>' before
	 `From:'. This will take care of this case */
  if (!found && digest)   
	FindField(QUOTED_FROM_TITLE, letter->from, defaultLet->from);

  FindField(TO_TITLE, letter->to, defaultLet->to);
  FindField(SUBJECT_TITLE, letter->subject, defaultLet->subject);
  FindField(CC_TITLE, letter->cc, NULL);

  FindField(DATE_TITLE, letter->date.fullS, defaultLet->date.fullS);
  letter->date.timeU = ArpaToUnixDate(letter->date.fullS);

  FindField(REPLY_TO_TITLE, letter->replyTo, defaultLet->replyTo);
  
  FindField(READ_TITLE, letter->readS, NULL);
  if (found) letter->status |= LETTER_READ;
  FindField(REPLIED_TITLE, letter->repliedS, NULL);
  if (found) letter->status |= LETTER_REPLIED;

  FindField(MIME_VERSION_TITLE, letter->mime.mimeVersionS, NULL);
  letter->mime.mimeVersion = found ? 100*atof(letter->mime.mimeVersionS) : 0;
  FindField(CONTENT_TYPE_TITLE, letter->mime.contentTypeS, NULL);
  SetLetterContentType(letter);
  if (letter->mime.contentType != CONTENT_TYPE_TEXT_PLAIN)
	letter->status |= LETTER_MIME;

  /* This is just to make sure that the following curPtr-1 is well-defined
     (does not start _before_ the headers buffer */

  i = ++n; curPtr = headersBuf;
  if (*curPtr != NEWLINE) rawLetter[i++] = *curPtr;
  curPtr++;

  /* Copy all remaining non-recognized headers. We copy everything that 
	 doesn't consist of consecutive newlines, since those resulted from
	 recognized headers. The test condition always keeps newlines at the
	 end of headers, as it should */

  for (; *curPtr; curPtr++)
	if (*curPtr != NEWLINE || *(curPtr-1) != NEWLINE) 
	  rawLetter[i++] = *curPtr;
 
  /* We don't want newline at the end of the last non-recognized header 
     (recognized headers never have newlines at their end */

  letter->otherHeaders = rawLetter+n;
  if (i && rawLetter[i-1] == NEWLINE) rawLetter[i-1] = CNULL;
  else rawLetter[i] = CNULL;

  XtFree(headersBuf);
  return letter;
}

int
GetLettersFromFolder(scn, folderName)
	 SCREEN          *scn;
	 String          folderName;
{
  FILE            *folder;
  static Letter   defaultLetter;
  String          rawLetter;
  int             i;
  time_t          prevTime, curTime;
  String	  tmp_buff;

  if (OpenPFile(&folder, folderName, "r") < 0) {
	MessagePError(scn, FmtString("Could not open folder %s", folderName));
	return -1;
  }

  AnimStart(scn);
  Message(scn, "Loading letters...", MSG_CLEAR_DEFAULT);

  /* Free all buffers */
  FreeBuffers(scn);

  if ((tmp_buff = CopyStreamToBuffer(folder, "\n\n")) == NULL)
	{AnimStop(scn); return -1;}

  ClosePFile(folder, folderName);
  tmp_buff = GetNewBuffer(scn,tmp_buff);

  FreeList((XtPointer)scn->letterList);
  Anim(scn);
  SimpleMessage(scn, "Parsing letters...");

  for (i = 0, prevTime = time((time_t*)NULL); 
	   (rawLetter = GetNextLetter(i ? NULL : tmp_buff)); 
	   i++) {

	scn->letterList[i] = ExtractLetterComponents(rawLetter, &defaultLetter);
	if ((curTime = time((time_t*)NULL)) - prevTime > 5) {
	  prevTime = curTime;
	  SimpleMessage(scn, FmtString("Parsing letters (%d)...", i+1));
	}
	Anim(scn);
  }

  scn->letterList[i] = NULL;
  scn->folder.numLetters = i;

  CompactFolder(scn);			/* sets curLetN ..etc. */
  scn->folder.curDispLetN = -1;

  /* AnimStop will be called in ReMakeToc */
  return 0;
}

int
AppendLettersFromBuffer(scn, buffer)
	 SCREEN          *scn;
	 String          buffer;
{
  static Letter   defaultLetter;
  String          rawLetter;
  int             i;
  time_t          prevTime, curTime;

  AnimStart(scn);
  Message(scn, "Loading New Mail...", MSG_CLEAR_DEFAULT);

  Anim(scn);

  GetNewBuffer(scn,buffer);

  for (i = scn->folder.numLetters, prevTime = time((time_t*)NULL); 
	   (rawLetter = GetNextLetter((i > scn->folder.numLetters) ? NULL : buffer)); 
	   i++) {

	scn->letterList[i] = ExtractLetterComponents(rawLetter, &defaultLetter);
	if ((curTime = time((time_t*)NULL)) - prevTime > 5) {
	  prevTime = curTime;
	  SimpleMessage(scn, FmtString("Parsing letters (%d)...", i+1));
	}
	Anim(scn);
  }

  scn->folder.changed = True;
  scn->letterList[i] = NULL;
  scn->folder.numLetters = i;

  /* AnimStop will be called in ReMakeToc */
  ReMakeToc(scn);
  return 0;
}

void
CompactFolder(scn)
	 SCREEN          *scn;
{
  LETTER          *letter;
  int             numLetters, numTagged, curLetN,
                  i;

  for (i = 0, numTagged = numLetters = 0, curLetN = -1;
	   (letter = scn->letterList[i]); i++) {

	if (letter->status & LETTER_DELETED) 
           {
           free(letter);
           continue;
           }

	scn->letterList[numLetters] = letter;
	if (curLetN < 0 && !(letter->status & LETTER_READ)) curLetN = numLetters;
	if (letter->status & LETTER_TAGGED) numTagged++;
	++numLetters;
  }

  scn->letterList[numLetters] = NULL;
  scn->folder.numLetters = numLetters;
  scn->folder.numTagged = numTagged;

  /* If there are any letters in the folder, we want the first unread 
	 one to be the current */
  scn->folder.curLetN = curLetN < 0 ? scn->folder.numLetters ? 0 : -1 
	: curLetN;
}

void
ReMakeToc(scn)
	 SCREEN          *scn;
{
  LETTER          *letter;
  char            dispItemsBuf[BUF256];
  static String   tocS;
  String          tmpPtr, fromBuf, partCont, subjectBuf;
  char            date[BUF10], fmt[BUF80];
  int             i, n, subjWidth;

  AnimStart(scn);

  /* Add 1 in case the folder is empty */

  if (tocS) XtFree(tocS);
  tocS = XtMalloc(scn->folder.numLetters * BUF256 + 1);

  tmpPtr = strcpy(tocS, ""); 

  for (i = 1, n = 10; n < scn->folder.numLetters; i++, n *= 10);
  scn->toc.flagPos = i+2;
  
  subjWidth = 49 - scn->toc.flagPos;
  sprintf(fmt, "%%%dd %%5.5s %%-6.6s %%-17.17s  %%-%d.%ds%%1c",
		  scn->toc.flagPos - 1, subjWidth, subjWidth);
  
  for (i = 0; (letter = scn->letterList[i]); i++) {

	Anim(scn);

	/* Set the letter numbers. It's done here since it's independent
	   of compaction and can be refreshed whenever the toc is remade, 
	   also since GetLettersFromDigest doesn't set those numbers */
	letter->number = i;

	strftime(date, 7, "%b %d", localtime(&letter->date.timeU));

	fromBuf = *letter->from ? GetNameFromAddressLine(letter->from) : 
	  *letter->to ? FmtString(">>%s", GetNameFromAddressLine(letter->to)) : 
		"<<unknown>>";
/*	  FmtString("%s %s", TO_TITLE, letter->to) : "<<unknown>>";*/

	if (strlen(letter->subject) >= subjWidth || res.contentInToc == False) 
	  subjectBuf = letter->subject;
	else {
	  partCont = strncpy(FmtString(""), letter->content, subjWidth);
	  partCont[49] = CNULL;
	  subjectBuf = FmtString("%s <<%s>>", letter->subject, 
						   StripStringB(FilterString(partCont, "\n", SPACE)));
	}
	
	sprintf(dispItemsBuf, fmt, 
			i + 1,

			TocLetterStatusSymbols(letter),
/*			letter->status & LETTER_TAGGED ? TOC_TAG_FLAG : 
			letter->status & LETTER_DELETED ? TOC_DEL_FLAG : 
			letter->status & LETTER_REPLIED ? TOC_REPL_FLAG : 
			!(letter->status & LETTER_READ) ? TOC_UNREAD_FLAG :
			letter->status & LETTER_MIME ? TOC_MIME_FLAG : TOC_READ_FLAG, */
			
			date,
			fromBuf, 
			subjectBuf,
			scn->letterList[i+1] ? NEWLINE : SPACE);
	
	strcat(tmpPtr, dispItemsBuf);
	tmpPtr = strend(tmpPtr);
  }

  XawTextDisableRedisplay(scn->toc.tocW);
  XtVaSetValues(scn->toc.tocW, XtNstring, tocS, NULL);
  RedisplayToc(scn);
  AnimStop(scn);
}

String
ConstructLetter(letter, letterMakeFormat)
	 LETTER *letter;
	 int     letterMakeFormat;
{
  String          letterBuffer,
                  curStartPos,
                  date;

  /* Added 256 just to be safe (for read, replied, ..etc.) */
  letterBuffer = XtMalloc(letter->totalLength + 256);

  curStartPos = strcpy(letterBuffer, "");

  /* includes LETTER_MAKE_FOR_FOLDER */
  if (letterMakeFormat >= LETTER_MAKE_WITH_DELIMITER)
	strcat(curStartPos, FmtString("%s\n", letter->delimiter));

  if (letterMakeFormat >= LETTER_MAKE_WHOLE) {
	date = CurrentArpaDate();
	
	if (letter->status & LETTER_REPLIED)
	  strcat(curStartPos, FmtString("%s %s\n", REPLIED_TITLE, 
		*(letter->repliedS) ? letter->repliedS : date));
	if (letter->status & LETTER_READ)
	  strcat(curStartPos, FmtString("%s %s\n", READ_TITLE, 
        *(letter->readS) ? letter->readS : date));

	/* What if there are no other headers? This takes care of it */
	/* Better not use FmtString here since the string could be too big */
	curStartPos = strend(curStartPos);
	if (*letter->otherHeaders) 
	  sprintf(curStartPos, "%s\n", letter->otherHeaders);
  }							

  if (letterMakeFormat >= LETTER_MAKE_PARTIAL) {
	curStartPos = strend(curStartPos);
	sprintf(curStartPos, "%s %s\n%s %s\n%s %s\n",
			DATE_TITLE, letter->date.fullS,
			FROM_TITLE, letter->from,
			TO_TITLE, letter->to);
	if (*letter->cc) strcat(curStartPos, FmtString("%s %s\n",
													CC_TITLE, letter->cc));
	strcat(curStartPos, FmtString("%s %s\n", SUBJECT_TITLE, letter->subject));
  }

  if (letterMakeFormat >= LETTER_MAKE_WHOLE) {
	if (*letter->replyTo)
	  strcat(curStartPos, FmtString("%s %s\n", REPLY_TO_TITLE, 
		 letter->replyTo));
	if (*letter->mime.mimeVersionS)
	  strcat(curStartPos, FmtString("%s %s\n", MIME_VERSION_TITLE, 
		 letter->mime.mimeVersionS));
	if (*letter->mime.contentTypeS)
	  strcat(curStartPos, FmtString("%s %s\n", CONTENT_TYPE_TITLE, 
		 letter->mime.contentTypeS));
  }

  if (letterMakeFormat >= LETTER_MAKE_BODY) {
	curStartPos = strend(curStartPos);
	sprintf(curStartPos, "\n%s", letter->content);
  }

  if (letterMakeFormat >= LETTER_MAKE_FOR_FOLDER) {
	curStartPos = strend(curStartPos);
	if (*(curStartPos-1) != NEWLINE) strcat(curStartPos, "\n");
	strcat(curStartPos, "\n");
  }

/*  *(curStartPos-1) = CNULL; leave it out, we want to keep the last newline*/
  return letterBuffer;
}

int
WritefolderToDisk(scn, folderName)
	 SCREEN          *scn;
	 String          folderName;
{
  LETTER          *letter;
  FILE            *folder;
  String          letterBuffer;
  int             i;

  if (OpenPFile(&folder, folderName, "w") < 0) {
	MessagePError(scn, FmtString("Could not open folder %s", folderName));
	return -1;
  }

  AnimStart(scn);
  if (res.sortWhen & SORT_ON_SAVE) SortFolderByDefaultKeys(scn);

  SimpleMessage(scn, "Saving folder...");
  CompactFolder(scn);			/* will take care of deleted letters */

  for (i = 0; (letter = scn->letterList[i]); i++) {
	letterBuffer = ConstructLetter(letter, LETTER_MAKE_FOR_FOLDER);
	fprintf(folder, "%s", letterBuffer);
	XtFree(letterBuffer);
	Anim(scn);
  }

  ClosePFile(folder, scn->folder.name);
  scn->folder.changed = False;

  /* AnimStop will be called in ReMakeToc */
  ReMakeToc(scn);
  return 0;
}

String
FindHeaderFieldFromFile(fileName, header)
	 String fileName,
	        header;
{
  FILE        *fp;
  static char fileS[BUF256];
  int         len = strlen(header);

  OpenStream(fp, fileName, "r", NULL);
  
  while (fgets(fileS, BUF256, fp))
	if (strncmp(fileS, header, len) == 0) {
	  fclose(fp);
	  *(strend(fileS) - 1) = CNULL;
	  return fileS+len+1;
	}

  fclose(fp); return NULL;
}

String
SuppressUnwantedAddressComp(header)
	 String          header;
{
  String          curPtr;
  int             dQuote, 
                  sQuote, 
                  paren;

  if (header == NULL) return header;

  for (dQuote = 0, sQuote = 0, paren = 0, curPtr = header; 
	   *curPtr; curPtr++) {

	switch (*curPtr) {
	case '\"': 
	  dQuote = dQuote ? 0 : 1;
	  *curPtr = ' ';
	  break;
	case '\'': 
	  sQuote = sQuote ? 0 : 1;
	  *curPtr = ' ';
	  break;
	case '(':
	  if (dQuote == 0 && sQuote == 0) 
		{paren++; *curPtr = ' ';}
	  break;
	case ')': 
	  if (dQuote == 0 && sQuote == 0) 
		{paren--; *curPtr = ' ';}
	  break;
	case '<':
	case '>':
	  *curPtr = ' ';
	}
	  
	if (dQuote || sQuote || paren || *curPtr == ',') *curPtr = ' ';
  }

  return header;
}

String
BuildAddress(header)
	 String          header;
{
  Boolean         notValidHeader;
  static String   newHeader;
  String          curPtr,
                  lastSpacePtr, 
                  tmpPtr;

  if (header == NULL) return header;

  if (newHeader) XtFree(newHeader);
  newHeader = XtNewString(SuppressUnwantedAddressComp(header));

  lastSpacePtr = curPtr = newHeader; 
  notValidHeader = True; 

  do {
	if (isspace(*curPtr) || *(curPtr) == CNULL) {
	  if (notValidHeader)
		for (tmpPtr = lastSpacePtr; tmpPtr != curPtr; tmpPtr++) 
		  *tmpPtr = SPACE;

	  notValidHeader = True;
	  lastSpacePtr = curPtr;
	}
	  
	else if (*curPtr == '@' || *curPtr == '!')
	  notValidHeader = False;

  } while (*curPtr++);

  return StripStringA(newHeader);
}

#define LEFT_PAREN_CHAR        ('(')
#define RIGHT_PAREN_CHAR       (')')
#define DUOBLE_QUOTE_CHAR      ('\"')
#define LESS_THAN_CHAR         ('<')

String
GetNameFromAddressLine(addrLine)
	 String          addrLine;
{
  String          start, end, name;
  char            c;
  Boolean         found = False;

  if ((start = strchr(addrLine, DUOBLE_QUOTE_CHAR)))
	if ((end = strchr(++start, DUOBLE_QUOTE_CHAR)))
	  {end--; found = True;}
	else found = False;

  else if ((start = strchr(addrLine, LEFT_PAREN_CHAR)))
	if ((end = strchr(++start, RIGHT_PAREN_CHAR))) 
	  {end--; found = True;}
	else found = False;

  else if ((end = strchr(addrLine, LESS_THAN_CHAR)))
	{end--; start = addrLine; found = True;} 

  else found = False;

  if (!found || (end - start) < 3) name = FmtString("%s", addrLine);
  else {
	c = *end;
	*end = CNULL;
	name = FmtString("%s", start);
	*end = c;
  }

  return StripStringA(name);
}

time_t
ArpaToUnixDate(arpaDate)
	 String          arpaDate;
{
  static String    arpaMonthName[] = {"Jan", "Feb", "Mar", "Apr", "May", 
										"Jun", "Jul", "Aug", "Sep", "Oct",
										"Nov", "Dec", NULL};
  static char      monthName[BUF10];
  static struct tm tm;
  int              i, gmtDiff = 0;

  /* Like Thu, 15 Apr 93 08:09:47 -0500 */

  sscanf(arpaDate, " %*s %d %5s %d %d:%d:%d %d", &tm.tm_mday, monthName, 
		 &tm.tm_year, &tm.tm_hour, &tm.tm_min, &tm.tm_sec, &gmtDiff);

  if (tm.tm_year > 99) tm.tm_year = tm.tm_year - 1900;

  for (i = 0; arpaMonthName[i] &&
	   strcmp(arpaMonthName[i], monthName); i++);
  tm.tm_mon = i;

  tm.tm_isdst = -1;

  return mktime(&tm) - (gmtDiff/100)*3600 - (gmtDiff%100)*60;
}
