#if !defined(lint) && !defined(CODECENTER)
static char *rcsid = "$Header: /vol/dwb/src/mumail-2.4b/RCS/MmLetter.c,v 1.2 1994/03/31 17:57:20 dwb Exp $";
#endif


/*
 * $Log: MmLetter.c,v $
 * Revision 1.2  1994/03/31  17:57:20  dwb
 *  MuMail 2.4 Beta
 *
 * Revision 1.1  1993/11/15  18:52:54  dwb
 * Initial revision
 *
 *
 */

/*---------------------------------------------------------------------------+
| This file is part of Mumail, 
| Copyright (c) 1992-1993 by Muhammad M. Saggaf.
| Copyright (c) 1994 by David W. Boyd. All rights reserved
|
| See the file COPYING (1-COPYING) or the manual page mumail(1)
| for a full statement of rights and permissions.
+---------------------------------------------------------------------------*/

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Xaw/AsciiText.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/wait.h>
#include "MuWin.h"
#include "MuGeneric.h"
#include "MmDecl.h"

int
              PipeLetterToCommand __P((LETTER *letter, 
                                       String command)),
              DeleteLetterProc __P((SCREEN *scn, 
                                    int letter, 
                                    XtPointer data)),
              UndeleteLetterProc __P((SCREEN *scn, 
                                      int letter, 
                                      XtPointer data));

void          TagUntagLetterProc __P((SCREEN *scn,
                                      Letter *letter));

int 
MarkLetterAsRead(scn, letterN)
	 SCREEN          *scn;
	 int             letterN;
{
  LETTER          *letter;

  CheckIfLetterOk(scn, letterN, -1);
  letter = scn->letterList[letterN];

  if (letter->status & LETTER_READ) return -1;
  letter->status |= LETTER_READ;
  scn->folder.changed = True;

  TocUpdateLetterStatusSymbols(scn, letter);
  return 0;
}

int 
MarkLetterAsRepliedTo(scn, letterN)
	 SCREEN          *scn;
	 int             letterN;
{
  LETTER          *letter;

  CheckIfLetterOk(scn, letterN, -1);
  letter = scn->letterList[letterN];

  if (letter->status & LETTER_REPLIED) return -1;
  letter->status |= LETTER_REPLIED;
  scn->folder.changed = True;

  TocUpdateLetterStatusSymbols(scn, letter);
  return 0;
}

int 
MarkLetterAsTaggedUntagged(scn, letterN)
	 SCREEN          *scn;
	 int             letterN;
{
  LETTER          *letter;

  CheckIfLetterOk(scn, letterN, -1);
  letter = scn->letterList[letterN];

  if (letter->status & LETTER_TAGGED) {
	letter->status &= ~LETTER_TAGGED;
	if (scn->folder.numTagged) scn->folder.numTagged--;
  }

  else {
	letter->status |= LETTER_TAGGED;
	scn->folder.numTagged++;
  }

  TocUpdateLetterStatusSymbols(scn, letter);
  return 0;
}

int 
MarkLetterAsDeleted(scn, letterN)
	 SCREEN          *scn;
	 int             letterN;
{
  LETTER          *letter;

  if (DeleteLetterProc(scn, letterN, (XtPointer)NULL) < 0) return -1;
  letter = scn->letterList[letterN];

  TocUpdateLetterStatusSymbols(scn, letter);
  return 0;
}

int 
MarkLetterAsUndeleted(scn, letterN)
	 SCREEN          *scn;
	 int             letterN;
{
  LETTER          *letter;

  if (UndeleteLetterProc(scn, letterN, (XtPointer)NULL) < 0) return -1;
  letter = scn->letterList[letterN];

  TocUpdateLetterStatusSymbols(scn, letter);
  return 0;
}

int
OperateOnTeggedLetters(scn, letterProc, clientData)
	 SCREEN          *scn;
	 int             (*letterProc)();
	 XtPointer       clientData;
{
  Letter       *letter;
  int          i, n;

  AnimStart(scn);
  for (i = 0, n = 0; (letter = scn->letterList[i]); i++)
	if (letter->status & LETTER_TAGGED && 
		(*letterProc)(scn, letter->number, clientData) >= 0) {
	  TagUntagLetterProc(scn, letter);
	  letter->status |= LETTER_RETAG;
	  n++;
	  Anim(scn);
	}
	else letter->status &= ~LETTER_RETAG;

  if (n) ReMakeToc(scn);
  return n;
}

/* ARGSUSED */
void
OperateOnTeggedLettersCallback(widget, clientData, callData)
	 Widget             widget;
	 XtPointer          clientData;
	 XtPointer          callData;
{
  ClientDataRec          *clientDataRec = (ClientDataRec*)clientData;
  int                    numSuccess;

  numSuccess = 
	OperateOnTeggedLetters((SCREEN*)clientDataRec->field[0], 
						   (int(*)())clientDataRec->field[1],
						   clientDataRec->field[2]);

  (*(XtCallbackProc)clientDataRec->field[3])(widget, clientData,
											 (XtPointer)numSuccess); 
}

/*---------------------------------------------------------------------------+
| Display letter routines.
+---------------------------------------------------------------------------*/

int
DisplayLetterInBodyBox(scn, letterN, letterDisplayFormat)
	 SCREEN         *scn;
	 int             letterN,
                     letterDisplayFormat;
{
  String  letterDisplayBuffer;

  if (!LetterNumberOk(scn,letterN))
	{DisplayLogo(scn); return -1;}

  scn->folder.curDispLetN = letterN;
  letterDisplayBuffer = ConstructLetter(scn->letterList[letterN], 
										letterDisplayFormat);
  DisplayBufferInBodyBox(scn, letterDisplayBuffer);

  XtFree(letterDisplayBuffer);
  return 0;
}

int
PipeLetterToMimeCommand(scn, letter)
	 SCREEN           *scn;
	 Letter           *letter;
{
  SimpleMessage(scn, "Letter passed to MIME agent, waiting...");
  PipeLetterToCommand(letter, res.mimeCommand);
  SimpleMessage(scn, "MIME agent done");
  return 0;
}

int
DisplayLetterProc(scn, letterN, letterDisplayFormat)
	 SCREEN           *scn;
	 int              letterN,
                      letterDisplayFormat;
{
  Letter          *letter;

  if (DisplayLetterInBodyBox(scn, letterN, letterDisplayFormat) < 0) 
	return -1;

  MarkLetterAsRead(scn, letterN);
  letter = scn->letterList[letterN];

  if (!(letter->status & LETTER_MIME) || 
	  res.invokeMime ==  MIME_INVOKE_NEVER) 
	return 0;

  if (res.invokeMime == MIME_INVOKE_ASK) {
	SimpleMessage(scn, "Letter content is not plain text, MIME-view?");
	if (BooleanPrompt(scn) == BP_NO) return 0;
  }	
  
  PipeLetterToMimeCommand(scn, letter);
  return 0;
}

int
DisplayCurLetterProc(scn, letterDisplayFormat)
	 SCREEN           *scn;
	 int              letterDisplayFormat;
{
  return DisplayLetterProc(scn, scn->folder.curLetN, letterDisplayFormat);
}

/* ARGSUSED */
void 
DisplayCurLetterPartialCallback(widget, clientData, callData)
	 Widget    widget;
	 XtPointer clientData;
	 XtPointer callData;
{
  DisplayCurLetterProc((SCREEN*)clientData, LETTER_MAKE_PARTIAL);
}

/* ARGSUSED */
void 
DisplayCurLetterWholeCallback(widget, clientData, callData)
	 Widget    widget;
	 XtPointer clientData;
	 XtPointer callData;
{
  DisplayCurLetterProc((SCREEN*)clientData, LETTER_MAKE_WHOLE);
}

int
DisplayLetterPartialInNextScreenProc(scn)
	 SCREEN           *scn;
{
  SCREEN           *nextScn;

  if ((nextScn = NextScreen(scn)) == NULL)
	nextScn = NewWindowProc(scn,scn->folder.name);
  
  nextScn->folder.curLetN = scn->folder.curLetN;
  return DisplayCurLetterProc(nextScn, LETTER_MAKE_PARTIAL);
}

/* ARGSUSED */
void 
DisplayLetterPartialInNextScreenCallback(widget, clientData, callData)
	 Widget             widget;
	 XtPointer          clientData;
	 XtPointer          callData;
{
  DisplayLetterPartialInNextScreenProc((SCREEN*)clientData);
}

/* ARGSUSED */
void
PipeLetterToMimeCommandCallback(widget, clientData, callData)
	 Widget             widget;
	 XtPointer          clientData;
	 XtPointer          callData;
{
  SCREEN          *scn = (SCREEN*)clientData;
  Letter          *letter;

  CheckIfLetterOk(scn, scn->folder.curLetN,);
  letter = scn->letterList[scn->folder.curLetN];

  PipeLetterToMimeCommand(scn, letter);
}

/*---------------------------------------------------------------------------+
| Tag/untag routines.
+---------------------------------------------------------------------------*/

void
TagUntagLetterProc(scn, letter)
	 SCREEN          *scn;
	 Letter          *letter;
{
  if (letter->status & LETTER_TAGGED) letter->status &= ~LETTER_TAGGED;
  else letter->status |= LETTER_TAGGED;
  scn->folder.numTagged += (letter->status & LETTER_TAGGED) ? 1 : -1;
}

/* ARGSUSED */
void 
TagUntagLetterCallback(widget, clientData, callData)
	 Widget    widget;
	 XtPointer clientData;
	 XtPointer callData;
{
  SCREEN          *scn = (SCREEN*)clientData;

  CheckIfLetterOk(scn, scn->folder.curLetN,);
  MarkLetterAsTaggedUntagged(scn, scn->folder.curLetN);
}

/* ARGSUSED */
void 
TagAllLettersCallback(widget, clientData, callData)
	 Widget    widget;
	 XtPointer clientData;
	 XtPointer callData;
{
  SCREEN          *scn = (SCREEN*)clientData;
  Letter          *letter;
  int             i;

  AnimStart(scn);
  for (i = 0; (letter = scn->letterList[i]); i++)
	if (!(letter->status & LETTER_TAGGED)) {
	  TagUntagLetterProc(scn, letter);
	  scn->folder.curLetN = letter->number;
	  Anim(scn);
	}

  /* Busy  pointer will be cleared in ReMakeToc */
  ReMakeToc(scn);
  Message(scn, "All letters tagged", MSG_CLEAR_DEFAULT);
}

/* ARGSUSED */
void 
TagRangeOfLettersCallback(widget, clientData, callData)
	 Widget             widget;
	 XtPointer          clientData;
	 XtPointer          callData;
{
  SCREEN          *scn = (SCREEN*)clientData;
  Letter          *letter;
  int             first, last, i, n;
  String          range;

  Message(scn, "Enter range in the form <first> <last>", MSG_CLEAR_DEFAULT);
  if ((range = DialogPrompt(scn)) == NULL) return;

  if (sscanf(range, " %d %d", &first, &last) < 2) {
	SimpleMessage(scn, "Invalid range, aborting");
	return;
  }

  if (first < 1) first = 1;
  if (last > scn->folder.numLetters) last = scn->folder.numLetters;
  
  AnimStart(scn);
  for (i = first-1, n = 0; (letter = scn->letterList[i]) && i < last; i++)
	if (!(letter->status & LETTER_TAGGED)) {
	  TagUntagLetterProc(scn, letter); n++;
	  scn->folder.curLetN = letter->number;
	  Anim(scn);
	}

  /* Busy  pointer will be cleared in ReMakeToc */
  if (n) ReMakeToc(scn);
  SimpleMessage(scn, FmtString("%d letters tagged", n));
}

/* ARGSUSED */
void 
UntagAllLettersCallback(widget, clientData, callData)
	 Widget    widget;
	 XtPointer clientData;
	 XtPointer callData;
{
  SCREEN          *scn = (SCREEN*)clientData;
  Letter          *letter;
  int             i;
  
  AnimStart(scn);
  for (i = 0; (letter = scn->letterList[i]); i++)
	if (letter->status & LETTER_TAGGED) {
	  TagUntagLetterProc(scn, letter);
	  scn->folder.curLetN = letter->number;
	  Anim(scn);
	}

  /* Busy  pointer will be cleared in ReMakeToc */
  ReMakeToc(scn);
  Message(scn, "All letters untagged", MSG_CLEAR_DEFAULT);
}

/* ARGSUSED */
void 
RetagLettersCallback(widget, clientData, callData)
	 Widget    widget;
	 XtPointer clientData;
	 XtPointer callData;
{
  SCREEN          *scn = (SCREEN*)clientData;
  Letter          *letter;
  int             i, n;
  
  AnimStart(scn);
  for (i = 0, n = 0; (letter = scn->letterList[i]); i++)
	if (!(letter->status & LETTER_TAGGED) && letter->status & LETTER_RETAG) {
	  TagUntagLetterProc(scn, letter); n++;
	  scn->folder.curLetN = letter->number;
	  Anim(scn);
	}

  /* Busy  pointer will be cleared in ReMakeToc */
  if (n) ReMakeToc(scn);
  Message(scn, FmtString("%d letters retagged", n), MSG_CLEAR_DEFAULT);
}

/*---------------------------------------------------------------------------+
| Routines to delete/undelete letters.
+---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------+
| Delete letter routines.
+---------------------------------------------------------------------------*/

int
DeleteLetterProc(scn, letterN, clientData)
	 SCREEN          *scn;
	 int             letterN;
	 XtPointer       clientData;
{
  LETTER          *letter;

  CheckIfLetterOk(scn, letterN, -1);
  letter = scn->letterList[letterN];

  if (letter->status & LETTER_DELETED) return -1;
  letter->status |= LETTER_DELETED;
  scn->folder.changed = True;

  return 0;
}

/* ARGSUSED */
void 
DeleteLetterCallback(widget, clientData, callData)
	 Widget    widget;
	 XtPointer clientData;
	 XtPointer callData;
{
  SCREEN          *scn = (SCREEN*)clientData;
  int             tagNumSuccess;

  if (scn->folder.numTagged) {
	SimpleMessage(scn, FmtString("Delete %d tagged letters?", 
								  scn->folder.numTagged));
	if (BooleanPrompt(scn) == BP_NO) return;
	tagNumSuccess = OperateOnTeggedLetters(scn, DeleteLetterProc, callData);
	SimpleMessage(scn, FmtString("%d letters deleted", tagNumSuccess));
	return;
  }

  if (MarkLetterAsDeleted(scn, scn->folder.curLetN) < 0) return;
  SimpleMessage(scn, "Letter deleted");
}

/*---------------------------------------------------------------------------+
| Undelete letter routines.
+---------------------------------------------------------------------------*/

/* ARGSUSED */
int 
UndeleteLetterProc(scn, letterN, clientData)
	 SCREEN          *scn;
	 int             letterN;
	 XtPointer       clientData;
{
  LETTER          *letter;

  CheckIfLetterOk(scn, letterN, -1);
  letter = scn->letterList[letterN];

  if (!(letter->status & LETTER_DELETED)) return -1;
  letter->status &= ~LETTER_DELETED;
  scn->folder.changed = True;
  
  return 0;
}

/* ARGSUSED */
void 
UndeleteLetterCallback(widget, clientData, callData)
	 Widget    widget;
	 XtPointer clientData;
	 XtPointer callData;
{
  SCREEN          *scn = (SCREEN*)clientData;
  int             tagNumSuccess;

  if (scn->folder.numTagged) {
	SimpleMessage(scn, FmtString("Unelete %d tagged letters?", 
								  scn->folder.numTagged));
	if (BooleanPrompt(scn) == BP_NO) return;
	tagNumSuccess = OperateOnTeggedLetters(scn, UndeleteLetterProc, callData);
	SimpleMessage(scn, FmtString("%d letters undeleted", tagNumSuccess));
	return;
  }

  if (MarkLetterAsUndeleted(scn, scn->folder.curLetN) < 0) return;
  SimpleMessage(scn, "Letter undeleted");
}

int 
ComposeLetter(scn)
	 SCREEN *scn;
{
  ErrorIfEditOrDialogMode(scn, -1);
  if (PrepareDraft(scn, DRAFT_MODE_COMPOSE) < 0) return -1;

  XawTextDisableRedisplay(scn->bodyW);

  EditDraft(scn);
  MoveToStartOfBuffer(scn->bodyW);
  MoveToEndOfLine(scn->bodyW);

  XawTextEnableRedisplay(scn->bodyW);
  return 0;
}

/* ARGSUSED */
void 
ComposeLetterCallback(widget, clientData, callData)
	 Widget    widget;
	 XtPointer clientData;
	 XtPointer callData;
{
  ComposeLetter((SCREEN*)clientData);
}

int 
ReplyToLetter(scn)
	 SCREEN *scn;
{
  ErrorIfEditOrDialogMode(scn, -1);
  if (PrepareDraft(scn, DRAFT_MODE_REPLY) < 0) return -1;

  XawTextDisableRedisplay(scn->bodyW);

  EditDraft(scn);
  MoveToEndOfBuffer(scn->bodyW);
  MoveToStartOfLine(scn->bodyW);

  XawTextEnableRedisplay(scn->bodyW);
  return 0;
}

/* ARGSUSED */
void 
ReplyToLetterCallback(widget, clientData, callData)
	 Widget    widget;
	 XtPointer clientData;
	 XtPointer callData;
{
  ReplyToLetter((SCREEN*)clientData);
}

int
ForwardLetter(scn)
  SCREEN *scn;
{
  ErrorIfEditOrDialogMode(scn, -1);
  if (PrepareDraft(scn, DRAFT_MODE_COMPOSE) < 0) return -1;

  XawTextDisableRedisplay(scn->bodyW);

  EditDraft(scn);
  MoveToEndOfBuffer(scn->bodyW);
  MoveToStartOfLine(scn->bodyW);
  InsertText(scn->bodyW, "\n------- Forwarded Message\n\n");
  InsertLetterWhole(scn);
  InsertText(scn->bodyW, "\n------- End of Forwarded Message\n");
 
  MoveToStartOfBuffer(scn->bodyW);
  MoveToEndOfLine(scn->bodyW);

  XawTextEnableRedisplay(scn->bodyW);
  return 0;
}

/* ARGSUSED */
void 
ForwardLetterCallback(widget, clientData, callData)
	 Widget             widget;
	 XtPointer          clientData;
	 XtPointer          callData;
{
  ForwardLetter((SCREEN*)clientData);
}

/* ARGSUSED */
void
FollowUpToLetterCallback(widget, clientData, callData)
	 Widget             widget;
	 XtPointer          clientData;
	 XtPointer          callData;
{
  SCREEN          *scn = (SCREEN*)clientData;

  ErrorIfEditOrDialogMode(scn,);
  if (PrepareDraft(scn, DRAFT_MODE_FOLLOW_UP) < 0) return;

  XawTextDisableRedisplay(scn->bodyW);

  EditDraft(scn);
  MoveToEndOfBuffer(scn->bodyW);
  MoveToStartOfLine(scn->bodyW);

  XawTextEnableRedisplay(scn->bodyW);
}

/* ARGSUSED */
void
QuoteRnStyleAndReplyToLetterCallback(widget, clientData, callData)
	 Widget    widget;
	 XtPointer clientData;
	 XtPointer callData;
{
  if (ReplyToLetter((SCREEN*)clientData) < 0) return;
  QuoteRnStyleCallback(widget, clientData, callData);
}

/* ARGSUSED */
void
QuoteScStyleUnfmtAndReplyCallback(widget, clientData, callData)
	 Widget    widget;
	 XtPointer clientData;
	 XtPointer callData;
{
  if (ReplyToLetter((SCREEN*)clientData) < 0) return;
  NonNestedCitation((SCREEN*)clientData, CITE_UNFMT);
}

/* ARGSUSED */
void
QuoteScStyleFmtAndReplyCallback(widget, clientData, callData)
	 Widget    widget;
	 XtPointer clientData;
	 XtPointer callData;
{
  if (ReplyToLetter((SCREEN*)clientData) < 0) return;
  NonNestedCitation((SCREEN*)clientData, CITE_FMT);
}

int 
ExternalComposeLetter(scn)
	 SCREEN *scn;
{
  ErrorIfEditOrDialogMode(scn, -1);
  if (PrepareDraft(scn, DRAFT_MODE_COMPOSE) < 0) return -1;

  XawTextDisableRedisplay(scn->bodyW);

  ExternalEditFile(FileInMailDir(scn->draft.name));
  EditDraft(scn);

  XawTextEnableRedisplay(scn->bodyW);
  return 0;
}

/* ARGSUSED */
void 
ExternalComposeLetterCallback(widget, clientData, callData)
	 Widget    widget;
	 XtPointer clientData;
	 XtPointer callData;
{
  ExternalComposeLetter((SCREEN*)clientData);
}

#if 0
void 
ExternalReplyToLetterCallback(widget, clientData, callData)
	 Widget    widget;
	 XtPointer clientData;
	 XtPointer callData;
{
  SCREEN *scn = (SCREEN*)clientData;
  
  if (PrepaeDraft(scn, scn->draftName, True) < 0) return;
  ExternalEditFile(scn, scn->draftName);

  scn->draft.active = True;
  EditFileInBodyBox(scn, scn->draftName);
  DraftMenuAccess(scn, True);
}
#endif

/*---------------------------------------------------------------------------+
+----------------------------------------------------------------------------/
| Routines to move letters (Copy, Refile, Pipe).
+---------------------------------------------------------------------------*/

int
AppendLetterToFile(letter, file)
	 LETTER          *letter;
	 String          file;
{
  String           letterBuffer;
  int              retStatus;
 
  letterBuffer = ConstructLetter(letter, LETTER_MAKE_FOR_FOLDER);
  retStatus = AppendBufferToFile(file, letterBuffer);
  XtFree(letterBuffer);
  return retStatus;
}

int
AppendLetterToScreen(letter, scn)
	 LETTER          *letter;
	 SCREEN          *scn;
{
  String           letterBuffer;
  int              retStatus;
 
  letterBuffer = ConstructLetter(letter, LETTER_MAKE_FOR_FOLDER);
  letterBuffer = PrependToBuffer(letterBuffer,"\n\n");
  retStatus = AppendLettersFromBuffer(scn, letterBuffer);
  return retStatus;
}

int
PipeLetterToCommand(letter, command)
	 LETTER          *letter;
	 String          command;
{
  String           letterBuffer;
  int              retStatus;
 
  letterBuffer = ConstructLetter(letter, LETTER_MAKE_FOR_FOLDER);
  retStatus = PipeBufferToCommand(command, letterBuffer);
  XtFree(letterBuffer);
  return retStatus;
}

/*---------------------------------------------------------------------------+
| Copy letter routines.
+---------------------------------------------------------------------------*/

int
CopyLetterProc(scn, letterN, folder)
	 SCREEN          *scn;
	 int             letterN;
	 XtPointer       folder;
{
  LETTER          *letter;
  int             retStatus;
  SCREEN          *tmp_scn;
  int             open;

  CheckIfLetterOk(scn, letterN, -1);
  letter = scn->letterList[letterN];

  /* Check to see if folder being refiled to is already open */
  for(tmp_scn=FirstScreen(scn); tmp_scn; tmp_scn=NextScreen(tmp_scn))
	if (!(strcmp(FileFullName(tmp_scn->folder.name,tmp_scn->folder.path), 
                     folder)))
	   {
           open = True;
           break;
           };

  if (open)
     retStatus = AppendLetterToScreen(letter,tmp_scn);
  else
     retStatus = AppendLetterToFile(letter, (String)folder);

  if (retStatus < 0) {
	SimpleMessage(scn, FmtString("Error in refiling letter %d", letterN+1));
	return retStatus;
  }
  
  return 0;
}

/* ARGSUSED */
void 
CopyLetterCallback(widget, clientData, callData)
	 Widget    widget;
	 XtPointer clientData;
	 XtPointer callData;
{
  SCREEN          *scn = (SCREEN*)clientData;
  int             tagNumSuccess;
  String          fileName;

  if ((fileName = SelectFile(scn)) == NULL) return;

  if (FileIsPacked(fileName)) {
	SimpleMessage(scn, FmtString("Cannot append to compressed folder (%s)", 
								  FileBaseName(fileName)));
	return;
  }

  if (scn->folder.numTagged) {
 	SimpleMessage(scn, FmtString("Copy %d tagged letters to folder %s?", 
								  scn->folder.numTagged,
								  FileBaseName(fileName))); 
	if (BooleanPrompt(scn) == BP_NO) return;
	tagNumSuccess = OperateOnTeggedLetters(scn, CopyLetterProc,
										   (XtPointer)fileName); 
	SimpleMessage(scn, FmtString("%d letters copied to folder %s", 
								 tagNumSuccess, FileBaseName(fileName)));
	return;
  }

  if (CopyLetterProc(scn, scn->folder.curLetterN, fileName) < 0)
	SimpleMessage(scn, "Error in copying letter");
  else SimpleMessage(scn, FmtString("Letter copied to folder %s",
									 FileBaseName(fileName))); 
}

/*---------------------------------------------------------------------------+
| Refile letter routines.
+---------------------------------------------------------------------------*/

int
RefileLetterProc(scn, letterN, folder)
	 SCREEN          *scn;
	 int             letterN;
	 XtPointer       folder;
{
  LETTER          *letter;
  int             retStatus;
  SCREEN	  *tmp_scn;  
  int             open = False;

  CheckIfLetterOk(scn, letterN,-1);
  letter = scn->letterList[letterN];

  /* Check to see if folder being refiled to is already open */
  for(tmp_scn=FirstScreen(scn); tmp_scn; tmp_scn=NextScreen(tmp_scn))
	if (!(strcmp(FileFullName(tmp_scn->folder.name,tmp_scn->folder.path), 
                     folder)))
	   {
           open = True;
           break;
           };

  if (open)
     retStatus = AppendLetterToScreen(letter,tmp_scn);
  else
     retStatus = AppendLetterToFile(letter, (String)folder);

  if (retStatus < 0) {
	SimpleMessage(scn, FmtString("Error in refiling letter %d", letterN+1));
	return retStatus;
  }

  MarkLetterAsDeleted(scn, letterN);
  return 0;
}

/* ARGSUSED */
void 
RefileLetterCallback(widget, clientData, callData)
	 Widget             widget;
	 XtPointer          clientData;
	 XtPointer          callData;
{
  SCREEN          *scn = (SCREEN*)clientData;
  int             tagNumSuccess;
  String          fileName;

  if ((fileName = SelectFile(scn)) == NULL) return;

  if (FileIsPacked(fileName)) {
	SimpleMessage(scn, 
	FmtString("Cannot append to compressed folder you creep! (%s)", 
			   FileBaseName(fileName)));
	return;
  }

  if (scn->folder.numTagged) {
 	SimpleMessage(scn, FmtString("Refile %d tagged letters to folder %s?", 
				  scn->folder.numTagged,
				  FileBaseName(fileName))); 
	if (BooleanPrompt(scn) == BP_NO) return;
	tagNumSuccess = OperateOnTeggedLetters(scn, RefileLetterProc,
					   (XtPointer)fileName); 
	SimpleMessage(scn, FmtString(
      "%d letters refiled to folder %s, marked as deleted in current folder", 
		 tagNumSuccess, FileBaseName(fileName)));
	return;
  }

  if (RefileLetterProc(scn, scn->folder.curLetterN, fileName) < 0)
	SimpleMessage(scn, "Error in refiling letter");
  else SimpleMessage(scn, FmtString(
      "Letter refiled to folder %s, marked as deleted in current folder", 
		 FileBaseName(fileName)));
}
 
/*---------------------------------------------------------------------------+
| Pipe letter routines.
+---------------------------------------------------------------------------*/

int
PipeLetterProc(scn, letterN, command)
	 SCREEN          *scn;
	 int             letterN;
	 XtPointer       command;
{
  LETTER          *letter;
  
  CheckIfLetterOk(scn, letterN, -1);
  letter = scn->letterList[letterN];

  if (PipeLetterToCommand(letter, (String)command) < 0)
	SimpleErrorMsg(scn, FmtString("Error in piping letter %d", letterN+1), 
				   -1);
  return 0;
}

/* ARGSUSED */
void 
PipeLetterCallback(widget, clientData, callData)
	 Widget             widget;
	 XtPointer          clientData;
	 XtPointer          callData;
{
  SCREEN          *scn = (SCREEN*)clientData;
  int             tagNumSuccess;
  String          command;

  SimpleMessage(scn, "Enter command to pipe letter(s) to above");
  if ((command = DialogPrompt(scn)) == NULL) return;

  if (scn->folder.numTagged) {
	SimpleMessage(scn, 
	    FmtString("pipe %d tagged letters (one at a time) to command `%s'?", 
				   scn->folder.numTagged, command));
	if (BooleanPrompt(scn) == BP_NO) return;
	tagNumSuccess = OperateOnTeggedLetters(scn, PipeLetterProc,
										   (XtPointer)command); 
	SimpleMessage(scn, FmtString("%d letters piped to command `%s'", 
						 tagNumSuccess, command));
	return;
  }

  if (PipeLetterProc(scn, scn->folder.curLetterN, callData) < 0)
	SimpleMessage(scn, "Error in piping letter");
  else SimpleMessage(scn, FmtString("Letter piped to command `%s'",
									 command)); 
}
 
/*---------------------------------------------------------------------------+
| Print letter routines.
+---------------------------------------------------------------------------*/

int
PrintLetterProc(scn, letterN, dummy)
	 SCREEN          *scn;
	 int             letterN;
	 XtPointer       dummy;
{
  LETTER          *letter;
  
  CheckIfLetterOk(scn, letterN, -1);
  letter = scn->letterList[letterN];

  if (PipeLetterToCommand(letter, res.printCommand) < 0)
	SimpleErrorMsg(scn, FmtString("Error in printing %d", letterN+1), -1);
  return 0;
}

/* ARGSUSED */
void 
PrintLetterCallback(widget, clientData, callData)
	 Widget             widget;
	 XtPointer          clientData;
	 XtPointer          callData;
{
  SCREEN          *scn = (SCREEN*)clientData;
  int             tagNumSuccess;

  if (scn->folder.numTagged) {
	SimpleMessage(scn, FmtString("print %d tagged letters?", 
					  scn->folder.numTagged));
	if (BooleanPrompt(scn) == BP_NO) return;
	tagNumSuccess = OperateOnTeggedLetters(scn, PrintLetterProc,
										   (XtPointer)NULL); 
	SimpleMessage(scn, FmtString("%d letters printed", tagNumSuccess));
	return;
  }

  if (PrintLetterProc(scn, scn->folder.curLetterN, (XtPointer)NULL) < 0)
	SimpleMessage(scn, "Error in printing letter");
  else SimpleMessage(scn, "Letter printed");
}

/*---------------------------------------------------------------------------+
| Letter info routine.
+---------------------------------------------------------------------------*/

int 
LetterInfo(scn)
	 SCREEN *scn;
{
  Letter          *letter;
  String          message = FmtString("");

  if (scn->folder.curLetterN < 0) 
	{Message(scn, "No letter selected", MSG_CLEAR_DEFAULT); return -1;}

  CheckIfLetterOk(scn, scn->folder.curLetN,-1);
  letter = scn->letterList[scn->folder.curLetN];

  sprintf(message, "Current letter is #%d of %d%s%s%s%s ",
		  scn->folder.curLetterN + 1,
		  scn->folder.numLetters,
		  letter->status & LETTER_READ ? ", read" : ", unread",
		  letter->status & LETTER_REPLIED ? ", replied" : "",
		  letter->status & LETTER_DELETED ? ", deleted" : "",
		  letter->status & LETTER_TAGGED ? ", tagged" : "");

  SimpleMessage(scn, message);
  return 0;
}

/* ARGSUSED */
void 
LetterInfoCallback(widget, clientData, callData)
	 Widget    widget;
	 XtPointer clientData;
	 XtPointer callData;
{
  LetterInfo((SCREEN*)clientData);
}
