/* $Header: /vol/dwb/src/mumail-2.4b/RCS/MmDecl.h,v 1.2 1994/03/31 17:56:58 dwb Exp $ */
/*
 * $Log: MmDecl.h,v $
 * Revision 1.2  1994/03/31  17:56:58  dwb
 *  MuMail 2.4 Beta
 *
 * Revision 1.1  1993/11/15  18:52:37  dwb
 * Initial revision
 *
 *
 */

/*---------------------------------------------------------------------------+
| This file is part of Mumail, 
| Copyright (c) 1992-1993 by Muhammad M. Saggaf.
| Copyright (c) 1994 by David W. Boyd. All rights reserved
|
| See the file COPYING (1-COPYING) or the manual page mumail(1)
| for a full statement of rights and permissions.
+---------------------------------------------------------------------------*/

/*                               -*- Mode: C -*- 
 * MmDecl.h --- Declarations headers file
 * Author          : Muhammad M. Saggaf
 * Created On      : April 1993
 * Last Modified By: system admin
 * Last Modified On: Wed Jul  7 00:11:58 1993
 * Update Count    : 68
 * Status          : Mostly OK, needs some cleaning up
 */

#include "config.h"
#include <X11/Intrinsic.h>
#include <X11/Xaw/AsciiText.h>
#include <stdio.h>
#include <time.h>



#define MAX_SCREENS 10
#define BUFFER_INC 256
#define MAX_LETTERS 9999
#define MAX_HEADERS 256
#define MAX_ALIASES 256
#define MAX_FCC     256
#define REG_BUF 256				/* number of chars in message */

#define INFOLDER_NAME      "MUINBOX"
#define DRAFT_NAME         "draft"
#define SIG_FILE           ".signature"
#define HEADERS_FILE       "headers"
#define ALIASES_FILE       "aliases"

#define FROM_TITLE             "From:"
#define QUOTED_FROM_TITLE      ">From:"
#define TO_TITLE               "To:"
#define SUBJECT_TITLE          "Subject:"
#define DATE_TITLE             "Date:"
#define REPLY_TO_TITLE         "Reply-To:"
#define READ_TITLE             "Read:"
#define REPLIED_TITLE          "Replied:"
#define CC_TITLE               "cc:"
#define BCC_TITLE              "Bcc:"
#define FCC_TITLE              "Fcc:"
#define MIME_VERSION_TITLE     "MIME-Version:"
#define CONTENT_TYPE_TITLE     "Content-Type:"
#define CHAR_SET_TITLE         "charset="
#define BOUNDARY_TITLE         "boundary="
#define TRANSFER_ENCODING_TITLE "Content-Transfer-Encoding:"

#define curLetterN curLetN
#define DRAFT_NO_REPLY         -1
#define DRAFT_MODE_COMPOSE     1
#define DRAFT_MODE_REPLY       2
#define DRAFT_MODE_FOLLOW_UP   3

#define MIME_VERSION        "1.0"

#define LETTER_COMP_DELIMITER "-- letter body follows --"

#define QM_NO_MAILBOX_NAME   -10
#define QM_STAT_ERROR        -11
#define QM_MAILBOX_EMPTY     0
#define QM_MAILBOX_HAS_MAIL  1

#define TOC_CLEAR_FLAG     "-"
#define TOC_UNREAD_FLAG    "N"
#define TOC_READ_FLAG      TOC_CLEAR_FLAG
#define TOC_DEL_FLAG       "D"
#define TOC_REPL_FLAG      "R"
#define TOC_TAG_FLAG       "T"
#define TOC_MIME_FLAG      "M"

#define LETTER_NEW         (1<<1)
#define LETTER_UNREAD      (1<<2)
#define LETTER_READ        (1<<3)
#define LETTER_REPLIED     (1<<4)
#define LETTER_DELETED     (1<<5)
#define LETTER_TAGGED      (1<<6)
#define LETTER_RETAG       (1<<7)
#define LETTER_MIME        (1<<10)

#define LETTER_MAKE_BODY             1
#define LETTER_MAKE_PARTIAL          2
#define LETTER_MAKE_WHOLE            3
#define LETTER_MAKE_WITH_DELIMITER   4
#define LETTER_MAKE_FOR_FOLDER       5

#define CONTENT_TYPE_TEXT_PLAIN      1
#define CONTENT_TYPE_OTHER         100

#define MIME_TYPE_TEXT_PLAIN_S "text/plain"
#define MIME_TYPE_MULTIPART_MIXED_S "multipart/mixed"

#define MIME_INVOKE_NEVER     1
#define MIME_INVOKE_ALWAYS    2
#define MIME_INVOKE_ASK       3

#define MSG_CLEAR_NEVER     0
#define MSG_REMOVE_TIMER    0
#define MSG_CLEAR_DEFAULT  15	/* in seconds */

#define KEYBOARD_FOCUS_SET      1
#define KEYBOARD_FOCUS_RESTORE  2
#define KEYBOARD_FOCUS_CLEAR    3  

#define DP_OK                 1
#define DP_CANCEL             2
#define BP_YES                1
#define BP_NO                 2

#define CITE_UNFMT            1
#define CITE_FMT              2

#define SET_BUSY_POINTER       0
#define ANIMATE_BUSY_POINTER   1
#define CLEAR_BUSY_POINTER    10

#define DIALOG_INACTIVE        0
#define DIALOG_MODE_VALUE      1
#define DIALOG_MODE_BOOLEAN    2

#define SORT_ON_OPEN       (1<<1)
#define SORT_ON_SAVE       (1<<2)
#define SORT_ON_BURST      (1<<3)
#define SORT_ON_INC        (1<<4)
#define SORT_ON_COMMIT     (1<<5)

#define BUF10       10
#define BUF80       80
#define BUF256      256
#define BUFPAGE     4096

/*---------------------------------------------------------------------------+
| Macros.
+---------------------------------------------------------------------------*/

#define OpenStream(fp,name,mode,retValue)\
  {if ((fp = fopen(name, mode)) == NULL)\
     {MuPError(FmtString("Could not open file ``%s''", name));\
	  return retValue;}}

#define SetupTextBlock(var,text){\
  textBlock.ptr = text; textBlock.firstPos = 0;\
  textBlock.length = strlen(textBlock.ptr);\
  textBlock.format = FMT8BIT;}

#define SimpleMessage(scn,msg) Message(scn,msg,MSG_CLEAR_DEFAULT)
#define SimpleErrorMsg(scn,msg,ret) {SimpleMessage(scn,msg); return ret;}

#define SetKeyboardFocus(scn,widget)\
  KeyboardFocus(scn,widget,KEYBOARD_FOCUS_SET)
#define RestoreKeyboardFocus(scn)\
  KeyboardFocus(scn,(Widget)NULL,KEYBOARD_FOCUS_RESTORE)

#define EditMode(scn,mode)\
  {scn->edit.active = mode;\
   KeyboardFocus(scn, scn->bodyW, mode ? KEYBOARD_FOCUS_SET :\
				 KEYBOARD_FOCUS_RESTORE);\
   XtVaSetValues(scn->edit.buttonW, XtNsensitive, mode, NULL);}
#define DraftMode(scn,mode)\
  {scn->draft.active = mode;\
   XtVaSetValues(scn->draft.buttonW, XtNsensitive, mode, NULL);\
   EditMode(scn,mode);\
   XtVaSetValues(scn->edit.cancelW, XtNsensitive, !mode, NULL);}

#define LetterNumberOk(scn,letterN)\
  (!(letterN < 0 || letterN > scn->folder.numLetters - 1))
#define CheckIfLetterOk(scn,letterN,ret)\
  {if (!LetterNumberOk(scn,letterN)) return ret;}

#define ErrorIfEditOrDialogMode(scn,ret)\
  {if (scn->edit.active || scn->dialog.mode != DIALOG_INACTIVE) return ret;}
#define ErrorIfBodyBoxNotEditable(scn,ret)\
  {if (!BodyBoxEditable(scn)) return ret;}

#define PromptIffolderChanged(scn,action)\
  {if (scn->folder.changed) {\
	 action = Alert(0, scn->toc.tocW, "Current folder has changed",\
		 		   "Save | Discard | Cancel");\
	 if (action == 3) return;\
	 else if (action == 1)\
       SaveFolderCallback(scn->parentW, (XtPointer)scn, (XtPointer)NULL);\
  }}

#define AlertOkCancel(widget,msg) Alert(0, widget, msg, "OK | Cancel")
#define AlertYesNo(widget,msg) Alert(0, widget, msg, "Yes | No")

/*---------------------------------------------------------------------------+
| Structures.
+---------------------------------------------------------------------------*/

typedef int      (*SortProcT)();
typedef int      (*SearchProcT)();

typedef struct {
  String          name;
  String          path;

  String          *buffers;
  int		  buffs_used;

  int             numLetters;
  int             curLetN;
  int             curDispLetN;
  Boolean         changed;
  int             numTagged;

  SearchProcT     searchProc;
  String          searchKey;

  String          unused1;
  Boolean         unused3;
  Boolean         unused4;
} Folder;

typedef struct {
  String          fullS;
  time_t          timeU;
} Date;

typedef struct {
  String          mimeVersionS;
  int             mimeVersion;
  String          contentTypeS;
  int             contentType;
} Mime;

typedef struct {
  int             number;
  long            totalLength;

  String          delimiter;

  String          from;
  String          to;
  String          subject;
  String          cc;
  Date            date;
  String          replyTo;
  Mime            mime;

  String          otherHeaders;
  String          content;
  
  String          readS;
  String          repliedS;

  int             status;

  Boolean         unused1;
  Boolean         unused2;
  Boolean         unused3;
  Boolean         unused4;
  Boolean         unused5;
  Boolean         unused6;
  Boolean         unused7;
} Letter;

typedef struct {
  Widget          buttonW;
  String          name;
  String          tmpName;
  Boolean         active;
  int             replLetN;

  Boolean         unused1;
  Boolean         unused2;
  Boolean         unused3;
} Draft;

typedef struct {
  Widget          tocW;
  String          tocS;
  int             flagPos;
  
  Boolean         unused1;
  Boolean         unused2;
} Toc;

typedef struct {
  Widget          valueW;
  Widget          yesW;
  Widget          noW;
  Widget          cancelW;
  int             mode;

  Boolean         unused1;
  Boolean         unused2;
} Dialog;

typedef struct {
  Widget          buttonW;
  Widget          saveW;
  Widget          cancelW;

  String          fileName;
  Boolean         active;

  Boolean         unused1;
  Boolean         unused2;
  Boolean         unused3;
  Boolean         unused4;
} Edit;

typedef struct {
  XtPointer field[6];
} ClientDataRec;

typedef struct {
  int             number;
  Window          cursorW;

  Widget          topLevelW;
  Widget          parentW;
  Widget          panedW;
  Widget          labelW;
  Widget          bodyW;

  Folder          folder;
  Letter          *letterList[MAX_LETTERS];
  Draft           draft;

  Toc             toc;  
  Dialog          dialog;
  Edit            edit;
  ClientDataRec   clientDataRec1;
  /* Reserved for the dialog box internal use */
  ClientDataRec   clientDataRec2;

  Boolean         unused1;
  Boolean         unused2;
  Boolean         unused3;
  Boolean         unused4;

} SCREEN;

typedef struct {
  String          externalEditor;
  String          printCommand;
  String          signatureFile;

  Boolean         contentInToc;
  Boolean         folderBackup;

  Boolean         mailAgentPassAddress;
  String          mailAgentProgram;
  String          mailAgentArgs;

  String          mimeCommand;
  String          invokeMimeS;
  int             invokeMime;
  Boolean         addMimeHeaders;
  String          defaultContentType;
  String          defaultCharSet;
  String          defaultTransferEncoding;
  String          mimeBoundary;

  int             quoteFillColumn;
  String          quoteIndentString;
  String          quoteNestedAttribFmt;
  String          quoteNonNestedAttribFmt;

  String          sortWhenS;
  int             sortWhen;
  String          majorSortKeyS;
  String          minorSortKeyS;
  SortProcT       majorSortProc;
  SortProcT       minorSortProc;
  Boolean         sortDescending;
  int		  checkTime;
  String	  mailIcon;
  String	  nomailIcon;

  String          unused2;
  String          unused3;
  String          unused4;
  String          unused5;
  String          unused6;
  String          unused7;
  String          unused8;
  String          unused9;
} QueryResources;

typedef Draft DRAFT;
typedef Edit EDIT;
typedef Dialog DIALOG;
typedef Letter LETTER;
typedef Folder FOLDER;
typedef ClientDataRec _clientDataRec;

#define TOCW (scn->toc.tocW)

extern QueryResources res;

#ifndef __P
#ifdef __STDC__
#define __P(args) args
#define DOTDOTDOT ...
#else
#define __P(args) ()
#define DOTDOTDOT
#endif
#endif

extern String
                GetNewBuffer __P(( SCREEN *scn, String data)),
                GetTextSourceOfBodyBox __P(( SCREEN *scn)),

                ConstructLetter __P((LETTER *letter, int letterMakeFormat)),

                FormatParagraph __P((String buffer, int maxWidth)),
                GetTextSource __P((Widget textW, XawTextPosition startPos, XawTextPosition endPos)),
                GetCurrentTextSelection __P((Widget widget, int maxLen)),
                TextFindHeaderField __P(()),
		FindHeaderFieldFromFile __P((String fileName, String header)),

                BuildAddress __P((String header)),

                DialogPrompt __P((SCREEN *scn)),

                FileFullName __P((String name, String path)),
                FileBaseName __P((String fullName)),
                FolderFullName __P((SCREEN *scn)),
                FileInMumailDir __P((String fileName)),

                SelectFile __P((SCREEN *scn)),
                SetupTempFolder __P((String name)),

                TocLetterStatusSymbols __P((Letter *letter)),                

                XMailerMessage __P((void));

Dimension
		SeWidgetHeight __P((Widget widget)),
		SeWidgetWidth __P((Widget widget));

void
                FreeBuffers __P((SCREEN *scn)),
		SeSetWidgetHeight __P((Widget widget, Dimension height)),
		SeSetWidgetWidth __P((Widget widget, Dimension width));

Boolean
                BodyBoxEditable __P((SCREEN *scn));

extern int

                ExternalEditFileOfBodyBox __P((void)),

                PrepareDraft __P((SCREEN *scn, int mode)),

                QueryMailBox __P((SCREEN *scn, String *mailBoxName)),
                OpenFolder __P((SCREEN *scn, String folderName)),
                CommitChanges __P((SCREEN *scn)),

                DisplayLetterInBodyBox __P((SCREEN *scn, int letterN, int letterDisplayFormat)),
                DisplayLetterProc __P((SCREEN *scn, int letterN, int letterDisplayFormat)),
                DisplayCurLetterProc __P((SCREEN *scn, int letterDisplayFormat)),

                DeleteLetterProc __P((SCREEN *scn, int letterN, XtPointer clientData)),
                UndeleteLetterProc __P((SCREEN *scn, int letterN, XtPointer clientData)),
                ComposeLetter __P((SCREEN *scn)),
                ReplyToLetter __P((SCREEN *scn)),
                ForwardLetter __P((SCREEN *scn)),
                ExternalComposeLetter __P((SCREEN *scn)),
                CopyLetter __P((void)),
                RefileLetterProc __P((SCREEN *scn, int letterN, XtPointer folder)),
                DeleteLetter __P((void)),
                UndeleteLetter __P((void)),
                LetterInfo __P((SCREEN *scn)),

                BusyPointer __P((SCREEN *scn, int flag)),
                Anim __P((SCREEN *scn)),
                KeyboardFocus __P((SCREEN *scn, Widget widget, int flag)),
                BooleanPrompt __P((SCREEN *scn)),

                SetCurLetterNumber __P((SCREEN *scn)),

                ReadParseMailFile __P((void)),

                GetLettersFromFolder __P((SCREEN *scn, String folderName)),
                ActualOpenFolder __P((void)),
                WritefolderToDisk __P((SCREEN *scn, String folderName)),
                SaveFolder __P((SCREEN *scn, String folderName)),

                TocSetLetterFlag __P((SCREEN *scn, int letterN, String flag)),               
                MarkLetterAsRepliedTo __P((SCREEN *scn, int letterN)),
             
                InsertText __P((Widget textW, String textS)),        
                InsertFile __P((Widget textW, String fileName)),
   
                Alert __P((int type, Widget parentW, String message, String buttons));

extern XawTextPosition 
                FindEndOfLine __P((Widget textW, XawTextPosition startPos)),
                FindEndOfCurrentLine __P((Widget textW)),
                FindEndOfBuffer __P((Widget textW)),

                SearchForText __P((Widget textW, String textS, XawTextPosition startPos, XawTextPosition endPos, XawTextScanDirection direction)),
                ReplaceTextByPos __P((Widget textW, XawTextPosition startPos, XawTextPosition postEndPos, String replS)),
                ReplaceText __P((Widget textW, String origS, String replS, XawTextPosition startPos));

  
extern void
		SetIconState __P((SCREEN *scn)),
		SetIcon __P((Widget parent, int mail)),
                CloseWindow __P((SCREEN *scn)),
                QuickExit __P((SCREEN *scn)),
                ExitCallback __P((Widget widget, XtPointer clientData, XtPointer callData)),

                DisplayBufferInBodyBox __P((SCREEN *scn,String buffer)),
                DisplayFileInBodyBox __P((SCREEN *scn,String filename)),
                EditFileInBodyBox __P((SCREEN *scn,String filename)),

                EditDraft __P((SCREEN *scn)),
                CancelDraftCallback __P((Widget widget, XtPointer clientData, XtPointer callData)),
                NonNestedCitation __P((SCREEN *scn, int style)),
                InsertLetterWhole __P((SCREEN *scn)),
                InsertSignatureCallback __P((Widget widget, XtPointer clientData, XtPointer callData)),

                ParseFolderName __P((String fullName, String *name, String *path)),
                OpenFolderProc __P((SCREEN *scn, String folderName)),
                SortFolderByDefaultKeys __P((SCREEN *scn)),

                ViewLetterCallback __P((void)),
                DisplayCurLetterPartialCallback __P((Widget widget, XtPointer clientData, XtPointer callData)),
                TagUntagLetterCallback __P((Widget widget, XtPointer clientData, XtPointer callData)),
                RetagLettersCallback __P((Widget widget, XtPointer clientData, XtPointer callData)),
                DeleteLetterCallback __P((Widget widget, XtPointer clientData, XtPointer callData)),
                UndeleteLetterCallback __P((Widget widget, XtPointer clientData, XtPointer callData)),
                CopyLetterCallback __P((Widget widget, XtPointer clientData, XtPointer callData)),
                RefileLetterCallback __P((Widget widget, XtPointer clientData, XtPointer callData)),

                CompactFolder __P((SCREEN *scn)),

                Message __P((SCREEN *scn, String msg, int persistenceTime)),
                MessagePError __P((SCREEN *scn, String msg)),
                AnimStart __P((SCREEN *scn)),
                AnimStop __P((SCREEN *scn)),
                FileChooserCallback __P((void)),
                DisableDialogInput __P((SCREEN *scn)),
                DelayedCallback __P((void)),

                ScrollTextToLine __P((Widget textW, int lineN)),

                CallAction __P((Widget widget, String action, String *param, Cardinal numParam)),
                CallSimpleAction __P((Widget widget, String action)),
                MoveToStartOfLine __P((Widget textW)),
                MoveToEndOfLine __P((Widget textW)),
                MoveToNextLine __P((Widget textW)),
                MoveToPrevLine __P((Widget textW)),
                MoveToStartOfBuffer __P((Widget textW)),
                MoveToEndOfBuffer __P((Widget textW)),
                MoveToStartOfParagraph __P((Widget textW)),
                MoveToEndOfPage __P((Widget textW)),

                ReMakeToc __P((SCREEN *scn)),
                RedisplayToc __P((SCREEN *scn)),
                ScrollTocToLine __P((SCREEN *scn, int lineN)),
                TocHighlightLetter __P((SCREEN *scn, int letterN)),
                TocUpdateLetterStatusSymbols __P((SCREEN *scn, Letter *letter)),

                ClearCutBufferAction __P((Widget widget, XEvent *event, String *param, Cardinal *numParam)),
                SetCurLetterNumberAction __P((Widget widget, XEvent *event, String *param, Cardinal *numParam)),
                ViewCurLetterAction __P((void)),
                IncCurLetterNumberAction __P((Widget widget, XEvent *event, String *param, Cardinal *numParam)),
                DecrCurLetterNumberAction __P((Widget widget, XEvent *event, String *param, Cardinal *numParam)),

                DisplayLogo __P((SCREEN *scn)),

                HighlightCurrentLine __P((Widget textW)),
                HighlightToEndOFLine __P((Widget widget));

/*---------------------------------------------------------------------------+
| Callbacks.
+---------------------------------------------------------------------------*/

extern void

         NotImplementedCallback __P((Widget widget, XtPointer clientData, XtPointer callData)),
         NewWindowCallback __P((Widget widget, XtPointer clientData, XtPointer callData)),
         CloseWindowCallback __P((Widget widget, XtPointer clientData, XtPointer callData)),
         IconifyWindowCallback __P((Widget widget, XtPointer clientData, XtPointer callData)),
         ExitCallback __P((Widget widget, XtPointer clientData, XtPointer callData)),
         QuickExitCallback __P((Widget widget, XtPointer clientData, XtPointer callData)),

         CheckMailBoxCallback __P((Widget widget, XtPointer clientData, XtPointer callData)),
         IncorporateNewMailCallback __P((Widget widget, XtPointer clientData, XtPointer callData)),
         OpenFolderCallback __P((Widget widget, XtPointer clientData, XtPointer callData)),
         OpenFolderViaFileChooserCallback __P((void)),
         ReOpenFolderCallback __P((Widget widget, XtPointer clientData, XtPointer callData)),
         OpenFolderInNextScreenCallback __P((Widget widget, XtPointer clientData, XtPointer callData)),
         NewFolderCallback __P((Widget widget, XtPointer clientData, XtPointer callData)),
         SaveFolderCallback __P((Widget widget, XtPointer clientData, XtPointer callData)),
         SaveFolderAsCallback __P((Widget widget, XtPointer clientData, XtPointer callData)),
         SaveFolderAsCompressedCallback __P((Widget widget, XtPointer clientData, XtPointer callData)),
         SaveFolderAsGZippedCallback __P((Widget widget, XtPointer clientData, XtPointer callData)),
         SaveFolderAsUnpackedCallback __P((Widget widget, XtPointer clientData, XtPointer callData)),
         EditFolderCallback __P((Widget widget, XtPointer clientData, XtPointer callData)),
         DeleteFolderCallback __P((Widget widget, XtPointer clientData, XtPointer callData)),
         CommitChangesCallback __P((Widget widget, XtPointer clientData, XtPointer callData)),
         SortFolderCallback __P((Widget widget, XtPointer clientData, XtPointer callData)),
         SetSortMajorKeyCallback __P((Widget widget, XtPointer clientData, XtPointer callData)),
         SetSortMinorKeyCallback __P((Widget widget, XtPointer clientData, XtPointer callData)),
         ToggleSortDirectionCallback __P((Widget widget, XtPointer clientData, XtPointer callData)),
         SearchFolderByHeadersCallback __P((Widget widget, XtPointer clientData, XtPointer callData)),
         SearchFolderByWholeLetterCallback __P((Widget widget, XtPointer clientData, XtPointer callData)),
         SearchFolderNextCallback __P((Widget widget, XtPointer clientData, XtPointer callData)),
         FolderInfoCallback __P((Widget widget, XtPointer clientData, XtPointer callData)),
         RedisplayTocCallback __P((Widget widget, XtPointer clientData, XtPointer callData)),
         ReDrawTocCallback __P((Widget widget, XtPointer clientData, XtPointer callData)),

         DisplayCurLetterPartialCallback __P((Widget widget, XtPointer clientData, XtPointer callData)),
         DisplayCurLetterWholeCallback __P((Widget widget, XtPointer clientData, XtPointer callData)),
         DisplayLetterPartialInNextScreenCallback __P((Widget widget, XtPointer clientData, XtPointer callData)),
         PipeLetterToMimeCommandCallback __P((Widget widget, XtPointer clientData, XtPointer callData)),
         ComposeLetterCallback __P((Widget widget, XtPointer clientData, XtPointer callData)),
         ReplyToLetterCallback __P((Widget widget, XtPointer clientData, XtPointer callData)),
         ForwardLetterCallback __P((Widget widget, XtPointer clientData, XtPointer callData)),
         FollowUpToLetterCallback __P((Widget widget, XtPointer clientData, XtPointer callData)),
         QuoteScStyleFmtAndReplyCallback __P((Widget widget, XtPointer clientData, XtPointer callData)),
         QuoteScStyleUnfmtAndReplyCallback __P((Widget widget, XtPointer clientData, XtPointer callData)),
         QuoteRnStyleAndReplyToLetterCallback __P((Widget widget, XtPointer clientData, XtPointer callData)),
         ExternalComposeLetterCallback __P((Widget widget, XtPointer clientData, XtPointer callData)),
         ExternalReplyToLetterCallback __P((void)),
         LetterInfoCallback __P((Widget widget, XtPointer clientData, XtPointer callData)),

         TagAllLettersCallback __P((Widget widget, XtPointer clientData, XtPointer callData)),
         TagRangeOfLettersCallback __P((Widget widget, XtPointer clientData, XtPointer callData)),
         UntagAllLettersCallback __P((Widget widget, XtPointer clientData, XtPointer callData)),
         PipeLetterCallback __P((Widget widget, XtPointer clientData, XtPointer callData)),
         PrintLetterCallback __P((Widget widget, XtPointer clientData, XtPointer callData)),
         BurstDefactoDigestCallback __P((Widget widget, XtPointer clientData, XtPointer callData)),
         BurstGrottyDigestCallback __P((Widget widget, XtPointer clientData, XtPointer callData)),

         SendDraftCallback __P((Widget widget, XtPointer clientData, XtPointer callData)),
         ExpandAliasesCallback __P((Widget widget, XtPointer clientData, XtPointer callData)),
         ExpandMimeInclusionsCallback __P((Widget widget, XtPointer clientData, XtPointer callData)),
         QuoteScStyleFmtCallback __P((Widget widget, XtPointer clientData, XtPointer callData)),
         QuoteScStyleUnfmtCallback __P((Widget widget, XtPointer clientData, XtPointer callData)),
         QuoteRnStyleCallback __P((Widget widget, XtPointer clientData, XtPointer callData)),
         InsertSignatureCallback __P((Widget widget, XtPointer clientData, XtPointer callData)),
         InsertLetterBodyCallback __P((Widget widget, XtPointer clientData, XtPointer callData)),
         InsertLetterPartialCallback __P((Widget widget, XtPointer clientData, XtPointer callData)),
         InsertLetterWholeCallback __P((Widget widget, XtPointer clientData, XtPointer callData)),
         CancelDraftCallback __P((Widget widget, XtPointer clientData, XtPointer callData)),

         GotoEditCallback __P((Widget widget, XtPointer clientData, XtPointer callData)),
         EditSaveCallback __P((Widget widget, XtPointer clientData, XtPointer callData)),
         EditCancelCallback __P((Widget widget, XtPointer clientData, XtPointer callData)),
         EditCutCallback __P((Widget widget, XtPointer clientData, XtPointer callData)),
         EditCutEolCallback __P((Widget widget, XtPointer clientData, XtPointer callData)),
         EditPasteCallback __P((Widget widget, XtPointer clientData, XtPointer callData)),
         EditSearchCallback __P((Widget widget, XtPointer clientData, XtPointer callData)),
         EditInsertFileCallback __P((Widget widget, XtPointer clientData, XtPointer callData)),
         EditFormatCallback __P((Widget widget, XtPointer clientData, XtPointer callData)),
         EditRedrawCallback __P((Widget widget, XtPointer clientData, XtPointer callData)),
         ExternalEditFileOfBodyBoxCallback __P((Widget widget, XtPointer clientData, XtPointer callData)),

         EditCustomHeadersCallback __P((Widget widget, XtPointer clientData, XtPointer callData)),
         EditAliasesCallback __P((Widget widget, XtPointer clientData, XtPointer callData)),
         ViewAnyFileCallback __P((Widget widget, XtPointer clientData, XtPointer callData)),
         EditAnyFileCallback __P((Widget widget, XtPointer clientData, XtPointer callData)),

         HelpAllCallback __P((Widget widget, XtPointer clientData, XtPointer callData)),
         HelpOverviewCallback __P((Widget widget, XtPointer clientData, XtPointer callData)),
         HelpOptionsCallback __P((Widget widget, XtPointer clientData, XtPointer callData)),
         HelpResourcesCallback __P((Widget widget, XtPointer clientData, XtPointer callData)),
         HelpMailAgentsCallback __P((Widget widget, XtPointer clientData, XtPointer callData)),
         HelpAliasesCallback __P((Widget widget, XtPointer clientData, XtPointer callData)),
         HelpMimeCallback __P((Widget widget, XtPointer clientData, XtPointer callData)),
         HelpMenusCallback __P((Widget widget, XtPointer clientData, XtPointer callData)),
         HelpBindingsCallback __P((Widget widget, XtPointer clientData, XtPointer callData)),
         HelpQuickKeysCallback __P((Widget widget, XtPointer clientData, XtPointer callData)),
         HelpFilesCallback __P((Widget widget, XtPointer clientData, XtPointer callData)),
         HelpBugsCallback __P((Widget widget, XtPointer clientData, XtPointer callData)),
         HelpCopyrightCallback __P((Widget widget, XtPointer clientData, XtPointer callData)),
         HelpAuthorCallback __P((Widget widget, XtPointer clientData, XtPointer callData)),
         HelpAckCallback __P((Widget widget, XtPointer clientData, XtPointer callData)),
	DisplayCurLetterPartialCallback __P((Widget widget, XtPointer clientData, XtPointer callData)),
        DisplayCurLetterWholeCallback __P((Widget widget, XtPointer clientData, XtPointer callData)),
         HelpNewsCallback __P((Widget widget, XtPointer clientData, XtPointer callData));
extern SCREEN
                *AddScreen __P((Widget topLevelW, String folderName)),
                *FirstScreen __P((SCREEN *scn)),
                *NextScreen __P((SCREEN *scn)),
                *WidgetToScn __P((Widget widget)),
                *NewWindowProc __P((SCREEN *scn, String folder));
