/*////////////////////////////////////////////////////////////////////////
Copyright (c) 1991 Electrotechnical Laboratry (ETL)

Permission to use, copy, modify, and distribute this material 
for any purpose and without fee is hereby granted, provided 
that the above copyright notice and this permission notice 
appear in all copies, and that the name of ETL not be 
used in advertising or publicity pertaining to this 
material without the specific, prior written permission 
of an authorized representative of ETL.
ETL MAKES NO REPRESENTATIONS ABOUT THE ACCURACY OR SUITABILITY 
OF THIS MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED "AS IS", 
WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES.
/////////////////////////////////////////////////////////////////////////
Content-Type:	program/C; charset=US-ASCII
Program:	xhist.c (XHIST command for NNTP)
Author:		Yutaka Sato <ysato@etl.go.jp>
Description:

    XHIST [<Message-ID>|selector]

    selector is list of:
	YYMMDD:HHMMSS[-YYMMDD:HHMMSS]	History range
	$				Last(latest) history line
	ENDLESS	[FILTER]		endless loop

#	/regular-expression/		History lines matches the exp.
#	+nnn				Ignore arts before nnn'th art.
#	-nnn				Ignore arts after nnn'th art.
#	! selector

    e.g.,
	XHIST <123@etl.go.jp>	retrieve subject of <123@etl.go.jp>
	XHIST 900701			retrieve since 1990 Jul. 1

	This command is an extention, and not included in RFC 977.

History:
	87xxxx	created as a part of vin (Bnews-2.11.17 format)
	900220	extracted to be a part of nntpd 
	900418	added Bnews-2.11.18 format
	900727	added "$" command
	910618	added Cnews arrivaldate-expiredate format
 V1.1	930522	added "ENDLESS" command
///////////////////////////////////////////////////////////////////////*/

#include "common.h"
#define INCLUDE_DONE

extern int (*xnntp_rstat)();
extern int (*xnntp_rbody)();
#define RSTAT	(*xnntp_rstat)
#define RBODY	(*xnntp_rbody)
extern char XHIST_LASTLINE_COMMAND[];

static char *usage =
"Usage: XHIST {<Message-Id>|YYMMDD:HHMMSS[-YYMMDD:HHMMSS]|$|ENDLESS}";
static putusg(){ RSTAT(ERR_CMDSYN,"%s",usage); }
#define ENDLESS	"ENDLESS"

xhist(ac,av)
	char *av[];
{	int i;

	if(ac <= 1){
		putusg();
		fflush(stdout);
	}else
	if( strcmp(av[1],"ENDLESS") == 0 ){
		xhist_endless(av[2]);
	}else
	switch(av[1][0]){
		default:
			if( strcmp(av[1],XHIST_LASTLINE_COMMAND) == 0 ){
				xhist_tail();
				break;
			}
			xhist_by_date_range(av[1]);
			break;
		case '<':
			xhist_by_message_id(av[1]);
			break;
		case '/':
			putusg();
			break;
	}
	fflush(stdout);
}

static xhist_tail(){
	char line[2048];

	historyLastLine(HISTORY_FILE,line);
	if( *line )
		RSTAT(OK_HEAD,  "%s",line);
	else	RSTAT(ERR_NOART,"Cant access last article");
}

static xhist_endless(filter)
	char *filter;
{	FILE *fp;
	char line[2048];

	fp = fopen(HISTORY_FILE,"r");
	if( fp == NULL )
		return putusg();

	comp_histfilter(filter);

	RSTAT(OK_HEAD,"selected history lines follow");
	fseek(fp,0,2);

	for(;;){
		if( fgets(line,sizeof(line),fp) == NULL ){
			clearerr(fp);
			/* check inode, reopen if changed */
			fseek(fp,0,2);
			sleep(5);
			continue;
		}
		if( exec_histfilter(line) == 0 )
			RBODY(line);
	}
}

#ifdef _IOFBF
#define SETBUFER(fp,buf,size)	setvbuf(fp,hbuf,_IOFBF,size)
#else
#define SETBUFER(fp,buf,size)	setbuffer(fp,hbuf,size)
#endif

static xhist_by_date_range(drange)
	char *drange;
{
	int fromdate,fromtime,todate,totime;
	char line[1000],hbuf[512];
	FILE *fp,*xfp;
	int offset;

	fromdate = 0; fromtime = 0;
	todate = 991231; totime = 246000;
	if(sscanf(drange,"%d:%d-%d:%d",&fromdate,&fromtime,&todate,&totime)==0){
		putusg();
		return;
	}

	fp = fopen(HISTORY_FILE,"r");
	if(fp == NULL){
		putusg();
		return;
	}

	RSTAT(OK_HEAD,"selected history lines follow");
	SETBUFER(fp,hbuf,sizeof(hbuf));

	offset = history_bsearchx(fp,fromdate,fromtime);
	xfp = fdopen(fileno(fp),"r");
	fseek(xfp,offset,0);
	while( fgets(line,sizeof(line),xfp) != NULL )
		RBODY(line);
	RBODY(0);
	fclose(xfp);
	fclose(fp);
}
static history_bsearchx(fp,xdate,xtime)
	FILE *fp;
{	int xclock;

	xclock = TimeGm(xdate/10000,(xdate/100)%100,xdate%100,
		      xtime/10000,(xtime/100)%100,xtime%100);
	return history_bsearch(fp,xclock);
}

static xhist_by_message_id(mid)
	char *mid;
{	char xmid[1000],line[10000];

	if(*mid != '<')
		sprintf(xmid,"<%s>",mid);
	else	strcpy(xmid,mid);

	if( 0 < historyByMessageID(HISTORY_FILE,xmid,line,sizeof(line)))
		RSTAT(OK_HEAD,  "%s",line);
	else	RSTAT(ERR_NOART,"No article by message-id %s",xmid);
}
/*////////////////////////////////////////////////////////////////////////
Copyright (c) 1992 Electrotechnical Laboratry (ETL)

Permission to use, copy, modify, and distribute this material 
for any purpose and without fee is hereby granted, provided 
that the above copyright notice and this permission notice 
appear in all copies, and that the name of ETL not be 
used in advertising or publicity pertaining to this 
material without the specific, prior written permission 
of an authorized representative of ETL.
ETL MAKES NO REPRESENTATIONS ABOUT THE ACCURACY OR SUITABILITY 
OF THIS MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED "AS IS", 
WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES.
/////////////////////////////////////////////////////////////////////////
Content-Type:	program/C; charset=US-ASCII
Program:	xnntps.c (xnntp server library)
Author:		Yutaka Sato <ysato@etl.go.jp>
Description:
History:
 V2.0	930822	added logging
 V2.0	930822	added XHEAD with NHC
///////////////////////////////////////////////////////////////////////*/
char *xnntp_version = "2.2 (7 January 94)";

#ifndef INCLUDE_DONE
#include "common.h"

FILE *open_article();

extern  int	(*xnntp_rstat)();
extern  int	(*xnntp_rbody)();
#define RSTAT	(*xnntp_rstat)
#define RBODY	(*xnntp_rbody)
#endif

#ifndef XNNTP_LOGFILE
#define XNNTP_LOGFILE "/tmp/xnntp.log"
#endif

static xhelp(){
	RSTAT(INF_HELP,"This server accepts the following commands:");
	RBODY("XLIST [difference]       LIST [only changed] groups.\n");
	RBODY("XHIST {msgid,date-spec}  Retrieve the history file.\n");
#ifdef XMIME
	RBODY("XMIME {enable/disable}   Control MIME decoder.\n");
#endif
#ifdef NHCLIB
	RBODY("XHEAD group:art-NO       Get an article header outof CACHE.\n");
#endif
	RBODY("QUIT                     Disconnect.\n");
	RBODY("\n");
	RBODY("Send bugs to Yutaka Sato <ysato@etl.go.jp>\n");
	RBODY(0);
}

static int logged;
xnntp(ac,av)
	char *av[];
{	char *com;

	com = av[0];
	if( strcmp(com,"xuser") == 0) xuser(ac,av); else
	if( strcmp(com,"xhist") == 0) xhist(ac,av); else
	if( strcmp(com,"xlist") == 0) xlist(ac,av); else
#ifdef XMIME
	if( strcmp(com,"xmime") == 0) xmime(ac,av); else
#endif
#ifdef NHCLIB
	if( strcmp(com,"xhead") == 0) xhead(ac,av); else
#endif
	if( strcmp(com,"help" ) == 0) xhelp(ac,av); else
	if( strcmp(com,"quit" ) == 0) xquit(ac,av); else xerror(ac,av);

	if( logged == 0 )
		xnntp_login();
}

static xnntp_rstat0(code,form,a,b,c,d,e,f,g){
	printf("%d ",code);
	printf(form,a,b,c,d,e,f,g);
	printf("\r\n",code);

	if( code != OK_HEAD )
		fflush(stdout);
}
static xnntp_rbody0(line){
	if(line)
		fputs(line,stdout);
	else{
		puts(".");
		fflush(stdout);
	}
}

int (*xnntp_rstat)() = xnntp_rstat0;
int (*xnntp_rbody)() = xnntp_rbody0;

/*
 *	user, tty, TERM, host, command, time
 */
static char xutmp[256];
xuser(ac,av)
	char *av[];
{	FILE *lfp;
	int ai;

	lfp = fopen(XNNTP_LOGFILE,"a");
	if( lfp != NULL ){
		RSTAT(OK_AUTH,   "%s","user log added.");
		fclose(lfp);
		for( ai = 1; ai < ac; ai++ ){
			strcat(xutmp,av[ai]);
			strcat(xutmp," ");
		}
	}else	RSTAT(ERR_NOAUTH,"%s","cannot write log.");
}

xnntp_login(){
#ifdef XNNTP_UTMP
	if( xutmp[0] == 0 )
		sprint_xutmp(xutmp,"?");
	add_xutmp(XNNTP_UTMP,"LOGIN", xutmp);
	logged = 1;
#endif
}
xnntp_logout(){
#ifdef XNNTP_UTMP
	add_xutmp(XNNTP_UTMP,"LOGOUT",xutmp);
#endif
}

xnntp_startmsg(){
	char host[1024];

	gethostname(host,sizeof(host));
	RSTAT(OK_NOPOST,"%s XNNTP server version %s ready.",
		host,xnntp_version);
}
static xerror(ac,av)
	char *av[];
{
	RSTAT(ERR_CMDSYN,"Unknown Command: %s %s",av[0],av[1]);
}
static xquit(){
	RSTAT(OK_GOODBYE,"bye.");
	xnntp_logout();
	exit(0);
}

static int previous_mtime;
static char *previous_active;
static xlist(ac,av)
	char *av[];
{	FILE *fp;
	char *active,*line,*prev,linebuff[2048];
	int mtime,actsize,leng;

	if((fp = fopen(ACTIVE_FILE,"r")) == NULL){
		RSTAT(ERR_FAULT,"Cannot open active file.");
		return;
	}

	mtime = FileMtime(fp);
	RSTAT(OK_GROUPS,
		"%d Newsgroups in form \"group high low y/n/m\".",mtime);

	if( ac == 2 && strcmp(av[1],"difference") == 0 ){
		if( mtime != previous_mtime ){
			prev = previous_active;
			actsize = FileSize(fp) + 1;
			active = (char*)malloc(actsize);

			line = active;
			while( 1 < actsize && fgets(line,actsize,fp) != NULL ){
				leng = strlen(line);
				if( prev == 0 || strncmp(line,prev,leng) != 0 )
					RBODY(line);
				if( prev != 0 && (prev = index(prev,'\n')) )
					prev++;
				line += strlen(line);
				actsize -= leng;
			}
			if( previous_active )
				free(previous_active);
			previous_active = active;
			previous_mtime = mtime;
		}
	}else{
		while( fgets(linebuff,sizeof(linebuff),fp) != NULL )
			RBODY(linebuff);
	}
	RBODY(0);
	fclose(fp);
}



#ifdef NHCLIB
static char LastGroup[256];
static int LastAnum;
static int BENCH = 0;


xhead(ac,av)
	char *av[];
{	char head_cache1[0x10000],head_cache2[0x10000],*head = head_cache1;
	char msgid[512];
	int bytes;
	FILE *fp = 0;

if(BENCH){
	bytes = 256;
	head = head_cache1;
	sprintf(head,"%-255s\n","Message-ID: <1234>\n");
	goto OUT;
}
	init_nhc();
	if( ac == 2 ){
		if( index(av[1],':') )
			sscanf(av[1],"%[^:]:%d",LastGroup,&LastAnum);
		else	LastAnum = atoi(av[1]);
	}
	bytes = nhc_get(LastGroup,LastAnum,head_cache1);

	if( 0 < bytes ){
		head = head_cache1;
	}else
	if( bytes < 0 ){
		RSTAT(ERR_FAULT,"it seems to be cancelled.");
		return;
	}else
	if( fp = open_article(LastGroup,LastAnum,head_cache1) ){
/*
		MIME_strHeaderDecode(head_cache1,head_cache2);
		nhc_put(LastGroup,LastAnum,head_cache2);
*/
/*
extern int COOK_MIME_HDR;
if( COOK_MIME_HDR )
	head = head_cache2;
else	head = head_cache1;
*/
		head = head_cache1;
	}else{
		nhc_cancel(LastGroup,LastAnum);
		RSTAT(ERR_FAULT,"it might be cancelled.");
		return;
	}

OUT:
	get_field(head,"Message-ID: ",msgid);
	RSTAT(OK_HEAD,"%d %s Article retrieved: fields follow:",
		LastAnum,msgid);
	RBODY(head);
	RBODY(0);

	if( fp ){
		/* should append
			Arrival-Date:
			Parent-Xref:
		*/
		nhc_fput(LastGroup,LastAnum,fp);
		fclose(fp);
	}
}


static get_field(head,field,buff)
	char *head,*field,*buff;
{	char *hp,hc,*bp;
	int flen;

	*buff = 0;
	flen = strlen(field);

	for( hp = head; hc = *hp; hp++ ){
		if( *field == hc && strncmp(hp,field,flen) == 0 ){
			bp = buff;
			for( hp += flen; hc = *hp; hp++ ){
				if( hc == '\n' || hc == '\r' ){
					*bp = 0;
					break;
				}
				*bp++ = hc;
			}
			return;
		}
		if( (hp = index(hp,'\n')) == 0 )
			break;
	}
}


char *STRING_ALLOC(s){ return strcpy(malloc(strlen(s)+1),s); }
mkdirr_silently(path,mode){ }
cosmos_bugreport(){ exit(1); }
news_active_first(){ return 1; }
dbg_printf(){ }
char *rstrcat(d,s) char *d; { strcpy(d,s); return d+strlen(d); }

int (*CODEC_message)();
int (*NHC_message)();
static nhc_message(fmt,a,b,c,d,e,f,g){
/*
	fprintf(stderr,fmt,a,b,c,d,e,f,g);
	fprintf(stderr,"\n");
*/
}

char *
newshead_cachedir(dir,len) char *dir; { strcpy(dir,XHEAD_CACHE); return dir; }
char *(*NEWSHEAD_CACHEDIR)() = newshead_cachedir;
init_nhc(){
	NHC_message = nhc_message;
	CODEC_message = nhc_message;
}

#endif
/*////////////////////////////////////////////////////////////////////////
Copyright (c) 1992 Electrotechnical Laboratry (ETL)

Permission to use, copy, modify, and distribute this material 
for any purpose and without fee is hereby granted, provided 
that the above copyright notice and this permission notice 
appear in all copies, and that the name of ETL not be 
used in advertising or publicity pertaining to this 
material without the specific, prior written permission 
of an authorized representative of ETL.
ETL MAKES NO REPRESENTATIONS ABOUT THE ACCURACY OR SUITABILITY 
OF THIS MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED "AS IS", 
WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES.
/////////////////////////////////////////////////////////////////////////
Content-Type:	program/C; charset=US-ASCII
Program:	history.c (news history scanner)
Author:		Yutaka Sato <ysato@etl.go.jp>
Description:
History:
	920921	extracted out of xhist.c
///////////////////////////////////////////////////////////////////////*/
#ifndef INCLUDE_DONE

/* select dbm/ndbm/dbz and CNEWS/BNEWS */
#ifdef WITHNNTP
#include "common.h"
#else
#include <ndbm.h>
#include <sys/types.h>
#include <sys/stat.h>
#endif

#include <stdio.h>
#endif

#if defined(CNEWS) || defined(Cnews)
int IS_CNEWS = 1;
#else
int IS_CNEWS = 0;
#endif


#if defined(Cnews) || defined(CNEWS) || !defined(_DBM_RDONLY) /* dbm or dbz */
#define DBMINIT(name)	dbminit(name)
#define	DBMCLOSE()	dbmclose()
#define DBMFETCH(key)	fetch(key)
datum fetch();

#else /* maybe ndbm */
DBM *Hdbm;
#define	DBMINIT(name)	((Hdbm = dbm_open(name,0,0)) == 0 ? -1:0)
#define	DBMCLOSE()	dbm_close(Hdbm)
#define DBMFETCH(key)	dbm_fetch(Hdbm,key)

#endif /* DBM selection */


historyByMessageID(history,mid,line,linesize)
	char *history,*mid,*line;
{	FILE *HFP;	/* History File		*/
	datum key,data;
	int offset;
	unsigned char *cp,midb[1000];

	if( DBMINIT(history) < 0 )
		return 0;

	mid = (char*)strcpy(midb,mid);
	if( IS_CNEWS ){
		if( cp = (unsigned char *)rindex(mid,'@') )
			xhist_tolowers(cp);
	}else	xhist_tolowers(mid);

	key.dptr = mid;
	key.dsize = strlen(key.dptr) + 1;
	data.dptr = 0;
	data = DBMFETCH(key);
	DBMCLOSE();

	if(data.dptr == 0)
		return -1;

	if(cp = (unsigned char*)data.dptr){
		if((HFP = fopen(history,"r")) == NULL)
			return 0;
		offset = cp[0]<<24 | cp[1]<<16 | cp[2]<<8 | cp[3];
		fseek(HFP,offset,0);
		fgets(line,linesize,HFP);
		fclose(HFP);
		linesize = strlen(line);
		if(linesize && line[linesize-1] == '\n')
			line[linesize-1] = 0;
		return 1;
	}
	return 0;
}
historyLastLine(history,line)
	char *history,*line;
{	FILE *fp;
	char buf[2048],*bp;

	*line = 0;
	fp = fopen(history,"r");
	if( fp != NULL ){
		fseek(fp,-sizeof(buf)+2,2);
/* 92-07-24 THE LONGEST LIFE BUG MEMORIAL !!
		fscanf(fp,"%[^\377]",buf); */

		fgets(buf,sizeof(buf),fp);
		while( fgets(buf,sizeof(buf),fp) != NULL )
			if( buf[strlen(buf)-1] == '\n' ){
				buf[strlen(buf)-1] = 0;
				strcpy(line,buf);
			}
		fclose(fp);
	}
}
history_bsearch(fp,date)
	FILE *fp;
{	int fsize,offs,offset;
	int itime;
	char line[1000];

	fsize = FileSize(fp);
	offs = fsize / 2;
	fseek(fp,offs,0);
	offset = 0;

	while( 80 < offs ){
		fgets(line,sizeof(line),fp);
		offset = ftell(fp);
		fgets(line,sizeof(line),fp);
		itime = decomp_history_line(line,0,0);
		if( itime <= 0 )
			return fsize;

		offs /= 2;
		if( date < itime )
			fseek(fp,-offs,1);
		else	fseek(fp, offs,1);
	}
	return offset;
}

fseek_history_bydate(fp,date)
	FILE *fp;
{	int offset;

	offset = history_bsearch(fp,date);
	fseek(fp,offset,0);
}

/*
 *	Decomposit 4-formats of history line
 */
decomp_history_line(line,id,xref)
	char *line,*id,*xref;
{	int day,month,year,hour,minute,itime;
	char tid[1000],txref[5000],*dp;
	int nitem,optdate;

	if( id == 0 ) id = tid;
	if( xref == 0 ) xref = txref;

	year = 0;
	*xref = 0;

	nitem = sscanf(line,"%s %d/%d/%d %d:%d %d %[^\n\r]",
		id,&month,&day,&year,&hour,&minute,&optdate,xref);
	if( 7 <= nitem ){
		itime = TimeGm(year,month,day,hour,minute,0);
		return itime;
	}

	nitem = sscanf(line,"%s %d/%d/%d %d:%d %[^\n\r]",
		id,&month,&day,&year,&hour,&minute,xref);
	if( 7 == nitem ){
		itime = TimeGm(year,month,day,hour,minute,0);
		return itime;
	}

	/* new Bnews or Cnews */
	nitem = sscanf(line,"%s %d %[^\n\r]",id,&itime,xref);
	if( nitem == 3 ){
		if( *xref != '~' )
			return itime;
		if( dp = (char*)index(xref,'\t') )
			strcpy(xref,dp+1);
		else	*xref = 0;
		return itime;
	}

	return 0;
}

/*
#include <time.h>
TimeGm(year,month,mday,hour,min,sec){
	static struct tm tm;

	tm.tm_year = year;
	tm.tm_mon = month - 1;
	tm.tm_mday = mday;
	tm.tm_hour = hour;
	tm.tm_min = min;
	tm.tm_sec = sec;
	return timegm(&tm);
}
*/
/*
 *	GMT-TIME TO CLOCK (unreliable coding ;-)
 */
static int month_base[] =
	{ 0,31,59,90,120,151,181,212,243,273,304,334,1000 };
TimeGm(year,month,mday,hour,min,sec){
	int md;

	if( month < 1 || 12 < month )
		return 0;
	year -= 70; month -= 1; mday -= 1;
	md = ((((year-2) % 4) == 0) && (1 < month)) ? 1 : 0;
	return ( ( ( year*365 + month_base[month] + md + mday + (year+1)/4
	    	    ) * 24 + hour ) * 60 + min) * 60 + sec;
}

FileSize(fp)
	FILE *fp;
{	static struct stat status;

	if( fstat(fileno(fp),&status) < 0 )
		return 0;
	else	return status.st_size;
}
FileMtime(fp)
	FILE *fp;
{	static struct stat status;

	if( fstat(fileno(fp),&status) < 0 )
		return 0;
	else	return status.st_mtime;
}

#include <ctype.h>
xhist_tolowers(str)
	char *str;
{	register char *s;

	for(s = str; *s; s++)
		if(isupper(*s))
			*s = tolower(*s);
}

char XHIST_LASTLINE_COMMAND[8] = "$";
/*////////////////////////////////////////////////////////////////////////
Copyright (c) 1993 Electrotechnical Laboratry (ETL)

Permission to use, copy, modify, and distribute this material 
for any purpose and without fee is hereby granted, provided 
that the above copyright notice and this permission notice 
appear in all copies, and that the name of ETL not be 
used in advertising or publicity pertaining to this 
material without the specific, prior written permission 
of an authorized representative of ETL.
ETL MAKES NO REPRESENTATIONS ABOUT THE ACCURACY OR SUITABILITY 
OF THIS MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED "AS IS", 
WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES.
/////////////////////////////////////////////////////////////////////////
Content-Type:	program/C; charset=US-ASCII
Program:
Author:		Yutaka Sato <ysato@etl.go.jp>
Description:
History:
 V1.1	930522	created
///////////////////////////////////////////////////////////////////////*/

comp_histfilter(exp)
	char *exp;
{
}
exec_histfilter(histline)
	char *histline;
{
	return 1;
}
