# latex2ps
#
# 29-May-92 weber@eitech.com
#
# This service will run latex, then dvi2ps on a collection of source files.
# That is, the input message may contain one or more levels of multipart/mixed
# bodies; the source files are retrieved from the leaves.  The sources are
# named by their Content-id's.  The service result is normally a multipart
# of the latex log file and the dvi2ps postscript output.

proc dolatex { switches envelope inputs } {

    # default to latexing source in the first input, use the name in the
    # first switch if it exists; remove .tex extension in either case
    if {[llength $switches] == 0} {
	if {[getfield $inputs TYPE] == "multipart"} {
	    set src [getfield [lindex [getfield $inputs PARTS] 0] FILE]
	} {set src [getfield $inputs FILE]}
    } {set src [lindex $switches 0]}
    regsub "\.tex" $src "" src
    
    # run latex on the main source, and if the output says that labels may have
    # changed, run latex again. Then run dvi2ps
    if {[catch "exec latex $src < /dev/null" lout]} {
	setfield output FILE $src.log
	setfield output DESCRIPTION "log file showing error"
    	return [mailout [turnaround $envelope] $output]
    }
    if {[regexp -nocase "may have changed" $lout]} {
    	exec latex $src < /dev/null > /dev/null
    }
    exec dvips -o $src.ps $src.dvi
    
    # now build description of outgoing two-part message containing both the latex
    # log file and the postscript result
    setfield part1 FILE $src.log
    setfield part1 DESCRIPTION "log file"

    setfield part2 TYPE application
    setfield part2 SUBTYPE postscript
    setfield part2 FILE $src.ps
    setfield part2 DESCRIPTION "postscript result"

    setfield output TYPE multipart
    setfield output SUBTYPE mixed
    setfield output PARTS [list $part1 $part2]
    
    return [mailout [turnaround $envelope] $output]
}
