/* Copyright (C) 1995 -- Joel Katz -- Stimpson@CyberPlus.com */
/* All rights reserved except as specified in included      */
/* file "main.c".				           */

#include <stdio.h>
#include <pwd.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <ctype.h>
#include <fcntl.h>
#include <unistd.h>
#include <utmp.h>
#include <time.h>
#include <errno.h>

/* You can uncomment the line below if you don't trust your users */
/* With the capability to remotely initiate a program or script.  */
/* A misconfigured .fingerrc file and/or poorly written script    */
/* could allow a wise cracker to do anything that user can do.    */

/* #define NO_USER_PROGRAMS */

extern int auth, log, mail, ttys, idletime, remote;
extern int plan, project, param, headers;
extern char prog_fnm[], plan_fnm[], project_fnm[], subd_fnm[];
extern char orighost[], origip[];
extern struct passwd *pw;
extern unsigned short local_port, remote_port;

#define MAILPATH "/var/spool/mail/"
#define MAXLINES 800
#define match(a,b) (!strcmp((a),(b)))

extern void call_program(char *fnm, char *p1, char *p2, char *p3);
char auth_resp[512];

char *ago(time_t t,int ag)
{
 static char buf[512];
 char buf2[128];
 int day=0,hour=0,minute=0,second=0;
 int i, needspace=0;
 buf[0]=0;
 t=time(NULL)-t;
 if(t>86400) { day=1; hour=1; }
 else if(t>3600) { hour=1; minute=1; }
 else if(t>60) { minute=1; second=1; }
 else if(t<=0) return("now");
 else second=1;
 if(day) 
 { 
  i=t/86400;
  t-=i*86400;
  if(i>1) sprintf(buf2,"%d days",i);
  else if(i==1) sprintf(buf2,"1 day");
  if(i) 
  {
   needspace=1;
   strcat(buf,buf2);
  }
 }
 if(hour)
 {
  i=t/3600;
  t-=i*3600;
  if(i)
  {
   if(needspace) strcat(buf," ");
   needspace=1;
   if(i>1) sprintf(buf2,"%d hours",i);
   else if(i==1) sprintf(buf2,"1 hour");
   strcat(buf,buf2);
  }
 }
 if(minute)
 {
  i=t/60;
  t-=i*60;
  if(i)
  {
   if(needspace) strcat(buf," ");
   needspace=1;
   if(i>1) sprintf(buf2,"%d minutes",i);
   else if(i==1) sprintf(buf2,"1 minute");
   strcat(buf,buf2);
  }
 }
 if(second&&t)
 {
  if(needspace) strcat(buf," ");
  if(t>1) sprintf(buf2,"%d seconds",t);
  else sprintf(buf2,"1 second");
  strcat(buf,buf2);
 }
 if(ag) strcat(buf," ago");
 return buf;
}

void ublit(char *fnm, char *pre_yes, char *pre_no)
{
 char buf[256];
 int i,j,k;
 j=0;
 i=open(fnm,O_RDONLY);
 if(i<0) 
 {
  if(pre_no!=NULL) printf(pre_no);
  return;
 }
 if(pre_yes!=NULL) printf(pre_yes);
 while((k=read(i,buf,256))!=0)
 {
  fwrite(buf,k,1,stdout);
  if((j++)>MAXLINES) break;
 }
 close(i);
}

void pl_ublit(char *fnm)
{
 if(headers) ublit(fnm,"Plan:\n","No Plan.\n");
  else ublit(fnm,NULL,NULL);
}

char *proc(char *u, int leng)
{
 static char buf[64];
 char *j=buf;
 int cnt=0;
 while((*u!=' ')&&(cnt<leng)) { *(j++)=*(u++); cnt++; }
 *j=0;
 return buf;
}

void traverse(char *unm)
{
 struct utmp *ut;
 struct stat st;
 time_t least_idle=0,tt;
 int count=0,i;
 char fnm[80],buf[80],ttynam[10],*c,*d;
 while((ut=getutent())!=NULL)
 {
  if(ut->ut_type!=7) continue;
  if(!match(proc(ut->ut_user,UT_NAMESIZE),unm)) continue;
  count++;
  if(ut->ut_id[1]==' ') ut->ut_id[1]=0;
  strcpy(fnm,"/dev/");
  c=ttynam;
  d=ut->ut_line;
  while((*d!=' ')&&(*d!=0))
  {
   *c++=*d++;
  }
  *c=0;
  strcat(fnm,ttynam);
  if(ttys)
    printf("On %s for %s",ttynam,ago(ut->ut_time,0) );
  if(idletime)
   {
    i=stat(fnm,&st);
    if(i==0)
    {
     if(ttys) printf(", active %s",ago(st.st_mtime,1));
     if(st.st_mtime>least_idle) least_idle=st.st_mtime;
    }
   }
  if(remote&&ttys&&ut->ut_host[0]!=0)
   printf(" from %s",proc(ut->ut_host,UT_HOSTSIZE));
  if(ttys) printf(".\n");
 }
 if((ttys||idletime)&&(count==0))
  printf("Not logged on.\n");
 if(idletime&&!ttys&&count)
  printf("Logged in, active %s.\n",ago(least_idle,1));
}

void do_auth(void)
{
 int i,j;
 char buf[1024];
 struct sockaddr_in ad;
 j=socket(AF_INET,SOCK_STREAM,0);
 if(j<2) { auth=-1; return; } /* -1=odd error */
 ad.sin_family=AF_INET;
 ad.sin_port=0xffff;
 ad.sin_addr.s_addr=htonl(0x7f000001);
 i=bind(j,(struct sockaddr *)&ad,sizeof(ad));
 if(i<0) { close(j); auth=-1; return; }
 ad.sin_port=getservbyname("auth","tcp")->s_port;
 ad.sin_addr.s_addr=inet_addr(origip);
 i=connect(j,(struct sockaddr *)&ad,sizeof(ad));
 if(i==-1) { close(j); auth=-2; return; } /* -2=remote host doesn't auth */
 sprintf(buf,"%d,%d\n",(int)remote_port,(int)local_port);
 write(j,buf,strlen(buf));
 auth=j; /* save socket number */
}

void do_auth2(void)
{
 char buf[256],ign[256],type[256],os[256],usrn[256];
 int i,j;
 i=auth;
 fcntl(i,F_SETFL,O_NONBLOCK);
 j=read(i,buf,256);
 if(j<0)
 {
  if(errno!=EAGAIN) { close(i); auth=-3; }
  sleep(1);
  j=read(i,buf,256);
 }
 if(j<0) { auth=-3; close(i); return; }
 i=sscanf(buf,"%*s%*s%*s%*s%s%*s%s%*s%s",type,os,usrn);
 if(i!=3) { auth=-3; close(i); return; }
 sprintf(auth_resp,"%s:%s",os,usrn);
 auth=1;
 close(i);
}

void ufinger(char *unm, char *snm)
{
 FILE *a;
 char buf[1024];
 int i,j;
 struct stat st;
 if(auth&&(!log)) auth=0; /* Why authenticate if you're not going to log? */
 if(auth) do_auth();
 if(strlen(pw->pw_gecos)<25)
  printf("Login: %s\t\t\t\tName: %s\n",pw->pw_name,pw->pw_gecos);
 else
  printf("Login: %s\tName: %s\n",pw->pw_name,pw->pw_gecos);
 if(idletime||ttys) traverse(unm);
 if(mail)
 {
  strcpy(buf,MAILPATH);
  strcat(buf,pw->pw_name);
  i=stat(buf,&st);
  if((i!=0)||(st.st_size==0)) printf("No mail.\n");
  else
  {
   strftime(buf,80,"%A %b %d, %Y at %I:%M %p (%Z)",localtime(&st.st_atime));
   printf("Mail last read on %s.\n",buf);
  }
 }
 if((project)&&(project_fnm[0]))
 {
  if(headers)
   ublit(project_fnm,"Project:\n",NULL);
  else
   ublit(project_fnm,NULL,NULL);
 }
 if((plan)&&(param||plan_fnm[0]))
 {
  if(param)
  {
   strcpy(buf,subd_fnm);
   if(snm[0]!=0) strcat(buf,snm);
    else strcat(buf,unm);
   i=stat(buf,&st);
   if(i==0)
    pl_ublit(buf);
   else
    {
     strcpy(buf,subd_fnm);
     strcat(buf,unm);
     pl_ublit(buf);
    }
  }
  else
  {
   strcpy(buf,subd_fnm);
   strcat(buf,plan_fnm);
   pl_ublit(buf);
  }
 }
 if(auth>0) do_auth2();
 if(log)
 {
  a=fopen(".fingerlog","a");
  if(a!=NULL)
  {
   if(snm[0]==0)
    fprintf(a,"%s(%s) -> %s",orighost,origip,unm);
   else
    fprintf(a,"%s(%s) -> %s '%s'",orighost,origip,unm,snm);
   if(auth==-1) fprintf(a," auth failed");
   if(auth==-2) fprintf(a," user unknown");
   if(auth==-3) fprintf(a," auth rejected");
   if(auth==1) fprintf(a," %s",auth_resp);
   fprintf(a,"\n");
   fclose(a);
  }
 }

#ifndef NO_USER_PROGRAM
 if(prog_fnm[0])
 {
  if((param)&&(snm[0]!=0)) /* There is a param */
   call_program(prog_fnm,&orighost[0],&origip[0],snm);
  else
   call_program(prog_fnm,&orighost[0],&origip[0],(char *)NULL);
 }
#endif
}
