/* kfinger 0.07                                              */
/* ------------------------------------------------------    */
/* Copyright (C) 1995 -- Joel Katz -- Stimpson@CyberPlus.COM */
/* All rights reserved except as below                       */
/* Unlimited distribution of unmodified source is permitted  */
/* Distribution of modified source is permitted so long as   */
/* this notice remains and the banner is not removed or      */
/* tampered with. Distribution of executables, made from     */
/* either modified or unmodified sources, is permitted       */
/* so long as the banner is not removed or tampered with,    */
/* except that an additional line may be added to it to      */
/* specify any additional information.                       */
/* The banner is two lines of code below. They are marked.   */

static char *version="0.07";

#include <stdio.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <unistd.h>
#include <pwd.h>
#include <grp.h>
#include <sys/types.h>
#include <netdb.h>
#include <syslog.h>
#include <errno.h>
#include <string.h>

/* Set system defaults here */

/* #define LOG_REMOTE */
/* #define LOG_ALL */

int auth=0, log=0, mail=1, ttys=1, idletime=1, 
    remote=0, plan=1, project=1, param=0, headers=1;
    
unsigned short local_port, remote_port;
    
char prog_fnm[256]="", plan_fnm[256]=".plan",
     project_fnm[256]=".project", subd_fnm[256]="";

struct passwd *pw;
char orighost[128],origip[128], *subname;
extern char *str_lower(char *);

#define SEPARATOR '#'
#define DUMMYFINGERS "/home/finger"

/* Leave this defined in case BLINDFNM ever disappears. */
#define NOBLIND "This site does not accept fingers that do not specify a user."

/* Define these to have blind fingers run the specified program. */
/* BLINDARG should be commented out or set to NULL if no argument is needed. */
/* BLINDPATH and BLINDFNM must be set as shown below. */

/* #define BLINDPATH "/bin/"        */
/* #define BLINDFNM  "cat"          */
/* #define BLINDARG  "/etc/noblind" */

/* Caution: setting the above three defines to run 'w' 'who' 'users', or the  */
/* like may allow remote fingers to get information that kfingerd would not   */
/* release due to user settings. Support of blind fingers is not recommended. */

/* Undefine ROOT_DROPS to have dummyfingers execute as root. (not advised) */
/* Redefine to have dummyfingers execute as the specified user. See the    */
/* README file for warnings about possible conflicts with NFS.             */

#define ROOT_DROPS "nobody"
#define DUMMYS_RUN "nobody"

extern void dummyfinger(char *usnam, char *subnam);
extern void parse(const char *hostname, const char *hostip);
extern void ufinger(char *usnam, char *subnam);

void err_out(char *j)
{
 syslog(LOG_ERR,"kfingerd: %s\n",j);
 exit(1);
}

void err_out2(char *j)
{
 fprintf(stderr,"%s\n",j);
 exit(1);
}

void main(void)
{
 int i;
#ifdef ROOT_DROPS
 int finger_root=0;
#endif
 struct sockaddr_in j;
 unsigned long int ad;
 struct hostent *he;
 char *q, *p, *request;
 request=(char *) malloc(128);
 if(geteuid()) { err_out2("Must be run by root"); }
 if(getuid()) { err_out2("Kfingerd must not be suid root"); }
 if(isatty(0)) { err_out2("Must be run from inetd"); }
 i=sizeof(j);
 if(getsockname(0,(struct sockaddr *)&j,&i)) err_out("Can't get socket name");
 if(j.sin_family!=AF_INET) err_out("Must be INET port");
 local_port=ntohs(j.sin_port);
 if(getpeername(0,(struct sockaddr *)&j,&i)) err_out("Can't get peer name");
 if(j.sin_family!=AF_INET) err_out("Must be INET port");
 remote_port=ntohs(j.sin_port);
 q=inet_ntoa(j.sin_addr);
 he=gethostbyaddr((char *)&(j.sin_addr),4,AF_INET);
 if(he->h_name==NULL)
 { /* Give it one more chance */
  sleep(5);
  he=gethostbyaddr((char *)&(j.sin_addr),4,AF_INET);
 }
 if(he->h_name!=NULL) strcpy(orighost,he->h_name);
  else strcpy(orighost,"???");
 if(q!=NULL) strcpy(origip,q);
  else strcpy(origip,"???");
 if(fgets(request,128,stdin)==NULL) exit(0);
 request[strlen(request)-2]=0; /* Remove end of line */
 while(request[0]==' ') request++; /* Remove leading space */
 if((request[0]=='/')||(request[0]=='-')) /* Remove options */
 {
  while((request[0]!=' ')&&(request[0]!=0)) request++;
  if(request[0]==' ') request++;
 }
 if(strlen(request)==0)
 {
#ifdef BLINDPATH
#ifdef BLINDFNM
 execl(BLINDPATH BLINDFNM, BLINDFNM, 
#ifdef BLINDARG
 BLINDARG, 
#endif
 NULL);
#endif
#endif
  printf(NOBLIND);
  return;
 } 

 /* The below two lines are the banner */
 if(!strcmp(request,"kfingerd?")) 
  printf("Kfingerd-%s -- Joel Katz -- Stimpson@CyberPlus.COM\n",version);

#if defined(LOG_REMOTE)
 if(strcmp(he->h_name,"localhost"))
#endif
#if defined(LOG_ALL)||defined(LOG_REMOTE)
  syslog(LOG_INFO,"Host %s(%s) fingers %s\n",q,he->h_name,request);
#endif

 q=strrchr(request,' ');
 if(q!=NULL) request=q+1;
 
 p=request;
 while((*p!=0)&&(*p!=SEPARATOR)) 
 { p++; }
 if(*p==SEPARATOR) 
 { 
  *p=0; 
  p++; 
 }
 q=p;
 while(*q!=0)
 { /* Needed for security */
  if((*q=='/')||(*q=='~')) *q='_';
  q++;
 }
 
 subname=p;
 pw=getpwnam(request);
 if(pw==NULL) 
 {
  pw=getpwnam(DUMMYS_RUN);
  if (chdir(DUMMYFINGERS))
  { /* DUMMYFINGERS directory doesn't exist or isn't accessible */
   printf("finger: %s: no such user.\n",request);
   exit(1);
  }
  if(pw!=NULL)
  {
   setgid(pw->pw_gid);
   initgroups(DUMMYS_RUN,pw->pw_gid);
   setuid(pw->pw_uid);
  }
  dummyfinger(request,p);
 }
 else
 {
#ifdef ROOT_DROPS
  if(pw->pw_uid==0) /* If root is being fingered */
  {
   finger_root=1;
   pw=getpwnam(ROOT_DROPS); /* Try to drop privs */
   if(pw==NULL) pw=getpwnam(request); /* Oh well, couldn't drop */
   if(pw==NULL) exit(0); /* Should never happen */
  }
#endif
  setgid(pw->pw_gid);
  initgroups(request,pw->pw_gid);
  setuid(pw->pw_uid);
#ifdef ROOT_DROPS
  if(finger_root) pw=getpwnam(request);
  if(pw==NULL) exit(0); /* should never happen */
#endif
  chdir(pw->pw_dir);
  parse(str_lower((char *) he->h_name), q);
  ufinger(request,p);
 }
}
