/*  cident.c:
 *  5/5/96	Version 1.0b		by aaron ledbetter
 *	
 *  this is the cidentd server ... use at your own risk
 *  copyrite. well .... just do what ever you want.
 *  this was inspired by josh lehan's jident ... which didn't seem
 *  to work to well on my system ... thanks .... bye.
 */

#include <arpa/inet.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/time.h>
#include <sys/wait.h>
#include <netinet/in.h>
#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <string.h>
#include <unistd.h>
#include <syslog.h>
#include <pwd.h>
#include <signal.h>
#include <arpa/inet.h>
#include <netinet/in.h>
#include <linux/ip.h>
#include <netdb.h>

#define USERFILE 	"/etc/cident.users"
#define AUTHLIE  	".authlie"
#define TCPFILE 	"/proc/net/tcp"

#define BUFSIZE 	1024
#define NO 		0
#define YES 		1

typedef unsigned short  Opt;		
typedef unsigned char   Byte;
typedef unsigned short  Word;
typedef unsigned long   Quad;

		/** Global Variables **/ 

int 	SocketFD, 	ConnectFD, 	LocalPort, 	RemotePort; 
Quad 	LocalAddr, 	RemoteAddr; 
char 	RemoteName[18], UserFile[BUFSIZE], 	TCPfile[BUFSIZE], 
	RemoteHostName[BUFSIZE]; 

		/** Default Options **/ 

Word 	Timeout = 0;
Opt 	SingleQuery = NO, QuitAfter = YES, AlwaysLie = NO, 
	Verbose = NO,     Truthful = NO,  useauthlie = NO;


		/** Prototypes For all Functions **/

int  	GetLine(int FD);
void 	SendError(char *Text);
void 	SendGood(char *Name);
int 	LookupPort(void);
char 	*LookupName(uid_t userid);
void 	ProcessIt(void);
void 	Usage(void);
void 	DoArgs(int Argc, char **Argv);
char 	*hostlookup(unsigned long int in);
char 	*iplookup(char *hostname);
int  	Checkthem(void);
char 	*Home(char *username);
char 	*toip(Quad addr);
void 	End(int RetCode);
void 	Dsyslog(int Priority, char *format, ...);
void 	GrabSocket(void);
void 	Die(char *Why);
int 	GetRemAddr(int FD);
void 	GrabSocket(void);

/* get there addresses and do dns lookups */

int Checkthem(void)
{
/*  check the addresses in the packets */
GetRemAddr(ConnectFD);

/* these ask the nameserver for info */
strcpy(RemoteHostName,hostlookup(RemoteAddr));
if(strcmp(RemoteName,iplookup(RemoteHostName)) == 0){
	Dsyslog(LOG_INFO, "connect from %s ", RemoteHostName);
	return 1;
	}

Dsyslog(LOG_INFO, "connect from %s realy %s bad reverse lookup", 
		iplookup(RemoteHostName),RemoteHostName);
SendError("UNKNOWN-ERROR");
Die("Client had bad karma.");
return 0;
}

char *hostlookup(unsigned long int in)
{
   static char blah[1024];
   struct in_addr i;
   struct hostent *he;
         
   i.s_addr=in;
   he=gethostbyaddr((char *)&i, sizeof(struct in_addr),AF_INET);
   if(he == NULL) strcpy(blah, inet_ntoa(i));
   else strcpy(blah, he->h_name);
   return blah;
}

char *iplookup(char *hostname)
{
   static char blah[1024];
   struct hostent *he;
   struct in_addr adres;
         
   if(!(he=gethostbyname(hostname))) strcpy(blah, "0.0.0.0");
 
   else {
	bcopy(he->h_addr,(char *)&adres.s_addr, he->h_length);
	strcpy(blah, inet_ntoa(adres));
	}
   return blah;
}

int GetLine(int FD)
{
        if (scanf("%d , %d", &LocalPort, &RemotePort) != 2
	|| LocalPort < 1 || LocalPort > 65535 ||
           RemotePort < 1 || RemotePort > 65535) return -1;
return 1;	
}


/* Sends the error message in proper format */

void SendError(char *Text)
{
	char Buf[BUFSIZE];

	sprintf(Buf, "%hu , %hu : ERROR : %s\r\n", LocalPort, RemotePort, Text);
	Dsyslog(LOG_DEBUG, "Sending Error Message: %s", Text);

	if (write(ConnectFD, Buf, strlen(Buf)) != strlen(Buf))
		Die("Trouble writeing message to socket.");
}

/* Sends a username in the proper format */

void SendGood(char *Name)
{
	char Buf[BUFSIZE];

	sprintf(Buf, "%hu , %hu : USERID : UNIX : %s\r\n", LocalPort, 
			RemotePort, Name);
	Dsyslog(LOG_DEBUG, "Sending  name %s ", Name);
	if (write(ConnectFD, Buf, strlen(Buf)) != strlen(Buf))
		Die("Trouble writeing message to socket.");
}

int LookupPort(void) 
{
	FILE *File;
	Quad LocIP, RemIP;
	int LocPort=0, RemPort=0;
	uid_t userid;
	char Buf[BUFSIZE];

	File = fopen(TCPfile, "r");
	if (File == NULL) return -2;	

	/* eat the file header  */
	if (fgets(Buf, BUFSIZE, File) == NULL) return -2;

/* no we look for this port and that port and see what is there */	
	while(fgets(Buf, BUFSIZE, File) != NULL)
		{
		sscanf(Buf, "%*d: %lx:%x %lx:%x %*x %*x:%*x %*x:%*x %*x %hd",
			&LocIP, &LocPort, &RemIP, &RemPort, &userid);	
		if ((LocIP == LocalAddr) && (RemIP == RemoteAddr) &&
		   (LocPort == LocalPort) && (RemPort == RemotePort))
			return userid;
		}	
	return -1;	/* no user found */
}


/*      Look up UserName in UserFile and AUTHLIE file
 *	returns a name or NULL if none is to be given out
 */

char *GetName(char *username)
{
	FILE *File;
	int  i;
	char Buf[BUFSIZE], Name1[BUFSIZE], Name2[BUFSIZE];
	char realname[64];
				
	strcpy(realname, username);

	/* if Flag set then procede */
if(useauthlie == YES)
	{
	/* First if flags set lookfor ~username/AUTHLIE */
	sprintf(Buf,"%s/%s",Home(username),AUTHLIE);
	if((File = fopen(Buf, "r")) != NULL) 
	   {
	   while (!feof(File)) 
	     	{
	        char first = fgetc(File);
	        ungetc(first, File);
	        if((first == '#') || (first == ';') || (first == '*') ||
		  (first == '\'') || (first == '!') || (first == '\n')) {
		  fscanf(File, "%[^\n]\n", Buf);
	    	  } 
	   	else 
		  {
		  fscanf(File, "%[^\n]\n", Buf);
		  /* if mynameis  <value>*/
		  /* if hideme*/
		  /* if <Host>  <value>*/
		  /* if <Host>  no-info*/
		  i=sscanf(Buf,"%[^\n\t ] %[^\n\t ]\n", Name1, Name2);
		  if((i==1) && (strcmp(Name1,"hideme")==0)) 
				strcpy(username,"(NULL)");
		  if(i==2)
			{
			if(strcmp(Name1,"mynameis")==0) 
				strcpy(username,Name2);
			else
				/* this one checks dot notation */
			  if(strcmp(Name1,RemoteName)==0)
				strcpy(username,Name2);
			else
				/* this one looks up the name */
			   if(strcmp(iplookup(Name1),RemoteName)==0)
				strcpy(username,Name2);

			}
		  }
	   	}
	   (void) fclose(File);
	   }
	}  /* end useauthlie */
if( AlwaysLie == YES )
	{
	/* Next check the userfile as it overides the others */
	if((File = fopen(UserFile, "r")) != NULL) 
	   {
	   while (!feof(File)) 
	     	{
	        char first = fgetc(File);
	        ungetc(first, File);
	        if((first == '#') || (first == ';') || (first == '*') ||
		  (first == '\'') || (first == '!') || (first == '\n')) {
		  fscanf(File, "%[^\n]\n", Buf);
	    	  } 
	   	else 
		  {
		  fscanf(File, "%[^\n]\n", Buf);
		  /* if <username>  <value>*/
		  /* if <username>   user must use realname */
		  /* if all  <value>*/
		  /* if all  no-info*/
		  /* if <Host>  <value>*/
		  /* if <Host>  no-info*/
		  i=sscanf(Buf,"%[^\n\t ] %[^\n\t ]\n", Name1, Name2);
		  if( (i==1) && (strcmp(realname, Name1)) )
				strcpy(username,"realname");
		  if(i==2)
			{
			if(strcmp(Name1,"all")==0) 
				strcpy(username,Name2);
			else 
				/* this one check dot notation */
			   if(strcmp(Name1,RemoteName)==0)
				strcpy(username,Name2);
			else
				/* this one looks up the name */
			   if(strcmp(iplookup(Name1),RemoteName)==0)
				strcpy(username,Name2);

			else if(strcmp(Name1,realname)==0) 
				strcpy(username,Name2);
			}
		  }
	   	}
	   (void) fclose(File);
	   }
	}

if(strcmp(username, "(NULL)") == 0 ) return NULL;
if(strcmp(username, "no-info") == 0 ) return NULL;
return username;
}

	
void ProcessIt(void)
/* Do what the program was intended to do */
{
	int userid;
	char *username;	

/* if bad port say goodbye */
	if((userid = LookupPort())<0)  {
		SendError("INVALID-PORT");
		return;
		}

/* if bad user returned (this should not happen) say bye */
	if((username=LookupName(userid))==NULL){
		SendError("NO-USER");
		return;
		}

/* check for name changes and the like if flags are there */

if(Truthful == YES)
	{
	SendGood(username);
	return;
	}

/* this is for the changed names if changed or hidden users */
if(useauthlie==YES || AlwaysLie == YES) username = GetName(username);
if(username == NULL) 	SendError("HIDDEN-USER");
else			SendGood(username);
return;
}

void main(int argc, char **argv)
{
	int Status;
	DoArgs(argc, argv);
	openlog("cidentd", LOG_PID | LOG_CONS, LOG_AUTHPRIV);

	/* create a socket */
	if((SocketFD = socket(AF_INET, SOCK_STREAM, 0)) < 0)
		Die("Couldn't create socket:");

	if (listen(SocketFD, ((QuitAfter == YES) ? 1 : 5)) < 0) 
		Die("Socket can't hear anything!");

	Checkthem();

	Status = GetLine(ConnectFD);
	while (Status >= 0)
		{
		/* hang up if we're done, or we're in single-query mode */
		if (SingleQuery == YES) break;
		/* need to process it */
		ProcessIt();
		Status = GetLine(ConnectFD);
		}
	close(ConnectFD);

	End(0);
}


/** these look good **/

void Usage(void)
{
/* strange syntax here just to make it easier to read */
#define FS fprintf(stderr,
FS "[0;1mCident:\n[1;34m       Version 1.0b[0;1m\n\n");
FS "Options:[1;34m\n");
FS "      -f <file> = use <file> for TCP lookups instead of %s\n", TCPFILE);
FS "      -l <file> = use <file> as UserFile instead of %s\n", USERFILE);
FS "      -t <secs> = set idle timeout for connections\n"); 
FS "      -u = user .authlie in user directories\n");
FS "      -s = close each connection after a single query\n");
FS "      -q = quit after a single connection\n");
FS "      -v = verbose loging to syslog\n");
FS "      -n = be old-type conventional identd\n");
FS "      -a = use /etc/cident.users for name changes\n");
FS "      -h = show this help list[0;1m\n");
FS "This program is free software, and may be modified and/or redistributed\n");
FS "under the terms of the GNU General Public License, version 2 or later.[0m\n"); 
#undef FS
}

/* Parses options and sets global variables */

void DoArgs(int Argc, char **Argv)
{
	extern char *optarg;
	extern int optind;
	extern int opterr;
	int Option;
		
	opterr = 0;optind = 1;

	/* set up default filenames */
	strcpy(UserFile, USERFILE);
	strcpy(TCPfile, TCPFILE);

	while ((Option = getopt(Argc, Argv, "sqavnhut:i:l:f:d:")) != EOF)
	{
		switch((char)Option)
		{
			case 's': case 'S':
				SingleQuery = YES;
				break;
			case 'q': case 'Q':
				QuitAfter = YES;
				break;
			case 'u': case 'U':
				useauthlie = YES;
				break;
			case 'a': case 'A':
				AlwaysLie = YES;
				break;
			case 'v': case 'V':
				Verbose = YES;
				break;
			case 'n': case 'N':
				Truthful = YES;
				break;
			case 'h': case 'H':
				Usage();
				End(0);
				break;
			case 'l': case 'L':
				strncpy(UserFile, optarg, BUFSIZE - 1);
				break;
			case 'f': case 'F':
				strncpy(TCPfile, optarg, BUFSIZE - 1);
				break;
			case 't': case 'T':
				if ( ( Timeout=atoi(optarg) ) < 1)
					Die("Timeout value must be in range 0-65535\n");
				break;
			default:
				Usage();
				End(1);
		}
	}
}

char *LookupName(uid_t userid)
{
	struct passwd *Pass;
	Pass = getpwuid(userid);
	return Pass->pw_name;
}

char *Home(char *username)
{
	struct passwd *Pass;
	Pass = getpwnam(username);
	return Pass->pw_dir;
}



void End(int RetCode)
{
	closelog();
     /*** befor any exit lets make sure the connections are closed */
	if(SocketFD) close(SocketFD);
	if(ConnectFD) close(ConnectFD);
	exit(RetCode);
}

char *toip(Quad addr)
{
	char *ip;
	ip = malloc(18);
	sprintf(ip,"%i.%i.%i.%i",(int)((addr>>24)&0xff),(int)((addr>>16)&0xff),
		(int)((addr>>8)&0xff),(int)(addr&0xff));
return ip;
}


void Dsyslog(int Priority, char *format, ...)
{
	char Str[BUFSIZE];
	va_list args;

	va_start(args, format);
	vsprintf(Str, format, args);		
	syslog(Priority, "%s", Str);
	va_end(args);
}

void Die(char *Why)
{
	Dsyslog(LOG_ERR, Why);
	printf("cident failed ... \n");
	End(1);
}


/* fills in RemoteAddr/Port  LocalAddr/Port*/

int GetRemAddr(int FD)
{
	int size = sizeof(struct sockaddr_in);
	struct sockaddr_in SockDummy;

	if(getsockname(FD, (struct sockaddr *)&SockDummy, &size ) != 0)
		Die("Couldn't get local hostname:");
	
	LocalAddr = SockDummy.sin_addr.s_addr;
	LocalPort = SockDummy.sin_port;

	if(getpeername(FD, (struct sockaddr *)&SockDummy, &size ) != 0)
		Die("Couldn't get remote hostname:");

	RemoteAddr = SockDummy.sin_addr.s_addr;
	RemotePort = SockDummy.sin_port;
	strcpy(RemoteName,toip(ntohl(RemoteAddr)));
return 1;
}
