/*
 * CFINGERD
 * Userlist handler
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 1, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */

#include "cfingerd.h"
#include "proto.h"
#include "privs.h"

/*
 * HANDLE_USERLIST
 * 
 * This routine simply handles the displaying of the userlist.
 */
void handle_userlist(void)
{
    BOOL can_show = FALSE;

    if (local_finger) {
	if (prog_config.local_config_bits2 & SHOW_SYSTEMLIST)
	    can_show = TRUE;
    } else {
	if (prog_config.config_bits2 & SHOW_SYSTEMLIST)
	    can_show = TRUE;
    }

    show_top();

    if (can_show) {
	int i;
	char fslist_name[32], sslist_name[32], cmdline[128];

	sprintf(fslist_name, "/tmp/fslist.%d", getpid());
	strcpy(sslist_name, fslist_name);
	strcat(sslist_name, ".sort");

	if ((num_finger_sites > 1) &&
	    prog_config.config_bits2 & SHOW_MULTFING) {
	    printf("%s\n", prog_config.p_strings[D_WAIT]);
	    fflush(stdout);
	}

	PRIV_ROOT_START
	(void) unlink(fslist_name);
	PRIV_ROOT_END

	if (prog_config.config_bits2 & SHOW_MULTFING) {
	    for (i = 0; i < num_finger_sites; i++) {
		if (!strncmp(prog_config.finger_sites[i], "localhost", 9)) {
		    char *st;

		    if ((st = (char *) malloc(strlen(prog_config.finger_program) + 32)) == NULL) {
			printf("cfingerd could not allocate memory for the userlist program!\n");
			fflush(stdout);
		    } else {
			sprintf(st, "%s | tail +2 >> %s",
			    prog_config.finger_program, fslist_name);

			PRIV_ROOT_START
			system(st);
			free(st);
			PRIV_ROOT_END
		    }
		} else {
		    sprintf(cmdline, "finger userlist-only@%s | tail +3 >> %s",
			prog_config.finger_sites[i], fslist_name);

		    PRIV_ROOT_START
		    system(cmdline);
		    PRIV_ROOT_END
		}
	    }
	} else {
	    char st[80];

	    if ((!strstr(prog_config.finger_program, "finger")) &&
		(!strstr(prog_config.finger_program, "w")))
		sprintf(st, "%s | tail +2 >> %s",
		    prog_config.finger_program, fslist_name);
	    else 
		sprintf(st, "%s >> %s",
		    prog_config.finger_program, fslist_name);

	    PRIV_ROOT_START
	    system(st);
	    PRIV_ROOT_END
	}

	PRIV_ROOT_START
	sprintf(cmdline, "sort <%s >%s", fslist_name, sslist_name);
	system(cmdline);
	unlink(fslist_name);
	PRIV_ROOT_END

	if ((num_finger_sites > 1) &&
	    prog_config.config_bits2 & SHOW_MULTFING)
	    printf("\n**> This is the complete listing of %d sites total.\n\n",
		    num_finger_sites);

	if ((!strstr(prog_config.finger_program, "finger")) &&
	    (!strstr(prog_config.finger_program, "w"))) {
	    printf("Username Real name                      Idletime TTY Remote console location\n");
	    fflush(stdout);
	    display_file(sslist_name);
	}

	if ((num_finger_sites > 1) &&
	    prog_config.config_bits2 & SHOW_MULTFING)
	    SEND_RAW_RETURN;

	fflush(stdout);

	if ((num_finger_sites > 1) &&
	    prog_config.config_bits2 & SHOW_MULTFING) {
		char cmd[80];

		sprintf(cmd, "echo \"There are `wc --lines <%s` usersonline.\"", sslist_name);
		system(cmd);
	    }

	PRIV_ROOT_START
	unlink(sslist_name);
	PRIV_ROOT_END
    } else {
	can_show = FALSE;

	if (local_finger) {
	    if (prog_config.local_config_bits2 & SHOW_NN_BANNER)
		can_show = TRUE;
	} else {
	    if (prog_config.config_bits2 & SHOW_NN_BANNER)
		can_show = TRUE;
	}

	if (can_show)
	    display_file(prog_config.no_name_banner_file);
    }

    show_bottom();

    log(LOG_USER, "Userlist request", " ");
}
