#! /usr/bin/perl

$idx = 0;
while (<>) {
	($tag, $user, $sys) = /^(.*\S)\s*:\s*(\S+)\s*(\S+)\s*/;
	if ($tag eq "" || $tag eq "Benchmark") {
		$round++ if ($tag eq "");;
		next;
	}
	if ($round == 1) {
		$tags[$idx] = $tag;
		$idx++;
	}
	$tags{$tag} = $tag;
	$summary{$tag,count}++;
	$summary{$tag,user} += $user;
	$summary{$tag,sys} += $sys;
}

printf("Benchmark           |     user        sys   user+sys\n");
printf("--------------------+-------------------------------\n");
for ($i = 0; $i < $idx; $i++) {
	$tag   = $tags[$i];
	$count = $summary{$tag,count};
	$user  = $summary{$tag,user};
	$sys   = $summary{$tag,sys};
	$count = 1;
	printf("%-20s|  %7.2f    %7.2f    %7.2f\n",
			$tag, $user / $count, $sys / $count, 
			($user + $sys) / $count);
}
