/*
 * lib/inet6.c	This file contains an implementation of the "INET6"
 *		support functions for the net-tools.
 *		(most of it copied from lib/inet.c 1.26).
 *
 * Version:	lib/inet6.c 0.01 1996-08-08
 *
 * Author:	Fred N. van Kempen, <waltje@uwalt.nl.mugnet.org>
 *		Copyright 1993 MicroWalt Corporation
 *
 * Modified:
 *960808 {0.01}	Frank Strauss :         adapted for IPv6 support
 *
 *		This program is free software; you can redistribute it
 *		and/or  modify it under  the terms of  the GNU General
 *		Public  License as  published  by  the  Free  Software
 *		Foundation;  either  version 2 of the License, or  (at
 *		your option) any later version.
 */
#include "config.h"

#if HAVE_AFINET6
#include <asm/types.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <arpa/nameser.h>
#include <netinet6/in6.h>
#if 0
#include <linux/route.h>
#endif
#include <ctype.h>
#include <errno.h>
#include <netdb.h>
#include <resolv.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <unistd.h>
#include "version.h"
#include "net-support.h"
#include "pathnames.h"
#define  EXTERN
#include "net-locale.h"

extern int h_errno;  /* some netdb.h versions don't export this */

struct addr6 {
  struct sockaddr_in6	addr6;
  char			*name;
  struct addr6		*next;
};


static struct addr6 *INET6_nn = NULL;	/* addr-to-name cache		*/


static int
INET6_resolve(char *name, struct sockaddr_in6 *sin6)
{
  struct hostent *hp;
  
  /* Grmpf. -FvK */
  sin6->sin6_family = AF_INET6;
  sin6->sin6_port = 0;

#ifdef DEBUG
  res_init();
  _res.options |= RES_DEBUG;
#endif

  if ((hp = gethostbyname2(name, AF_INET6)) == (struct hostent *)NULL) {
	errno = h_errno;
	return(-1);
  }
  memcpy((char *) &sin6->sin6_addr, (char *) hp->h_addr_list[0], hp->h_length);
  strcpy(name, hp->h_name);
  return(0);
}


static int
INET6_rresolve(char *name, struct sockaddr_in6 *sin6, int numeric)
{
  struct hostent *ent;
  struct netent *np;
  struct addr6 *pn;
  struct in6_addr ad;
  
  /* Grmpf. -FvK */
  if (sin6->sin6_family != AF_INET6) {
#ifdef DEBUG
	fprintf(stderr, NLS_CATGETS(catfd, inetSet, inet_debug1, "rresolve: unsupport address family %d !\n"),
							sin6->sin6_family);
#endif
	errno = EAFNOSUPPORT;
	return(-1);
  }

  memcpy(&ad, sin6->sin6_addr.s6_addr, sizeof(struct in6_addr));
  if (numeric & 0x7FFF) {
        inet_ntop(AF_INET6, &sin6->sin6_addr, name, 80);
	return(0);
  }

  pn = INET6_nn;
  while (pn != NULL) {
	if (!memcmp(pn->addr6.sin6_addr.s6_addr, &ad,
		    sizeof(struct in6_addr))) {
		strcpy(name, pn->name);
		return(0);
	}
	pn = pn->next;
  }

  np = NULL;
  ent = NULL;
  ent = gethostbyaddr((char *) &ad, sizeof(struct in6_addr), AF_INET6);
  if (ent != NULL)
        strcpy(name, ent->h_name);
  if ((ent == NULL) && (np == NULL)) {
        inet_ntop(AF_INET6, &sin6->sin6_addr, name, 80);
  }
  pn = (struct addr6 *)malloc(sizeof(struct addr6));
  pn->addr6 = *sin6;
  pn->next = INET6_nn;
  pn->name = (char *) malloc(strlen(name) + 1);
  strcpy(pn->name, name);
  INET6_nn = pn;

  return(0);
}


static void
INET6_reserror(char *text)
{
  herror(text);
}


/* Display an Internet socket address. */
static char *
INET6_print(unsigned char *ptr)
{
  static char name[80];

  inet_ntop(AF_INET6, (struct in6_addr *)ptr, name, 80);
  return name;
}


/* Display an Internet socket address. */
/* dirty! struct sockaddr usually doesn't suffer for inet6 addresses, fst. */
static char *
INET6_sprint(struct sockaddr *sap, int numeric)
{
  static char buff[128];

  if (sap->sa_family == 0xFFFF || sap->sa_family == 0)
    return(NLS_CATBUFF (catfd, inetSet, inet_none, "[NONE SET]", buff, 128));
  if (INET6_rresolve(buff, (struct sockaddr_in6 *) sap, numeric) != 0)
							return(NULL);
  return(buff);
}


static int
INET6_getsock(char *bufp, struct sockaddr *sap)
{
  struct sockaddr_in6 *sin6;
  
  sin6              = (struct sockaddr_in6 *) sap;
  sin6->sin6_family = AF_INET6;
  sin6->sin6_port   = 0;

  if (inet_pton(AF_INET6, bufp, sin6->sin6_addr.s6_addr) <= 0)
    return(-1);

  return 16; /* ?;) */
}

static int
INET6_input(int type, char *bufp, struct sockaddr *sap)
{
  switch(type) {
  	case 1:
		return(INET6_getsock(bufp, sap));
	default:
		return(INET6_resolve(bufp, (struct sockaddr_in6 *) sap));
  }
}


struct aftype inet6_aftype = {
  "inet6",	NULL, /*"IPv6",*/	AF_INET6,	sizeof(struct in6_addr),
  INET6_print,	INET6_sprint,		INET6_input,	INET6_reserror,	
  INET6_rprint,	INET6_rinput
};


#endif	/* HAVE_AFINET6 */
