/* Copyright '97 by Andi Kleen. Subject to the GPL. */
/* This is unfinished work and bugs - it is alpha code. */

#include <ctype.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

struct entry {
	char *title;
	char *out; 
	enum { number, i_forward, i_inp_icmp, i_outp_icmp, 
	i_rto_alg } type; /* for special cases */
}; 

#define I_STATIC (1<<16) /* static configuration option. */

/* XXX check against the snmp mib rfc.
 */
struct entry Iptab[] = {
	{ "Forwarding", "Forwarding is %s", i_forward|I_STATIC },
	{ "DefaultTTL", "Default TTL is %d", number|I_STATIC },
	{ "InReceives", "%d total packets received", number },
	{ "InHdrErrors", "%d with invalid headers", number },
	{ "InAddrErrors", "%d with invalid addresses", number },
	{ "ForwDatagrams", "%d forwarded", number },
	{ "InUnknownProtos", "%d with unknown protocol", number },
	{ "InDiscards", "%d incoming packets discarded", number },
	{ "InDelivers", "%d incoming packets delivered", number },
	{ "OutRequests", "%d requests sent out", number }, /*?*/
	{ "OutDiscards", "%d outgoing packets dropped", number }, 
	{ "OutNoRoutes", "%d dropped because of missing route", number },
	{ "ReasmTimeout", "%d fragments dropped after timeout", number },
	{ "ReasmReqds", "%d reassemblies required", number }, /* ? */
	{ "ReasmOKs", "%d packets reassembled ok", number }, 
	{ "ReasmFails", "%d packet reassembles failed", number }, 
	{ "FragOKs", "%d fragments received ok", number },
	{ "FragFails", "%d fragments failed", number },
	{ "FragCreates", "%d fragments created", number }
};

struct entry Icmptab[] = {
	{ "InMsgs", "%d ICMP messages received", number },
	{ "InErrors", "%d ICMP failed.", number },
	{ "InDestUnreachs", "destination unreachable: %d", i_inp_icmp },
	{ "InTimeExcds", "timeout in transit: %d", i_inp_icmp },
	{ "InParmProbs", "wrong parameters: %d", i_inp_icmp },  /*?*/
	{ "InSrcQuenchs", "source quenchs: %d", i_inp_icmp },
	{ "InRedirects", "redirects: %d", i_inp_icmp },
	{ "InEchos", "echo requests: %d", i_inp_icmp },
	{ "InEchoReps", "echo replies: %d", i_inp_icmp },
	{ "InTimestamps", "timestamp request: %d", i_inp_icmp },
	{ "InTimestampReps", "timestamp reply: %d", i_inp_icmp },
	{ "InAddrMasks", "address mask request: %d", i_inp_icmp }, /*?*/
	{ "InAddrMaskReps", "address mask replies", i_inp_icmp }, /*?*/
	{ "OutMsgs", "%d ICMP messages sent", number },
	{ "OutErrors", "%d ICMP messages failed", number },
	{ "OutDestUnreachs", "destination unreachable: %d", i_outp_icmp },
	{ "OutTimeExcds", "time exceeded: %d", i_outp_icmp },
	{ "OutParmProbs", "wrong parameters: %d", i_outp_icmp }, /*?*/
	{ "OutSrcQuenchs", "source quench: %d", i_outp_icmp },
	{ "OutRedirects", "redirect: %d", i_outp_icmp },
	{ "OutEchos", "echo request: %d", i_outp_icmp },
	{ "OutEchoReps", "echo replies: %d", i_outp_icmp },
	{ "OutTimestamps", "timestamp requests: %d", i_outp_icmp },
	{ "OutTimestampReps", "timestamp replies: %d", i_outp_icmp },
	{ "OutAddrMasks", "address mask requests: %d", i_outp_icmp },
	{ "OutAddrMaskReps", "address mask replies: %d", i_outp_icmp },
};

struct entry Tcptab[] = {
	{ "RtoAlgorithm", "RTO algorithm is %s", i_rto_alg|I_STATIC },
	{ "RtoMin", "", number },
	{ "RtoMax", "", number },
	{ "MaxConn", "", number },
	{ "ActiveOpens", "%d active opens", number },
	{ "PassiveOpens", "%d passive opens", number },
	{ "AttemptFails", "%d failed connection attempts", number },
	{ "EstabResets", "%d connection resets received", number },
	{ "CurrEstab", "%d connections established", number },
	{ "InSegs", "%d segments received", number },
	{ "OutSegs", "%d segments send out", number },
	{ "RetransSegs", "%d segments retransmited", number },
};

struct entry Udptab[] = {
	{ "InDatagrams", "%d packets received", number },
	{ "NoPorts", "%d packets to unknown port received.", number },
	{ "InErrors", "%d packet receive errors", number },
	{ "OutDatagrams", "%d packets send", number },
};

struct tabtab {
	char *title; 
	struct entry *tab; 
	size_t size; 
}; 

struct tabtab snmptabs[] = { 
	{ "Ip", Iptab, sizeof(Iptab) },
	{ "Icmp", Icmptab, sizeof(Icmptab) },
	{ "Tcp", Tcptab, sizeof(Tcptab) },
	{ "Udp", Udptab, sizeof(Udptab) },
	{ NULL }
}; 

static char *skiptok(char *s)
{
	while (!isspace(*s) && *s != '\0')
		s++; 
	return s;
}


/* XXX IGMP */ 

int print_static; 

int cmpentries(void *a, void *b)
{
	return strcmp( ((struct entry*)a)->title, ((struct entry*)b)->title);
}

static enum { normal, iicmp, oicmp } state; 

void printval(struct tabtab *tab, char *title, int val) 
{
	struct entry *ent, key; 
	int type; 
	
	key.title = title; 
	ent = bsearch(&key, tab->tab, tab->size/sizeof(struct entry),
				  sizeof(struct entry), cmpentries); 
	if (!ent)  /* XXX warning */ 
		return;
	type = ent->type; 
	if (type & I_STATIC) {
		type &= ~I_STATIC; 
		if (!print_static) 
			return; 
	}
	if (*ent->out == '\0') 
		return; 
	switch (type) {
	case number:
		if (state != normal) putchar('\n');
		state = normal; 
		putchar('\t'); 
		printf(ent->out, val);
		putchar('\n'); 
		break; 
	case i_forward:
		state = normal;
		putchar('\t'); 
		printf(ent->out, val == 2 ? "enabled" : "disabled");
		putchar('\n');
		break; 
	case i_inp_icmp: 
		if (state != iicmp) 
			printf("\tICMP input histogram:\n\t"); 
		state = iicmp; 
		if (val > 0) {
			fputs("\t", stdout); 
			printf(ent->out, val); putchar('\n');
		}
		break; 
	case i_outp_icmp:
		if (state != oicmp)
			printf("\tICMP output histogram:\n\t"); 
		state = oicmp; 
		if (val > 0) {
			fputs("\t",stdout); 
			printf(ent->out, val); putchar('\n'); 
		}
		break; 
	case i_rto_alg: /* XXXX */
		state = normal; 
		break; 
	default:
		abort(); 
	}
}

struct tabtab *newtable(struct tabtab *tabs, char *title) 
{
	struct tabtab *t; 

	for (t = tabs; t->title; t++) 
		if (!strcmp(title, t->title)) {
			printf("%s:\n", title); 
			state = normal; 
			return t; 
		}
	return NULL; 
}

void parsesnmp()
{
	FILE *f; 
	char buf1[512], buf2[512]; 
	char *sp, *np, *p; 

	f = fopen("/proc/net/snmp", "r"); 
	if (!f) {
		perror("cannot open /proc/net/snmp");
		return;
	}
	while (fgets(buf1,sizeof buf1,f)) {
		int endflag; 
		struct tabtab *tab; 

		if (!fgets(buf2,sizeof buf2,f)) break; 
		sp = strchr(buf1, ':');
		np = strchr(buf2, ':'); 
		if (!np || !sp) 
			goto formaterr; 
		*sp = '\0'; 
		tab = newtable(snmptabs, buf1); 
		if (tab == NULL) /* XXX print warning */  
			continue; 
		np++; sp++; 
		
		endflag = 0; 
		while (!endflag) {
			while(isspace(*sp)) sp++; 
			while(isspace(*np)) np++; 
			/*if (*np == '\0') goto formaterr;*/ 

			p = skiptok(sp); 
			if (*p == '\0') endflag=1; 
			*p = '\0'; 
			printval(tab, sp, strtoul(np,&np,10)); 
			sp = p+1; 
		}
	}
	if (ferror(f)) 
		perror("/proc/net/snmp"); 
	fclose(f); 
	return; 

formaterr: 
	perror("error parsing /proc/net/snmp"); 
	return; 
}

void inittab()
{
	struct tabtab *t;
 
	/* we sort at runtime because I'm lazy ;) */ 
	for (t = snmptabs; t->title; t++)  
		qsort(t->tab, t->size/sizeof(struct entry), 
			  sizeof(struct entry), cmpentries); 
}
