/*
 * logging.h	Definitions for the logging functions.
 *
 * Authors:	Donald J. Becker, <becker@super.org>
 *		Rick Sladkey, <jrs@world.std.com>
 *		Fred N. van Kempen, <waltje@uWalt.NL.Mugnet.ORG>
 *
 *		This software maybe be used for any purpose provided
 *		the above copyright notice is retained.  It is supplied
 *		as is, with no warranty expressed or implied.
 */

#ifndef LOGGING_H
#define LOGGING_H

/* Logging/Debug levels */
#define L_ERROR		0x001
#define L_WARNING	0x002
#define D_GENERAL	0x004
#define D_CALL		0x008
#define D_FHCACHE	0x010
#define D_AUTH		0x020
#define D_UGID		0x040
#define D_RMTAB		0x080

/* Global Function prototypes. */
extern _PRO( void log_open, (char *progname, int foreground)		);
extern _PRO( void enable_logging, (char *kind)				);
extern _PRO( int  logging_enabled, (int level)				);
extern _PRO( void toggle_logging, (int sig)				);
extern _PRO( void dprintf, (int level, const char *fmt, ...)		);
extern _PRO( void log_call, (struct svc_req *rqstp, char *name,		\
			    char *arg)					);


#endif /* LOGGING_H */

/* End of logging.h. */
