/* 

   Fingerd with extended logging
   Version 0.0.01 based on NetBSD fingerd 8.1
   Created: February 4, 1995
   Copyright (C) 1995 Alexander O. Yuriev, <alex@bach.cis.temple.edu>
   Computer and Information Science Laboratories,
   Department of Computer and Information Science,
   TEMPLE UNIVERSITY, USA

   In order to compile fingerd with total logging of information,
   compile fingerd.c with macro LOGALL defined, otherwise you will receive
   Berkeley fingerd version 8.1. This version of fingerd can also be compiled
   to rely on a tcp wrapper to obtain the host and user that attempts to
   connect to a finger client. Generally, the tcp wrapper does better 
   job then the server itself. In order to place the job of determining 
   the source of call to a tcp wrapper, define macro NOLOOKUP.

   All information is logged with levels LOG_AUTHPRIV, LOG_WARNING.

*/


/*
 * Copyright (c) 1983, 1993
 *	The Regents of the University of California.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ifndef lint
static char copyright[] =
"@(#) Copyright (c) 1983, 1993\n\
	The Regents of the University of California.  All rights reserved.\n";
#endif /* not lint */

#ifndef lint
static char sccsid[] = "@(#)fingerd.c	8.1 (Berkeley) 6/4/93";
#endif /* not lint */

#ifdef LOGALL
#ifndef lint 
static char chpatchid[] = "@(#) Extended logging 0.0.1 by A. Yuriev, CIS Labs, TEMPLE UNIVERSITY";
#endif
#endif

#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <errno.h>

#include <unistd.h>
#include <syslog.h>
#include <netdb.h>
#include <stdio.h>
#include <stdlib.h>
#include <strings.h>
#include "pathnames.h"

void err __P((const char *, ...));

int
main(argc, argv)
	int argc;
	char *argv[];
{
	register FILE *fp;
	register int ch;
	register char *lp;
	struct hostent *hp;
	struct sockaddr_in sin;
	int p[2], logging, secure, sval;
#define	ENTRIES	50
	char **ap, *av[ENTRIES + 1], **comp, line[1024], *prog;
#ifdef LOGALL
	char **ppchReqInfo;
#endif

	prog = _PATH_FINGER;
#ifdef LOGALL
	logging = secure = 1;
#else
	logging = secure = 0;
#endif

#ifdef LOGALL
	openlog(argv[0],LOG_PID,LOG_AUTHPRIV);
#else
	openlog("fingerd", LOG_PID | LOG_CONS, LOG_DAEMON);
#endif
	opterr = 0;
	while ((ch = getopt(argc, argv, "slp:")) != EOF)
		switch (ch) {
		case 'l':
#ifndef LOGALL
			logging = 1;
#endif
			break;
		case 'p':
			prog = optarg;
			break;
		case 's':
#ifndef LOGALL
			secure = 1;
#endif
			break;
		case '?':
		default:
			err("illegal option -- %c", ch);
		}	
#ifndef NOLOOKUP
	if (logging) {
		sval = sizeof(sin);
		if (getpeername(0, (struct sockaddr *)&sin, &sval) < 0)
			err("getpeername: %s", strerror(errno));
		if (hp = gethostbyaddr((char *)&sin.sin_addr.s_addr,
		    sizeof(sin.sin_addr.s_addr), AF_INET))
			lp = hp->h_name;
		else
			lp = inet_ntoa(sin.sin_addr);
#ifdef LOGALL
		syslog(LOG_WARNING, "query from %s", lp);
#endif
		syslog(LOG_NOTICE, "query from %s", lp);
	}
#endif

	if (!fgets(line, sizeof(line), stdin))
		exit(1);
	
	comp = &av[1];
	for (lp = line, ap = &av[2];;) {
		*ap = strtok(lp, " \t\r\n");
		if (!*ap) {
			if (secure && ap == &av[2]) {
#ifdef LOGALL
			        syslog(LOG_WARNING, "BLOCKED REQUEST TO SUPPLY A LIST OF ALL ACTIVE USERS");

				puts("\nSorry, the username is required\r\n");
#else
				puts("must provide username\r\n"):
#endif
				exit(1);
			}
			break;
		}
		if (secure && strchr(*ap, '@')) {
#ifdef LOGALL
		        syslog(LOG_WARNING, "BLOCKED SERVICE FORWARDING REWUEST");
			puts("\nSorry, unable to provide the forwarding service at this time\r\n");
#else
			puts("fowarding service denied\r\n");
#endif
			exit(1);
		}

		/* RFC742: "/[Ww]" == "-l" */
		if ((*ap)[0] == '/' && ((*ap)[1] == 'W' || (*ap)[1] == 'w')) {
			av[1] = "-l";
			comp = &av[0];
		}
		else if (++ap == av + ENTRIES)
			break;
		lp = NULL;
	}

	if (lp = strrchr(prog, '/'))
		*comp = ++lp;
	else
		*comp = prog;
	if (pipe(p) < 0)
		err("pipe: %s", strerror(errno));

	switch(vfork()) {
	case 0:
		(void)close(p[0]);
		if (p[1] != 1) {
			(void)dup2(p[1], 1);
			(void)close(p[1]);
		}
#ifdef LOGALL
		ppchReqInfo = comp;
		while (*++ppchReqInfo)
		  syslog(LOG_WARNING,"account information requested, user %s",*ppchReqInfo);

#endif
		execv(prog, comp);
		err("execv: %s: %s", prog, strerror(errno));
		_exit(1);
	case -1:
		err("fork: %s", strerror(errno));
	}
	(void)close(p[1]);
	if (!(fp = fdopen(p[0], "r")))
		err("fdopen: %s", strerror(errno));
	while ((ch = getc(fp)) != EOF) {
		if (ch == '\n')
			putchar('\r');
		putchar(ch);
	}
	exit(0);
}

#if __STDC__
#include <stdarg.h>
#else
#include <varargs.h>
#endif

void
#if __STDC__
err(const char *fmt, ...)
#else
err(fmt, va_alist)
	char *fmt;
        va_dcl
#endif
{
	va_list ap;
#if __STDC__
	va_start(ap, fmt);
#else
	va_start(ap);
#endif
	(void)vsyslog(LOG_ERR, fmt, ap);
	va_end(ap);
	exit(1);
	/* NOTREACHED */
}
