.\"
.\"   $Id: radvd.conf.5.man,v 1.3 1997/01/07 22:16:57 lf Exp $
.\"
.\"   Authors:
.\"    Lars Fenneberg		<lf@elemental.net>	 
.\"
.\"   This software is Copyright 1996 by the above mentioned author(s), 
.\"   All Rights Reserved.
.\"
.\"   The license which is distributed with this software in the file COPYRIGHT
.\"   applies to this software. If your distribution is missing this file, you
.\"   may request it from <lf@elemental.net>.
.\"
.\"
.\"
.TH RADVD.CONF 5 "15 Dec 1996" "radvd @VERSION@" ""
.SH NAME
radvd.conf \- configuration file of the router advertisement daemon
radvd
.SH DESCRIPTION
This file describes the information which is included in the router
advertisement (RA) of a specific interface.
.P
The file contains one or more interface definitions of the form:

.nf
.BR "interface " "name " {
	list of interface specific options
	list of prefix definitions
.B }
.fi

All the possible interface specific options are detailed below. Each
option has to be terminated by a semicolon.
Prefix definitions are of the form:

.nf
.BR "prefix " prefix / "length " {
	list of prefix specific options
.B }
.fi

All the possible prefix specific options are described below. Each
option has to be terminated by a semicolon.

.SH INTERFACE SPECIFIC OPTIONS

.TP
.BR AdvSendAdvert " " on | off

A flag indicating whether or not the router sends
periodic router advertisements and responds to
router solicitations. 

.B "This option has to be specified and it has to come before all other interface specific options."

.TP
.BR "MaxRtrAdvInterval " seconds

The maximum time allowed between sending unsolicited multicast
router advertisements from the interface, in seconds.

Must be no less than 4 seconds and no greater than 1800 seconds.

Default: 600 seconds	

.TP
.BR "MinRtrAdvInterval " seconds

The minimum time allowed between sending unsolicited multicast
router advertisements from the interface, in seconds.

Must be no less than 3 seconds and no greater than 0.75 *
MaxRtrAdvInterval.

Default: 0.33 * MaxRtrAdvInterval

.TP
.BR AdvManagedFlag " " on | off

When set, hosts use the administered (stateful) protocol for address
autoconfiguration in addition to any addresses autoconfigured using
stateless address autoconfiguration.  The use of this flag is
described in RFC 1971.

Default: off

.TP
.BR AdvOtherConfigFlag " " on | off

When set, hosts use the administered (stateful) protocol for
autoconfiguration of other (non-address) information.  The use of
this flag is described in RFC 1971.

Default: off

.TP
.BR "AdvLinkMTU " integer

The MTU option is used in  router advertisement messages to insure
that all nodes on a link use the same MTU value in those cases where
the link MTU is not well known.

If specified, i.e. not 0, must be geater than 576 and not be greater
than the maximum MTU allowed for this link (e.g. ethernet has
a maximum MTU of 1500. See RFC 1972).

Default: 0

.TP
.BR "AdvReachableTime " milliseconds

The time, in milliseconds, that a node assumes a neighbor is
reachable after having received a reachability confirmation.  Used
by the Neighbor Unreachability Detection algorithm (see Section
7.3 of RFC 1970).  A value of zero means unspecified (by this router).

Must be no greater than 3,600,000 milliseconds (1 hour).

Default: 0

.TP
.BR "AdvRetransTimer " milliseconds

The time, in milliseconds, between retransmitted Neighbor
Solicitation messages.  Used by address resolution and the Neighbor
Unreachability Detection algorithm (see Sections 7.2 and 7.3 of RFC 1970).
A value of zero means unspecified (by this router).

Default: 0

.TP
.BR "AdvCurHopLimit " integer

The default value that should be placed in the Hop Count field of
the IP header for outgoing (unicast) IP packets.  The value should
be set to the current diameter of the Internet.  The value zero
means unspecified (by this router).

Default: 64

.TP
.BR "AdvDefaultLifetime " seconds

The lifetime associated with the default router in units of seconds. 
The maximum value corresponds to 18.2 hours.  A lifetime of 0
indicates that the router is not a default router and should not
appear on the default router list.  The router lifetime applies only
to the router's usefulness as a default router; it does not apply to
information contained in other message fields or options.  Options
that need time limits for their information include their own
lifetime fields.

Must be either zero or between MaxRtrAdvInterval and 9000 seconds.

Default: 3 * MaxRtrAdvInterval

.TP
.BR AdvSourceLLAddress " " on | off

When set, the link-layer address of the outgoing interface is
included in the RA.

Default: on

.SH PREFIX SPECIFIC OPTIONS

.TP
.BR AdvOnLink " " on | off
	
When set, indicates that this prefix can be used for on-link
determination.  When not set the advertisement makes no statement
about on-link or off-link properties of the prefix.  For instance,
the prefix might be used for address configuration with some of the
addresses belonging to the prefix being on-link and others being
off-link.

Default: on

.TP
.BR AdvAutonomous " " on | off

When set, indicates that this prefix can be used for autonomous
address configuration as specified in RFC 1971.

Default: on

.TP
.BR "AdvValidLifetime " seconds "" | infinity

The length of time in seconds (relative to the time the packet is
sent) that the prefix is valid for the purpose of on-link
determination.  The symbolic value
.B infinity
represents infinity (i.e. a value of all one bits (0xffffffff)).
The valid lifetime is also used by RFC 1971.

Default: infinity

.TP
.BR "AdvPreferredLifetime " seconds "" | infinity

The length of time in seconds (relative to the time the packet is
sent) that addresses generated from the prefix via stateless address
autoconfiguration remain preferred. 
The symbolic value
.B infinity
represents infinity (i.e. a value of all one bits (0xffffffff)).
See RFC 1971.

Default: 604800 seconds (7 days)
.SH EXAMPLE

.nf
interface eth0
{
	AdvSendAdvert on;
	prefix 5f04:f900:c2dd:1400:8000::0/80
	{
                AdvOnLink on;
                AdvAutonomous on;
	};
};
.fi

It says that router advertisement daemon should advertise (AdvSendAdvert
on;) the prefix 5f04:f900:c2dd:1400:8000::0 which has a lenght of 80 on the
interface eth0. Also the prefix should be marked as autonomous
(AdvAutonomous on;) and as on-link (AdvOnLink on;). All the other options
are left on their default values.

.SH FILES

.nf
@sbindir@/radvd
@PATH_RADVD_CONF@
@PATH_RADVD_LOG@
.fi

.SH CREDIT
The description of the different flags and variables is in large
parts taken from RFC 1970.

.SH RFCS
Narten, T., E. Nordmark, W. Simpson, "Neighbor Discovery for IP
Version 6 (IPv6)", RFC 1970, August 1996
.PP
Thomson, S., and T. Narten, "IPv6 Address Autoconfiguration", 
RFC 1971, August 1996.
.PP
Deering, S., and R. Hinden, Editors, "IP Version 6 Addressing
Architecture", RFC 1884, January 1996.
.PP	
Conta, A., and S. Deering, "Internet Control Message Protocol (ICMPv6)
for the Internet Protocol Version 6 (IPv6)", RFC 1885, January 1996.
.PP
Crawford, M., "A Method for the Transmission of IPv6 Packets over
Ethernet Networks", RFC 1972, August 1996.	

.SH "SEE ALSO"

.BR radvd (8)
