/*
 *   $Id: device-common.c,v 1.3 1997/01/16 21:14:38 lf Exp $
 *
 *   Authors:
 *    Lars Fenneberg		<lf@elemental.net>	 
 *
 *   This software is Copyright 1996 by the above mentioned author(s), 
 *   All Rights Reserved.
 *
 *   The license which is distributed with this software in the file COPYRIGHT
 *   applies to this software. If your distribution is missing this file, you
 *   may request it from <lf@elemental.net>.
 *
 */

#include "config.h"

#include <stdio.h>
#include <stdlib.h>
#include <syslog.h>
#include <errno.h>

#include <sys/types.h>
#include <sys/ioctl.h>
#include <sys/socket.h>
#include <netinet6/in6.h>
#include <netinet6/ipv6.h>

#include "radvd.h"
#include "defaults.h"

int
check_device(int sock, struct Interface *iface)
{
	struct ifreq	ifr;
	
	strcpy(ifr.ifr_name, iface->Name);
	
	if (ioctl(sock, SIOCGIFFLAGS, &ifr) < 0)
	{
		log(LOG_ERR, "ioctl(SIOCGIFFLAGS) failed for %s: %s", 
			iface->Name, strerror(errno));
		return (-1);
	}

	if (!(ifr.ifr_flags & IFF_UP))
	{
		log(LOG_ERR, "interface %s is not UP", iface->Name);
		return (-1);
	}
	
	if (!(ifr.ifr_flags & IFF_MULTICAST))
	{
		log(LOG_WARNING, "interface %s does not support multicast",
			iface->Name);
	}

	if (!(ifr.ifr_flags & IFF_BROADCAST))
	{
		log(LOG_WARNING, "interface %s does not support broadcast",
			iface->Name);
	}

	return 0;
}
