/*
 *   $Id: recv.c,v 1.3 1996/12/21 18:04:20 lf Exp $
 *
 *   Authors:
 *    Pedro Roque		<roque@di.fc.ul.pt>
 *    Lars Fenneberg		<lf@elemental.net>	 
 *
 *   This software is Copyright 1996 by the above mentioned author(s), 
 *   All Rights Reserved.
 *
 *   The license which is distributed with this software in the file COPYRIGHT
 *   applies to this software. If your distribution is missing this file, you
 *   may request it from <lf@elemental.net>.
 *
 */

#include <syslog.h>
#include <string.h>
#include <errno.h>

#include <sys/types.h>
#include <sys/socket.h>
#include <sys/time.h>

#include "radvd.h"

int
recv_rs(int sock, char *msg, struct sockaddr_in6 *addr,
                 struct in6_pktinfo **pkt_info)
{                 
	struct msghdr mhdr;
	struct cmsghdr *cmsg;
	struct iovec iov;
	static char chdr[sizeof(struct cmsghdr) + sizeof(struct in6_pktinfo)];
	int len;
	
	iov.iov_len = MSG_SIZE;
	iov.iov_base = msg;

	cmsg = (struct cmsghdr *) chdr;

	cmsg->cmsg_len   = (sizeof(struct cmsghdr) +
			    sizeof(struct in6_pktinfo));
	cmsg->cmsg_level = SOL_IPV6;
	cmsg->cmsg_type  = IPV6_RXINFO;

	*pkt_info = (struct in6_pktinfo *) cmsg->cmsg_data;

	mhdr.msg_name = addr;
	mhdr.msg_namelen = sizeof(struct sockaddr_in6);
	mhdr.msg_iov = &iov;
	mhdr.msg_iovlen = 1;
	mhdr.msg_control = (void *) cmsg;
	mhdr.msg_controllen = (sizeof(struct cmsghdr) +
			       sizeof(struct in6_pktinfo));

	len = recvmsg(sock, &mhdr, 0);
	
	if ((len < 0) && (errno != EINTR))
			log(LOG_WARNING, "recvmsg: %s", strerror(errno));

	dlog(LOG_DEBUG, 4, "recvmsg len=%d", len);

	return len;
}
