/*
 *   $Id: linklocal.c,v 1.3 1996/12/21 18:04:20 lf Exp $
 *
 *   Authors:
 *    Pedro Roque		<roque@di.fc.ul.pt>
 *    Lars Fenneberg		<lf@elemental.net>	 
 *
 *   This software is Copyright 1996 by the above mentioned author(s), 
 *   All Rights Reserved.
 *
 *   The license which is distributed with this software in the file COPYRIGHT
 *   applies to this software. If your distribution is missing this file, you
 *   may request it from <lf@elemental.net>.
 *
 */

#include <stdio.h>
#include <syslog.h>
#include <errno.h>

#include <sys/types.h>
#include <netinet6/in6.h>
#include <netinet6/ipv6.h>

#include "radvd.h"
#include "pathnames.h"		/* for PATH_PROC_NET_IF_INET6 */

/*
 * this function extracts the link local address and interface index
 * from PATH_PROC_NET_IF_INET6
 */
int setup_linklocal_addr(struct Interface *iface)
{
	FILE *fp;
	char str_addr[40];
	int plen, scope, dad_status, if_idx;
	char devname[IFNAMSIZ];

	if ((fp = fopen(PATH_PROC_NET_IF_INET6, "r")) == NULL)
	{
		log(LOG_ERR, "can't open %s: %s", PATH_PROC_NET_IF_INET6,
			strerror(errno));
		return (-1);	
	}
	
	while (fscanf(fp, "%32s %02x %02x %02x %02x %s\n",
		      str_addr, &if_idx, &plen, &scope, &dad_status,
		      devname) != EOF)
	{
		if (scope == IPV6_ADDR_LINKLOCAL &&
		    strcmp(devname, iface->Name) == 0)
		{
			struct in6_addr addr;
			unsigned int ap;
			int i;
			
			for (i=0; i<16; i++)
			{
				sscanf(str_addr + i * 2, "%02x", &ap);
				addr.s6_addr[i] = (unsigned char)ap;
			}
			memcpy(&iface->if_addr, &addr,
			       sizeof(struct in6_addr));

			iface->if_index = if_idx;
			fclose(fp);
			return 0;
		}
	}

	log(LOG_ERR, "no linklocal address configured for %s", iface->Name);
	fclose(fp);
	return (-1);
}
