/*
 * $Id: uping.c,v 1.2 1997/03/20 14:25:26 labovit Exp $
 */

#include <sys/types.h>
#include <sys/stropts.h>
#include <mrt.h>
#ifdef HAVE_SYS_DLPI_H 
#include <sys/dlpi.h>
#include <sys/ethernet.h>
#else
#include <net/if_arp.h>
#include <netinet/if_ether.h> 
#endif 
#include <stdio.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/types.h> 
#include <sys/timeb.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <netinet/in.h>
#include <netinet/in_systm.h>
#include <netinet/ip.h>
#include <time.h>
#include <timer.h>
#ifndef _NIT
#include "dltest.h"
#endif
#include "uping.h"
#include "config.h"
#include "propertyList.h"
#include "salamanderInterface.h"

void check_passwd ();
int send_udp ();
int init_publish ();
int publish ();
int show_peers ();

/*
 * Xmit data buffer.  Fill with whatever pattern you like ...
 */
u_char		xmitbuf[9024];
LINKED_LIST	*ll_uping_dst;
LINKED_LIST	*ll_peer;
timer_t		*ping_timer;		/* send out pings */
timer_t		*stats_timer;	        /* calculate and publish statistics */
timer_t		*retry_timer;		/* retry down connections (peer and salamander) */
int		fd;
struct ether_addr ether_addr;
trace_t *default_trace;
extern config_master_t *CONFIG;
int sockfd;


void retry () {
  uping_peer_t *uping_peer;

  LL_Iterate (ll_peer, uping_peer) {
    if (uping_peer->state == 0) {
      trace (NORM, CONFIG->trace, "Retrying connection to %s\n", 
	     prefix_toa (uping_peer->prefix));
      uping_peer_connect (uping_peer);
    }
  }
}


void calculate_statistics () {
  uping_dst_t *uping_dst;
  ping_t *ping, *ping_tmp;
  u_long now;
  int packets;


  LL_Iterate (ll_uping_dst,  uping_dst) {
    uping_dst->delay = 0;
    uping_dst->sent = 0;
    uping_dst->recv = 0;
    now = time (NULL);
    
    /* 
     * critical section 
     */
    pthread_mutex_lock  (&uping_dst->mutex_lock);

    LL_Iterate (uping_dst->ll_sent, ping) {
      ping_tmp = LL_GetPrev (uping_dst->ll_sent, ping);
      uping_dst->sent++;
      if (ping->delay < -1) {
	uping_dst->recv++;
	uping_dst->delay += ping->delay;
      }
      

      /* leave 20 seconds room */
      if (now - ping->sent_sec <= 20) {
	/* report stats */
	trace (NORM, default_trace, "%d sent, %d recv, %d delay, %d duplicate\n", 
	       uping_dst->sent, uping_dst->recv, uping_dst->delay, uping_dst->duplicate);
	publish (uping_dst);
	uping_dst->duplicate = 0;
	LL_Remove (uping_dst->ll_sent, ping);
	Delete (ping);
	ping = ping_tmp;
	break;
      }

      LL_Remove (uping_dst->ll_sent, ping);
      Delete (ping);
      ping = ping_tmp;
    }

    /*
     * end critical section
     */
    pthread_mutex_unlock  (&uping_dst->mutex_lock);
  }
}


/*
 * void update_local_stat ()
 * find the ping entry that correspond to this time and msec. Update
 * this entry with the delay and mark that it has been received
 */
void update_stats (u_short AS, u_long dst, u_long sec, u_short msec, u_long rsec, u_short rmsec) {
  uping_dst_t *uping_dst;
  ping_t *ping;
  long delay, sent, recv;

  LL_Iterate (ll_uping_dst,  uping_dst) {


    if (uping_dst->AS == AS) {


	/* 
	 * critical section 
	 */
	pthread_mutex_lock  (&uping_dst->mutex_lock);

      LL_Iterate (uping_dst->ll_sent, ping) {
	if ((ping->sent_sec == sec) && (ping->sent_msec == msec)) {
	  sent = sec * 1000 + msec;
	  recv = rsec *1000 + rmsec;
	  printf ("%d\n", recv -sent);
	  delay = recv - sent;
	  if (ping->delay != -1 ) {
	    uping_dst->duplicate++;
	    printf ("duplictae\n\n");
	  }
	  ping->delay = delay;
	  pthread_mutex_unlock  (&uping_dst->mutex_lock);
	  goto done;
	}
      }
      pthread_mutex_unlock  (&uping_dst->mutex_lock);
    }
  }

done:
  return;
}


void uping_timer () {
  uping_dst_t *uping_dst;
  int i;

  LL_Iterate (ll_uping_dst,  uping_dst) {
    for (i=0; i< CONFIG->sequence; i++) {
      send_udp (fd, &ether_addr, uping_dst, CONFIG->packet_size);
      trace (NORM, default_trace, "Sending uping to %s via %s\n", 
	     prefix_toa (uping_dst->dst),
	     ether_ntoa (uping_dst->ether_addr));
    }
  }
}

int show_stats (uii_connection_t *uii) {
  uping_dst_t *uping_dst;
  char *type[] = {"local ", "remote"};

  LL_Iterate (ll_uping_dst,  uping_dst) {
    uii_send_data (uii, "%s AS%d %s via %s\r\n", type[uping_dst->type], 
		   uping_dst->AS, prefix_toa (uping_dst->dst), 
		   ether_ntoa (uping_dst->ether_addr));
    uii_send_data (uii, "\tsent %d, recv %d, delay %d, duplicate %d\r\n",
		   uping_dst->sent, uping_dst->recv, uping_dst->delay, uping_dst->duplicate);
  }
}



main(int argc, char *argv)
{
  char *name = (char *) argv[0];
  int daemon = 0;
  char tmp[100];
  extern char *optarg;	/* getopt stuff */
  extern int optind;	/* getopt stuff */
  char c;
  char *config_file = NULL;
  char *port = "mrt";
  int errors = 0;

  char *usage ="Usage: %s [-f config_file] [-p uii_port ] [-v] [-n]\n";

  default_trace = New_Trace ();

  while ((c = getopt (argc, argv, "hnvf:p:")) != -1) 
     switch (c) {
     case 'v': /* verbose */
       set_trace (default_trace, TRACE_FLAGS, NORM, 
		  TRACE_LOGFILE, "stdout",
		  NULL);
	daemon = 0;
       break;
     case 'f': /* config file */
       config_file = optarg;
       break;
     case 'p': /* uii port number */
       port = optarg;
       break;
     case 'h':
     default:
       errors++;
       break;
     }

   if (errors) {
     fprintf(stderr, usage, name);
     printf ("\nMRT %s compiled on %s\n\n",
	     MRT_VERSION, __DATE__);
     exit (1);
   }
  
  init_trace (name, daemon);
  init_mrt (default_trace);
  init_config (default_trace);

  ll_uping_dst = LL_Create (NULL);
  ll_peer = LL_Create (NULL);
  config_from_file (config_file);
  init_recv ();

  fd = init_dlpi (&ether_addr);
  init_publish ();	/* salamander webcasting */
 
  ping_timer = 
    New_Timer ((void *) uping_timer, CONFIG->interval, "UPing timer", NULL);
  timer_set_jitter (ping_timer, CONFIG->jitter);
  Timer_Turn_ON (ping_timer);

  stats_timer = 
    New_Timer ((void *) calculate_statistics, 30, "Stats timer", NULL);
  Timer_Turn_ON (stats_timer);

  retry_timer =   New_Timer ((void *) retry, 60, "Retry Timer", NULL);
  Timer_Turn_ON (retry_timer);

  UII->initial_state = 0;
  set_uii (UII, UII_PROMPT, 0, "password> ");
  set_uii (UII, UII_PROMPT, 1, "UPING-1.0> ");
  uii_add_command (0, "", (void *) check_passwd);
  uii_add_command (1, "show stats", (void *) show_stats);
  uii_add_command (1, "show peers", (void *) show_peers);
  listen_uii2 (port);

  init_uping_peer_listen ();

  while (1) {
#ifndef HAVE_LIBPTHREAD
    while (process_all_schedules()); /* process all first */
    mrt_select ();
#else
    sleep (1);
#endif /* THREADS */
  }
}




int init_dlpi (struct ether_addr *ether_addr) {
  int	fd;
  long	buf[MAXDLBUF];
  union DL_primitives *dlp;

  int	i;

  /* initialize buf[] */
  for (i = 0; i < MAXDLBUF; i++)
    buf[i] = (unsigned char) i & 0xff;

  /*
   * Open the device.
   */
  if ((fd = open(CONFIG->device, 2)) < 0)
    perror ("Could not open device");
  
  /*
   * Attach.
   */
  dlattachreq(fd, 0); /* just use 0 for ppa */
  dlokack(fd, buf);

  /*
   * Bind.
   */
  dlbindreq(fd, 0, 0, DL_CLDLS, 0, 0);
  dlbindack(fd, buf);


  /*
   * Get our physical address.
   */
  dlphysaddrreq(fd, DL_CURR_PHYS_ADDR);
  dlphysaddrack(fd, buf);
  dlp = (union DL_primitives*) buf;
  memcpy(ether_addr, OFFADDR(dlp, dlp->physaddr_ack.dl_addr_offset), ETHERADDRL);

  return (fd);
}




int send_udp (int fd, 
	      struct ether_addr *ether_addr,
	      uping_dst_t *uping_dst, int size) 
{ 

  u_char *dstmac; 
  u_char addr[1024]; 
  u_char localphys[6]; 
  u_char *phys, *iph, *cp;
  u_char *checksum, *udph, *udp_checksum, *data;
  struct	ether_header	*ehp;
  struct timeb *tp;
  ping_t *ping;

  tp = New (struct timeb);
  ehp = (struct ether_header*) xmitbuf;

  memcpy(&ehp->ether_dhost, 
	 (u_char *) &uping_dst->ether_addr, ETHERADDRL); /* dst */
  memcpy(&ehp->ether_shost, ether_addr, ETHERADDRL);   /* src */
  ehp->ether_type = (u_short) 0x0800; /*  ETHERTYPE_IP */

  if (strioctl(fd, DLIOCRAW, -1, 0, 0) < 0)
    perror ("ioctl DLIOCRAW");

  
  /*
   * IP Header creation
   */
	
  iph = cp = xmitbuf + 14;
  UTIL_PUT_BYTE (69, cp);   /* version & IHL */
  UTIL_PUT_BYTE (0, cp);   /*  TOS */
  UTIL_PUT_SHORT (28 + size, cp);  /*  total length */

  UTIL_PUT_SHORT (34783, cp);   /*  ID */
  UTIL_PUT_BYTE  (64, cp);   /*  flags & offset */
  UTIL_PUT_BYTE  (0, cp);   /*  flags & offset */
	
  UTIL_PUT_BYTE (255, cp);   /*  TTL */
  UTIL_PUT_BYTE (IPPROTO_UDP, cp);   /*  protocol */
  checksum = (u_char *) cp;
  UTIL_PUT_SHORT (0, cp);   /* set checksum to 0 for now */

  UTIL_PUT_LONG (htonl (prefix_tolong (CONFIG->source_ip)), cp); /* src */
  UTIL_PUT_LONG (htonl (prefix_tolong (uping_dst->dst)), cp); /* dst */
  
  /* UTIL_PUT_LONG (0, cp);  options */
	
  /* now calculate checksum */
  UTIL_PUT_SHORT (in_cksum(iph), checksum);

  /* 
   * now on to the UDP part 
   */
  udph = cp;
  UTIL_PUT_SHORT (34583, cp);   /*  source port      */
  UTIL_PUT_SHORT (PORT, cp);   /*  destination port */
  /*UTIL_PUT_SHORT (0x09, cp);     length */
  UTIL_PUT_SHORT (8 + size, cp);    /* length */

  udp_checksum = cp;
  UTIL_PUT_SHORT (0x0, cp);   /* checksum */

  /* 
   * data section (minimum of 14 bytes)
   * 1 type | 4 time | 2 mill time | 2 AS | 4 src | 4 dst 
   */
  data = cp;
  ftime (tp);
  UTIL_PUT_BYTE (uping_dst->type, cp);
  UTIL_PUT_LONG (htonl (tp->time), cp);   /* time */
  UTIL_PUT_SHORT (htons (tp->millitm), cp);   /* sequence num */
  UTIL_PUT_SHORT (htons (uping_dst->AS), cp);   /* AS */
  UTIL_PUT_LONG (htonl (prefix_tolong (CONFIG->source_ip)), cp);   /* src ip */
  UTIL_PUT_LONG (htonl (prefix_tolong (uping_dst->dst)), cp);   /* dst ip */

  ping = New (ping_t);
  ping->sent_sec = tp->time;
  ping->sent_msec = tp->millitm;
  ping->delay = -1;
  LL_Add (uping_dst->ll_sent, ping); 

  {
    /* build and checksum the pseudoheader */
    char yu[9046];
    cp = yu;
    UTIL_PUT_LONG (htonl (prefix_tolong (CONFIG->source_ip)), cp); /* src */
    UTIL_PUT_LONG (htonl (prefix_tolong (uping_dst->dst)), cp); /* dst */
    UTIL_PUT_BYTE (0, cp);
    UTIL_PUT_BYTE (IPPROTO_UDP, cp);   /*  protocol */
    UTIL_PUT_SHORT (8 + size, cp);   /*  length */
    memcpy (cp, udph, 8 + size);


    /*UTIL_PUT_SHORT (chksum(yu, 12 + 10), udp_checksum);*/
    UTIL_PUT_SHORT (chksum(yu, 12 + 8 + size), udp_checksum);
  }

	

  if (write(fd, xmitbuf, 28 + size + 100) < 0) 
    perror ("write");

  /*
  {
    u_long tim;
    struct tm *tm;
    char tmpg[100], buffer[512], *cp;
    char temp[100];
    int nn;

    tim = time(NULL);
    tm = (struct tm*) localtime(&tim);
    strftime (tmpg, 100, "%y%m%d.%H", tm);
    sprintf (temp, "%s/%s.sent.%d.%s", CONFIG->log_dir, 
	     CONFIG->name, uping_dst->AS, tmpg);
    if ((nn = open (temp, (O_APPEND | O_WRONLY| O_CREAT), 0666)) < 1) {
      perror ("open failed");
    }
    fchmod(nn, 0666);
    
    write (nn, data, 17);
    close (nn);
    }
  */


  return (0);
}



/*
 * compute an IP header checksum.
 * don't modifiy the packet.
 */
static int
in_cksum(u_char *ip)
{
        register const u_short *sp = (u_short *)ip;
        register u_long sum = 0;
        register int count;

        /*
         * No need for endian conversions.
         */
        for (count = 10; --count >= 0; )
                sum += *sp++;
        while (sum > 0xffff)
                sum = (sum & 0xffff) + (sum >> 16);
        sum = ~sum & 0xffff;

        return (sum);
}



u_short chksum(buf,len)
u_short *buf;
int     len;
{
        u_long  sum = 0;
        int     nwords = len >> 1;

        for(; nwords > 0; nwords--)
                sum += *buf++;
        sum = (sum>>16) + (sum & 0xffff);
        sum += (sum >>16);
        return (~sum);
}




void uping_recv () {
  char tmp[1024];
  u_char type;
  u_char *cp = tmp;
  int n;
  u_long sec;
  u_short AS, msec;
  u_long src, dst;
  struct timeb tp;

  n = read (sockfd, tmp, 1024); 


  ftime (&tp);

  UTIL_GET_BYTE (type, cp);	/* type */
  UTIL_GET_NETLONG (sec, cp); /* time */
  UTIL_GET_SHORT (msec, cp);  /* sequence number */
  UTIL_GET_SHORT (AS, cp);      
  UTIL_GET_LONG (src, cp);
  UTIL_GET_LONG (dst, cp);

  /*
  {
    u_long tim;
    struct tm *tm;
    char tmpg[100], buffer[512], *cp;
    char temp[100];
    int nn;

    tim = time(NULL);
    tm = (struct tm*) localtime(&tim);
    strftime (tmpg, 100, "%y%m%d.%H", tm);
    sprintf (temp, "%s/%s.recv.%d.%s", CONFIG->log_dir, CONFIG->name,
	     AS, tmpg);
    if ((nn = open (temp, (O_APPEND | O_WRONLY| O_CREAT), 0666)) < 1) {
      perror ("open failed");
    }
    fchmod(nn, 0666);
    
    cp = tmp;
    write (nn, cp, 17);
    close (nn);
  }
  */

  if (type == 0) {
    update_stats (AS, 0, sec, msec, tp.time, tp.millitm);
  }
  else {
    update_peer (src, AS, sec, msec, &tp);
  }

  select_enable_fd (sockfd);  
}


int init_recv () {
  struct sockaddr_in serv_addr;
  char buffer[100];
  struct sockaddr from;
  int fromlen;

  /*serv_addr.sin_port = htons (5670);*/
  serv_addr.sin_port = PORT;
  serv_addr.sin_family = AF_INET;
  serv_addr.sin_addr.s_addr = htonl (INADDR_ANY);

  if ( (sockfd = socket (AF_INET, SOCK_DGRAM, 0)) < 0) {
    trace (NORM, default_trace, "ERROR -- Could not get socket (%s)\n",
	   strerror (errno));
    return (-1);
  }

  if (bind (sockfd, (struct sockaddr *) &serv_addr, sizeof (serv_addr)) < 0) {
    perror ("bind");
  }

  trace (NORM, default_trace, "Listening for uping packets  on port %d\n", 
	 5670);

   select_add_fd (sockfd, 1, (void *) uping_recv, sockfd);
   select_enable_fd (sockfd);

}



int init_publish () {
  int ret;
  int sskey = 1234567;

  ret = connectToSalamanderServer(prefix_toa (CONFIG->publish_prefix), CONFIG->key);
  trace (NORM, default_trace, "Connecting to Salamander WebCasting Server %s (key %d)\n", 
	 prefix_toa (CONFIG->publish_prefix), CONFIG->key);
}


int publish (uping_dst_t *uping_dst) {
  plist_t plist;
  char tmp[1000];
  int ret;

  plist = createPropertyList();
  updateProperty(plist, COMMAND_PROPERTY, PUBLISH_COMMAND);
  updateProperty(plist, NAME_PROPERTY, "netnow:mae-east");

  sprintf (tmp, "%s %d send:%d recv:%d delay:%d duplicate:%d",
	   prefix_toa (uping_dst->dst),
	   uping_dst->AS, 
	   uping_dst->sent, uping_dst->recv, 
	   uping_dst->delay, uping_dst->duplicate);

  ret = salamanderSendServerData(plist, tmp, strlen (tmp));

  if (ret != SALAMANDER_OK) {
    trace (NORM, default_trace, "Salamdner error!\n");
    init_publish ();
  }

}
