#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <signal.h>
#include <time.h>
#include <New.h>
#include <io.h>

#define MYTYPE		MSG_PROTOCOL_BGP
#define MYSUBTYPE	MSG_BGP_NULL

#define IO_READ		1
#define IO_WRITE	2

void print_clear_msg(mrt_msg_t *msg);
void cleanup(int arg);

int io_mode;
int VERBOSE;
io_t *IO;

void
main(int argc, char **argv)
{
   int arg;
   int errs = 0;
   mrt_msg_t *msg;
   extern char *optarg;
   int wait_flag = 0;
   int last_time = 0;

   IO = (io_t *) New_IO (NULL);

   while((arg = getopt(argc, argv, "vtr:w:i:o:")) != EOF) {
      switch(arg) {
      case 'r': /* in message key */
        if (io_set(IO, IO_INMSGQ, (char *) (optarg), NULL) < 0) {
          printf ("\nError setting infile %s\n", optarg);
          errs++;
        }
	break;
      case 'w':
	if (io_set(IO, IO_OUTMSGQ, (char *) (optarg), NULL) < 0) {
          printf ("\nError setting outfile %s\n", optarg);
          errs++;
        } 
	break;
      case 'o': /* out data file name */
	if (io_set(IO, IO_OUTFILE, (char *) (optarg), NULL) < 0) {
          printf ("\nError setting outfile %s\n", optarg);
          errs++;
        } 
	break;
      case 'i': /* in data file name */
        if (io_set(IO, IO_INFILE, (char *) (optarg), NULL) < 0) {
          printf ("\nError setting infile %s\n", optarg);
          errs++;
        }
	break;
      case 't': /* sleep appropriate time interval between msgs */
	wait_flag = 1;
	break;
      case 'v': /* verbose logging to stdout */
	VERBOSE = 1;
	break;
      case '?':
	 errs++;
	 break;
      }
   }

    if(errs)  {
      fprintf(stderr, "usage: mrt_io [-tv] [-r|-i] input [-o|-w] output\n");
      exit(1);
   }

   signal(SIGHUP, cleanup);
   signal(SIGINT, cleanup);
   signal(SIGTERM, cleanup);

   while((msg = io_read(IO))) {

     /* recreate real time intervals of message */
     if ((wait_flag) && (last_time > 0)) {
       if (VERBOSE)
	 printf ("Sleeping %d\n", msg->tstamp - last_time);
       sleep (msg->tstamp - last_time);
     }

     io_write (IO, msg->tstamp, msg->type, msg->subtype, msg->length, msg->value);
     last_time = msg->tstamp;
     Delete(msg);
   } 
}


void
print_clear_msg(mrt_msg_t *msg)
{
   char *timestr;

   timestr = ctime(&(msg->tstamp));
   timestr[24] = '\0';
   msg->value[msg->length] = '\0';

   printf("priority=%d, tstamp=%s, type=%d, subtype=%d, str=\"%s\"\n",
	  msg->priority, timestr, msg->type, msg->subtype, msg->value);
}


void
cleanup(int arg)
{
   printf("cleanup called\n");
   if(io_mode == IO_READ) {
      printf("cleanup: setting I/O mode IO_INNONE\n");
      io_set(IO, IO_INNONE, NULL, NULL);
   } else if(io_mode == IO_WRITE) {
      printf("cleanup: setting I/O mode IO_OUTNONE\n");
      io_set(IO, IO_OUTNONE, NULL, NULL);
   }

   exit(0);
}
