/*
 * $Id: sunos.c,v 1.2 1997/03/21 11:34:47 masaki Exp $
 */

#include <config.h>
#include <stdio.h>
#include <version.h>
#include <sys/ioctl.h>
#include <sys/sockio.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <net/route.h>
#include <syslog.h>
#include <string.h>
#include <New.h>
#include <linked_list.h>
#include <interface.h>
#include <rib.h>


#define MAX_INTERFACES 32	/* Yeah right. */
extern interface_master_t *INTERFACE_MASTER;

interface_t *ifstatus (char *name);

void read_interfaces () {
  struct ifconf ifc;
  struct ifreq ifreq, *ifptr, *end;
  int s, n, bufsize;
  char *name;
  interface_t *interface;

  char buffer[MAX_INTERFACES * sizeof(struct ifreq)];

  if ((s = socket (AF_INET, SOCK_DGRAM, 0)) < 0) {
    trace (FATAL, INTERFACE_MASTER->trace, 
	     "socket: %s\n", strerror (errno));
    return;
  }

  ifc.ifc_len = sizeof (buffer);
  ifc.ifc_buf = buffer;

  if (ioctl(s, SIOCGIFCONF, (char *)&ifc) < 0) {
    close(s);
    trace (ERROR, INTERFACE_MASTER->trace, 
      "SIOCGIFCONF (%s)\n", strerror (errno));
    return;
  }
  close (s);

  end = (struct ifreq *) (ifc.ifc_buf + ifc.ifc_len);
  ifptr = ifc.ifc_req;

  while (ifptr < end) {
    name = ifptr->ifr_name;
    interface = ifstatus (name);
    if (interface == NULL) continue;
    ifstatus_v4 (interface, name);
    ifptr++;
  }
}


/* get interface configuration */
interface_t *ifstatus (char *name) {
  struct ifreq ifr;
  int s;
  u_long flags, mtu;
  char tmp[MAXLINE];
  char *cp;
  interface_t *interface;

  strncpy (ifr.ifr_name, name, sizeof (ifr.ifr_name));

  if (cp = strrchr (ifr.ifr_name, ':'))
    *cp = '\0'; /* Remove the :n extension from the name */

  if (interface = find_interface_byname (ifr.ifr_name))
    return (interface);

  if ((s = socket (AF_INET, SOCK_DGRAM, 0)) < 0) {
    trace (FATAL, INTERFACE_MASTER->trace, 
	     "socket: %s\n", strerror (errno));
    /* NOTREACHED */
  }

  if (ioctl(s, SIOCGIFFLAGS, (caddr_t)&ifr) < 0) {
    trace (ERROR, INTERFACE_MASTER->trace, 
	"SIOCGIFFLAGS for % (%s)\n", name, strerror (errno));
    close(s);
    return (NULL);
  }
  assert (sizeof (ifr.ifr_flags) == 2); 
  flags = ifr.ifr_flags&0x0000ffff; /* short */

#define ifr_mtu ifr_metric
  if (ioctl(s, SIOCGIFMTU, (caddr_t)&ifr) < 0) {
    trace (ERROR, INTERFACE_MASTER->trace, 
	"SIOCSIFMTU for % (%s)\n", name, strerror (errno));
    ifr.ifr_mtu = 576; /* don't care */
  }
  mtu = ifr.ifr_mtu;

  interface = new_interface (name, flags, mtu, 0);
  close(s);
  return (interface);
}


/* get interface configuration for IPv4 */
int ifstatus_v4 (interface_t *interface, char *name) {
  struct ifreq ifr;
  struct sockaddr_in addr, mask, dest;
  int s;
  u_long flags;
  char *cp;

  if ((s = socket (AF_INET, SOCK_DGRAM, 0)) < 0) {
    trace (FATAL, INTERFACE_MASTER->trace, 
	     "socket: %s\n", strerror (errno));
    /* NOTREACHED */
  }

  memcpy (ifr.ifr_name, name, sizeof (ifr.ifr_name));
  flags = interface->flags;

  if (ioctl(s, SIOCGIFADDR, (caddr_t)&ifr) < 0) {
    trace (ERROR, INTERFACE_MASTER->trace, 
	"SIOCGIFADDR for % (%s)\n", name, strerror (errno));
    close (s);
    return (-1);
  }
  memcpy (&addr, &ifr.ifr_addr, sizeof (addr));

  if (addr.sin_family != AF_INET || addr.sin_addr.s_addr == INADDR_ANY) {
#if 0
    trace (ERROR, INTERFACE_MASTER->trace, 
      "SIOCGIFADDR returns strange address (family=%d)\n", addr.sin_family);
#endif
    close (s);
    return (1);
  }

  if (ioctl(s, SIOCGIFNETMASK, (caddr_t)&ifr) < 0) {
    trace (ERROR, INTERFACE_MASTER->trace, 
      "SIOCGIFNETMASK for % (%s)\n", name, strerror (errno));
    /* sometimes, no netmask */
    memset (&ifr.ifr_addr, -1, sizeof (ifr.ifr_addr));
  }
  memcpy (&mask, &ifr.ifr_addr, sizeof (mask));

  if (BIT_TEST (flags, IFF_POINTOPOINT)) {
    if (ioctl(s, SIOCGIFDSTADDR, (caddr_t)&ifr) < 0) {
      trace (ERROR, INTERFACE_MASTER->trace, 
        "SIOCGIFDSTADDR for % (%s)\n", name, strerror (errno));
      /* sometimes, no destination address */
      memset (&ifr.ifr_addr, 0, sizeof (ifr.ifr_addr));
    }
  }
  else if (BIT_TEST (flags, IFF_BROADCAST)) {
    if (ioctl(s, SIOCGIFBRDADDR, (caddr_t)&ifr) < 0) {
      trace (ERROR, INTERFACE_MASTER->trace, 
        "SIOCGIFBRDADDR for % (%s)\n", name, strerror (errno));
      /* sometimes, no broadcast address ??? */
      memset (&ifr.ifr_addr, 0, sizeof (ifr.ifr_addr));
    }
  }
  memcpy (&dest, &ifr.ifr_addr, sizeof (dest));

  if (cp = strchr (ifr.ifr_name, ':'))
    *cp = '\0'; /* Remove the :n extension from the name */

  add_addr_to_interface (interface, AF_INET, 
      (char *)&addr.sin_addr.s_addr,
       mask2len ((char *)&mask.sin_addr.s_addr, 4),
      (char *)&dest.sin_addr.s_addr);
  close (s);
  return (1);
}


/* kernel_update_route
 * 0 = add, 1 = change, 2 = delete
 */
int kernel_update_route (int cmd, prefix_t *dest, prefix_t *next_hop, int index)
{
  int s;
  struct rtentry rt;
  struct sockaddr_in *dst = (struct sockaddr_in *)&rt.rt_dst;
  struct sockaddr_in *gateway = (struct sockaddr_in *)&rt.rt_gateway;
  struct ifnet inf;
  interface_t *interface;
  int op;

  if (dest->family == AF_INET) {

    if ((s = socket (AF_INET, SOCK_DGRAM, 0)) < 0) {
      trace (FATAL, MRT->trace, "kernel socket (%s)\n", strerror (errno));
      return (-1);
    }

    memset (&rt, 0, sizeof (rt));

    dst->sin_family = AF_INET;
    memcpy (&dst->sin_addr, prefix_tochar (dest), sizeof (dst->sin_addr));

    gateway->sin_family = AF_INET;
    memcpy (&gateway->sin_addr, prefix_tochar (next_hop), 
        sizeof (gateway->sin_addr));

    if (dest->bitlen == 32)
      rt.rt_flags  |= RTF_HOST;

    rt.rt_flags  |= RTF_UP;
    if (gateway->sin_addr.s_addr != INADDR_ANY) {
      rt.rt_flags |= RTF_GATEWAY;
    }
#ifdef notdef
    if (cmd == KERNEL_UPDATE_ADD) {
      /* I'm not sure this does work -- masaki */
      interface = find_interface_byindex (index);
      inf.if_name = interface->name;
      rt.rt_ifp =  &inf;
    }
#endif

    switch (cmd) {
      case KERNEL_UPDATE_ADD:
        op = SIOCADDRT;
        break;
      case KERNEL_UPDATE_DEL:
        op = SIOCDELRT;
        break;
      default:
        assert (0);
        break;
    }
    if (ioctl (s, op, &rt) < 0) {
      trace(ERROR, MRT->trace, "kernel ioctl (%s)\n", strerror (errno));
      close (s);
      return (-1);
    }
  
  }
  else {
    assert (0); /* not a family we know about */
  }

  close (s);
  return (1);
}


int kernel_read_rt_table (void (*add_kernel_route)())
{
   /* should read /dev/kmem */
}
