/* 
 * $Id: route_manager.h,v 1.3 1996/09/03 20:03:43 masaki Exp $ 
 */

#ifndef _ROUTE_MANAGER_H
#define _ROUTE_MANAGER_H

#include <lbgp.h>
#include <stack.h>
#include <radix.h>
#include <trace.h>

#ifndef HAVE_PTHREAD_H
#include <pthread_fake.h>
#else
#include <pthread.h>
#endif /* HAVE_PTHREAD_H */


/* defined in <proto.h>
#define PROTO_CONNECTED		0x01
#define PROTO_STATIC		0x02
#define PROTO_RIP		0x04
#define PROTO_BGP		0x08
*/

/*
 * "State" of routing table entry.
 */
#define	RTS_ACTIVE		0x0100		/* Route is active */
#define RTS_INTERIOR    	0x08		/* an interior route */
#define RTS_EXTERIOR    	0x10		/* an exterior route */
#define	RTS_HOLDDOWN		0x20	/* Route is held down */


#define	RTS_DELETE		0x40	/* Route is deleted */
#define	RTS_FREE		0x80	/* Route memory is scheduled for free */

#define NO_PREF			9999999

struct _route_head_t;
typedef struct _route_node_t {
   struct _route_head_t *route_head;	/* pointer back to our route_head */
   int state;				/* mask of state flags */
   int pref;			/* ripe181 - as_in preference */
   int pref2;			/* internal tie-breaking pref */
   int protocol_mask;		/* bit mask of protocols using this route */
   generic_attr_t *attr;
   long time;			/* time last updated (as in RIP) */
} route_node_t;


typedef struct _route_head_t {
   long change_flag;
   radix_node_t *radix_node;	/* pointer back to our radix node */
   route_node_t *active;	/* a pointer to best, or active route_node */
   route_node_t *last_active;	/* a pointer to best, or active route_node */
   LINKED_LIST *ll_route_nodes;
} route_head_t;


/*
 * Change is routing table entry
 */
#define	RTCF_NEXTHOP	0x01		/* Next hop change */
#define	RTCF_METRIC	0x02		/* Metric change */
#define	RTCF_METRIC2	0x04		/* Metric change */
#define	RTCF_ASPATH	0x08		/* AS path change */
#define	RTCF_TAG	0x10		/* Tag change */


typedef struct _route_manager_t {
   int lock;	    	/* table is LOCKED -- do not modify while set */
   pthread_mutex_t	mutex_lock;

   int num_active_routes;
   radix_tree_t *radix;
   trace_t	*trace;
   /*LINKED_LIST *ll_route_nodes;*/ /* delete this ?*/

   LINKED_LIST *ll_changed_route_nodes;
   void *user;		/* hook for program or user specific data */
   
} route_manager_t;

/* types returned by ret in rm_insert on addition to radix tree */
enum RM_RETURN_TYPES {
   RM_ROUTE_ALREADY_EXISTS,
   RM_ROUTE_LOWER_PREF,
   RM_ROUTE_BEST_PREF,
   RM_ROUTE_SAME_PREF,
   RM_NO_ACTIVE_ROUTE
};

/* structure used in rm_radix_node_iter -- saves place as
 * calling routine iterates through radix tree
 */
typedef struct 	_radix_tree_iter_t {
   STACK *stack;
   radix_node_t *rnode_current;
} radix_tree_iter_t;



route_node_t *New_Route_Node (route_head_t *route_head,
			      int pref, generic_attr_t *p_attr);
route_head_t *New_Route_Head (radix_node_t *radix_node);
route_manager_t *New_Route_Manager (int maxbitlen);
int rm_delete_route_node (route_manager_t *rm, route_node_t *route_node);

int rm_close (route_manager_t *route_manager);
int rm_open (route_manager_t *route_manager);
route_head_t *rm_iter_reentrant (route_manager_t *rm,
				 radix_tree_iter_t **rtree_iter);

#endif /* _ROUTE_MANAGER_H */
