/*
 * $Id: patricia.h,v 1.2 1996/12/23 14:36:29 masaki Exp $
 */

#ifndef _PATRICIA_H
#define _PATRICIA_H



#define MAX_BIT 31

#define DISPLAY 0
#define INSTALL 1
#define DELETE  2
#define DUMP    3

typedef unsigned int BIT_SELECT;
typedef unsigned long KEY_TYPE;

typedef struct pt *patricia_t;
struct pt {
  BIT_SELECT bit;
  KEY_TYPE   key;
  KEY_TYPE   mask;
  unsigned   pref_len;
  KEY_TYPE   common;
  int        pos;
  patricia_t l;
  patricia_t r;
  void*	     data;	
}; 


typedef patricia_t NODE_TYPE;

typedef struct s_entry *pstack_t; 
struct s_entry 
    {
     NODE_TYPE node;
     pstack_t prev;
     pstack_t next;
    };


patricia_t patricia_new(KEY_TYPE key, unsigned len, BIT_SELECT bit);
void patricia_insert(KEY_TYPE key, unsigned len, patricia_t *root);
void patricia_walk(patricia_t pt, int function, patricia_t *np);
void patricia_walk2(patricia_t pt, int function, patricia_t *np);
void patricia_reload(patricia_t *root);
patricia_t patricia_find(KEY_TYPE key, patricia_t root);
patricia_t patricia_find2(KEY_TYPE key, unsigned len, patricia_t root);
void patricia_insert(KEY_TYPE key, unsigned len, patricia_t *root);
patricia_t patricia_insert2(KEY_TYPE key, unsigned len, patricia_t *root);
patricia_t patricia_parent(patricia_t pt, patricia_t root);
patricia_t find_up(patricia_t tr, BIT_SELECT bit);
void patricia_delete(KEY_TYPE key, patricia_t *root);

#endif /* _PATRICIA_H */
