/*
 * $Id: uping.h,v 1.3 1997/04/03 15:44:46 labovit Exp $
 */

#ifndef _UPING_H
#define _UPING_H

#include <mrt.h>


#define PORT 5670

#define UPING_ETHERNET		0
#define UPING_NONE		1
#define UPING_FDDI		2
#define UPING_UDP		3	/* allow kernel to perform routing */

#define byte u_char

#define	ABS(x)		((x) < 0 ? -(x) : (x))
#define	BITSPERBYTE	(8)


#define UTIL_PUT_BYTE(val, cp)   (*(cp)++ = (byte)(val))

#define UTIL_PUT_SHORT(val, cp) \
        do { \
                register u_short Xv; \
                Xv = (u_short)(val); \
                *(cp)++ = (byte)(Xv >> 8); \
                *(cp)++ = (byte)Xv; \
        } while (0)

#define UTIL_PUT_LONG(val, cp) \
        do { \
                register u_long Xv; \
                Xv = (u_long)(val); \
                *(cp)++ = (byte)(Xv >> 24); \
                *(cp)++ = (byte)(Xv >> 16); \
                *(cp)++ = (byte)(Xv >>  8); \
                *(cp)++ = (byte)Xv; \
        } while (0)

#define UTIL_GET_BYTE(val, cp)   ((val) = *(cp)++)

#define UTIL_GET_SHORT(val, cp) \
        do { \
                register unsigned int Xv; \
                Xv = (*(cp)++) << 8; \
                Xv |= *(cp)++; \
                (val) = Xv; \
        } while (0)

#define UTIL_GET_LONG(val, cp) \
        do { \
                register u_long Xv; \
                Xv = (*(cp)++) << 24; \
                Xv |= (*(cp)++) << 16; \
                Xv |= (*(cp)++) << 8; \
                Xv |= *(cp)++; \
                (val) = Xv; \
        } while (0)

#define UTIL_GET_NETLONG(val, cp) \
        do { \
                register u_char *Xvp; \
                u_long Xv; \
                Xvp = (u_char *) &Xv; \
                *Xvp++ = *(cp)++; \
                *Xvp++ = *(cp)++; \
                *Xvp++ = *(cp)++; \
                *Xvp++ = *(cp)++; \
                (val) = Xv; \
        } while (0)

typedef struct _uping_peer_t {
  int		sockfd;
  int		state;	/* 1 = coonected */
  prefix_t	*prefix;
} uping_peer_t;


typedef struct _uping_dst_t {
  u_char		type;		/* 0 = local, 1 = remote */
  int			interface;	/* 0 = udp stack, 1 = dlpi ethernet */
  prefix_t		*dst;		/* ip address of destination host */
  uping_peer_t		*peer;		/* if remote, a ptr to our peer host */
  pthread_mutex_t	mutex_lock;
#ifdef HAVE_SYS_DLPI_H 
  struct ether_addr	ether_addr;	/* mac address of the next hop */
#endif
  u_short		AS;		/* AS of network we are testing */
  LINKED_LIST		*ll_sent;
  /* STATISTICS */
  u_long		duplicate;
  u_long		delay;
  u_long		sent;
  u_long		recv;
} uping_dst_t;

typedef struct _ping_t {
  u_long	sent_sec;
  u_short	sent_msec;
  u_long	delay;
} ping_t;






typedef struct _ping_thread_t {
  trace_t	*trace;
  schedule_t	*schedule;
  int		sockfd; /* incomming UDP packets */
  int		udp_fd;
  int		fd;
  LINKED_LIST	*ll_uping_dst;
#ifdef HAVE_SYS_DLPI_H
  struct ether_addr ether_addr;		/* our local interface's MAC address */
#endif /* HAVE_SYS_DLPI_H */
} ping_thread_t;


typedef struct _peer_thread_t {
  trace_t	*trace;
  schedule_t	*schedule;
  LINKED_LIST	*ll_peer;
} peer_thread_t;


typedef struct _ping_stats_t { 
  u_char	type;		/* 0 = local (same subnet), 1 = remote */
  u_long	sec;		/* time send sec */
  u_short	msec;
  u_long	rsec;		/* time received  sec */
  u_short	rmsec;
  u_short	AS;
  u_long	src;
  u_long	dst;
} ping_stats_t;

void update_stats();
int update_peer (ping_stats_t *stats);
void uping_peer_recv ();
int uping_accept_peer_connection ();
void uping_timer ();
void calculate_statistics ();
int ping_show_stats (uii_connection_t *uii);
void peer_thread_retry();
u_short chksum(ushort *buf,int len);
void check_passwd ();
int send_udp_mac ();  /* send UDP packet through dlpi or bgp MAC interface */
int send_udp_app ();  /* send UDP packet from application level */
int init_publish ();
int publish ();
int show_peers ();
void mrt_process_signal ();
int init_peer_thread (trace_t *default_trace);
int start_peer_thread ();
int start_ping_thread ();
int init_ping_thread (trace_t *default_trace);
int schedule_ping_add_dst (uping_dst_t *dst);
void schedule_uping_timer ();
void schedule_calculate_statistics();
void schedule_uping_recv ();
void schedule_peer_retry ();
void schedule_show_stats ();
void uping_recv ();
int peer_connection_completed ();

/* globally visible */
extern ping_thread_t	*PING_THREAD;
extern peer_thread_t	*PEER_THREAD; /* service sending and recv updates from peers */

#endif /* _UPING_H */
