#!/usr/local/bin/perl5
#
# $Id: salamander.pl,v 1.3 1997/04/03 15:44:42 labovit Exp $
#

#
# Quick hack to mimick salamanderInterface.c code
# <labovit@merit.edu> March 17, 1997
#
#   Last Changed: 3/30/97 chl

use Socket;
use Sys::Hostname;

$SALAMANDER_QUERY_TCP_PORT	= 1; 
$SALAMANDER_UDP_PORT		= 8087; 
$SALAMANDER_OK			= 0;

$COMMAND_PROPERTY		= "COMMAND";
$NAME_PROPERTY			= "NAME";

$sockaddr = 'S n a4 x8'; 

#&connectToSalamanderServer ("198.108.60.133", 1234567); 
#&salamanderSendServerData("NAME", "netnow", "COMMAND", "QUERY");

#while (1) {
#    ($dataptr, $datalength) = &salamanderReadServerData;
#}


sub salamanderReadServerData {

     select(SOCK); $| = 1; select(stdout);


    $rin = $win = $ein = '';
    vec ($rin, fileno (SOCK) , 1) = 1;

    select ($rout=$rin, undef, undef, undef);

    $buf = "";
    $n = sysread (SOCK, $buf, 4);

    if ($n <= 0) {
	print "Read failed $n $! !$\n";
	exit;
    }
    ($_key1) = unpack ("N", $buf);
    $n = sysread (SOCK, $buf, 4);
    ($_key2) = unpack ("N", $buf);

    #print "$_key1:$_key2\n";

     @PROP = ();
     # get properties
     while (1) {
	 $key = &readstring;
	 if ($key eq "") {last;}
	 $value = &readstring;
	 
	 if ($key eq "OBJ_SIZE") {
	     $len = $value + 0;
	 }

	 push (PROP, "$key:$value");
	 #print "$key: $value  \n";
     }

     # get data
     sysread (SOCK, $buf, $len);
     #print "$buf\n";
     return ($buf, $len, @PROP);
}


sub readstring {
    $s = "";

    while (1) {
	$c = "";
	sysread (SOCK, $c, 1);
	if ($c eq "\0") {return ($s);}
	$s .= $c;
     }
}

sub salamanderSendServerData {
    local (@plist) = @_;

    #print "Sending Keys: $key1:$key2\n";
    $buf = pack ("N", $key1);
    syswrite (SOCK, $buf, 4);
    $buf = pack ("N", $key2);
    syswrite (SOCK, $buf, 4);

    while (defined ($key = shift (@plist))) {
	$value = shift (@plist);
	
	if ($key eq "") {break;}

	#print "$key: $value\n";
	
	$n = length ($key);
	$key .="\0";
	syswrite (SOCK, $key, $n+1);

	$n = length ($value);
	$value .= "\0";
	syswrite (SOCK, $value, $n+1);
    }

    syswrite (SOCK, "\0", 1);
}

sub connectToSalamanderServer { 
    ($server, $key) = @_; 

    ($ret, $port) = &getSalamanderPort ($server);

    &createTCPConnection($server, $port);
    &write_sskey (123456);
}


sub write_sskey {
    local ($key) = @_;
    my $buf;

    $buf = pack ("N", $key);
    syswrite (SOCK, $buf, 4);
}

sub createTCPConnection {
    local ($server, $port) = @_;
    my $iaddr;
    my $paddr;
    my $proto;

    $iaddr = inet_aton ($server) or die "no host: $server";
    $paddr = sockaddr_in ($port, $iaddr);
    $proto = getprotobyname ('tcp');
    socket (SOCK, PF_INET, SOCK_STREAM, $prpto);
    connect (SOCK, $paddr) or die "connect failed: $!\n";
    


}

sub getSalamanderPort { 
    local ($host_ip) = @_;
    my $iaddr;
    my $paddr;
    my $srvaddr;
    my $psrvaddr;

    $iaddr = gethostbyname (hostname());
    $proto = getprotobyname ('udp');
    $paddr = sockaddr_in (0, $iaddr);
    socket (FD, PF_INET, SOCK_DGRAM, $proto) or die "socket $!";
    bind (FD, $paddr) or die "bind: $!";


    $srvaddr = inet_aton ($host_ip) or die "unknown host\n";
    $psrvaddr = sockaddr_in ($SALAMANDER_UDP_PORT, $srvaddr);


    $buf = pack ("N", $SALAMANDER_QUERY_TCP_PORT);
    send (FD, $buf, 0, $psrvaddr);

    recv (FD, $answer, 12, 0);
    ($port, $junk, $key1, $key2) = unpack ("SSNN", $answer);
    #print "RECEIVED: port:$port key1:$key1 key2:$key2\n";
    return (1, $port);
}
