/*
 * $Id: peer.c,v 1.2 1997/04/03 15:44:39 labovit Exp $
 */

#include <sys/types.h>
#include <sys/stropts.h>
#include <mrt.h>
#ifdef HAVE_SYS_DLPI_H
#include <sys/ethernet.h>
#endif /* HAVE_SYS_DLPI_H */
#include <stdio.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/types.h> 
#include <sys/timeb.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <netinet/in.h>
#include <netinet/in_systm.h>
#include <netinet/ip.h>
#include <time.h>
#include <timer.h>
#include "uping.h"
#include "config.h"

extern config_master_t *CONFIG;
extern mtimer_t	*retry_timer;		/* retry down connections (peer and salamander) */

void  schedule_peer_connection (uping_peer_t *peer) {
 schedule_event (PEER_THREAD->schedule, (void *) peer_connection_completed, 1, peer);
}


void  schedule_update_peer (ping_stats_t *stats) {
 schedule_event (PEER_THREAD->schedule, (void *) update_peer, 1, stats);
}

void  schedule_accept_connection () {
  printf ("Schedule accept!!\n");
 schedule_event (PEER_THREAD->schedule, (void *) uping_accept_peer_connection, 0, NULL);
}

void schedule_peer_retry () {
  schedule_event (PEER_THREAD->schedule, (void *) peer_thread_retry, 0, NULL);
}

void schedule_peer_recv (uping_peer_t *uping_peer) {
  schedule_event (PEER_THREAD->schedule, (void *) uping_peer_recv, 1, uping_peer);
}




void uping_peer_recv (uping_peer_t *uping_peer) {
  u_char tmp[512], *cp;
  ping_stats_t *stats;

  cp = tmp;
  stats = New (ping_stats_t);

  if (read (uping_peer->sockfd, tmp, 22) != 22) {
    trace (NORM|TRACE|TR_PACKET, PEER_THREAD->trace, 
	   "Received 0 bytes on socket %d -- closing %s\n", uping_peer->sockfd,
	   prefix_toa (uping_peer->prefix));
    uping_close_peer (uping_peer);
    return;
  }

  UTIL_GET_NETLONG (stats->sec, cp); /* time */
  UTIL_GET_SHORT (stats->msec, cp);  /* sequence number */
  UTIL_GET_SHORT (stats->AS, cp);      
  UTIL_GET_LONG (stats->src, cp);
  UTIL_GET_LONG (stats->dst, cp);
  UTIL_GET_LONG (stats->rsec, cp);
  UTIL_GET_SHORT (stats->rmsec, cp);

  trace (TRACE|TR_PACKET, PEER_THREAD->trace, "Received echo AS%d (%d - %d) (%d - %d)\n", 
	 stats->AS, stats->sec, stats->rsec, stats->msec, stats->rmsec);
  schedule_update_stats (stats);
  select_enable_fd (uping_peer->sockfd);
}


/* let peer know that we received their probe packet */
int update_peer (ping_stats_t *stats) {  
  uping_peer_t *uping_peer;
  char tmp[512], *cp;

  LL_Iterate (PEER_THREAD->ll_peer, uping_peer) {
    if (!memcmp (prefix_tochar (uping_peer->prefix), &(stats->src), 4)) {
      trace (TRACE|TR_PACKET, PING_THREAD->trace, "Recv UDP packet %s\n",
	     prefix_toa (uping_peer->prefix));
      cp = tmp;
      UTIL_PUT_LONG (htonl (stats->sec), cp);   /* time */
      UTIL_PUT_SHORT (htons (stats->msec), cp);   /* sequence num */
      UTIL_PUT_SHORT (htons (stats->AS), cp);   /* AS */
      UTIL_PUT_LONG (htonl (stats->src), cp);   /* src ip */
      UTIL_PUT_LONG (htonl (prefix_tolong (CONFIG->source_ip)), cp);   /* dst ip */
      UTIL_PUT_LONG (htonl (stats->rsec), cp);   /* recv time */
      UTIL_PUT_SHORT (htons (stats->rmsec), cp);   /* recv time */

      if (uping_peer->state == 1) {
	trace (TRACE|TR_PACKET, CONFIG->trace, "Sending ECHO to peer %s\n", 
	       prefix_toa(uping_peer->prefix));
	if (write (uping_peer->sockfd, tmp, cp - tmp) < (cp - tmp)) {
	  /* write failed */
	  trace (NORM|TRACE|TR_PACKET, CONFIG->trace, 
		 "ECHO failed to peer %s **** CLOSING ****\n", 
		 prefix_toa(uping_peer->prefix));
	  uping_close_peer (uping_peer);
	}
      }

      Delete (stats);
      return;
    }
  }

  trace (TRACE|TR_PACKET, PING_THREAD->trace, 
	 "Recv UDP packet from non-peer. Discarding...\n");
  Delete (stats);

}


int uping_close_peer (uping_peer_t *uping_peer) {
  select_delete_fd (uping_peer->sockfd);
  uping_peer->state = 0;
  trace (NORM, CONFIG->trace, "Closing PEER %s\n", 
	 prefix_toa (uping_peer->prefix));
  return (1);
}


int uping_add_peer (prefix_t *prefix, int fd) {
  uping_peer_t *uping_peer;
  struct  sockaddr_in     serv_addr;

  LL_Iterate (PEER_THREAD->ll_peer, uping_peer) {
    if (prefix_compare (uping_peer->prefix, prefix)) return (1);
  }

  trace (NORM, CONFIG->trace, "CREATING PEER %s\n", 
	 prefix_toa (prefix));

  /* doesn't exist -- create a new peer and attempt a TCP connection */
  uping_peer = New (uping_peer_t);
  uping_peer->prefix = copy_prefix (prefix);

  LL_Add (PEER_THREAD->ll_peer, uping_peer);

  if (fd == 0) {
    uping_peer_connect (uping_peer);
  }
  else {
    select_delete_fd (uping_peer->sockfd); /* just in case */
    uping_peer->sockfd = fd;
    uping_peer->state = 1;
    select_add_fd (uping_peer->sockfd, 1, (void *) schedule_peer_recv, uping_peer);
    trace (NORM, CONFIG->trace, "UPING_PEER %s connection made (%d)\n", 
	   prefix_toa (uping_peer->prefix), fd);
    select_enable_fd (uping_peer->sockfd);
  }

done:
  return 1;
}


int uping_peer_connect (uping_peer_t *uping_peer) {
  struct  sockaddr_in     serv_addr;

  bzero((char *)&serv_addr, sizeof(struct sockaddr_in));
  serv_addr.sin_addr.s_addr = prefix_tolong (uping_peer->prefix);
  serv_addr.sin_family = AF_INET;
  serv_addr.sin_port = htons(8888);

  if (uping_peer->sockfd > 0) 
    select_delete_fd (uping_peer->sockfd);

  uping_peer->sockfd = socket (AF_INET, SOCK_STREAM, 0);

  /* fcntl (uping_peer->sockfd, F_SETFL, O_NDELAY);*/

  trace (NORM, CONFIG->trace, "Attempting peer connection to %s\n", 
	 prefix_toa (uping_peer->prefix));

  uping_peer->state = 2; /* pending connection */

  if (connect(uping_peer->sockfd, (struct sockaddr *)&serv_addr, 
	      sizeof(struct sockaddr_in)) < 0) {
    /*if (errno != EINPROGRESS) {*/
      trace (NORM, CONFIG->trace, "UPING_PEER %s connection failed\n", 
	     prefix_toa (uping_peer->prefix));
      uping_close_peer (uping_peer);
      return (-1);
      /*}*/
  }
  
  /*  select_add_fd (uping_peer->sockfd, 2, (void *) schedule_peer_connection, 
		 uping_peer);*/
  
  uping_peer->state = 1;
  trace (NORM, CONFIG->trace, 
	 "UPING_PEER connection to %s completed (%d)\n", 
	 prefix_toa (uping_peer->prefix), uping_peer->sockfd);
  select_add_fd (uping_peer->sockfd, 1, (void *) schedule_peer_recv, uping_peer);
  return (1);
}


/* peer_connection_completed
 * the connection is ready for writing/reading
 */
int peer_connection_completed (uping_peer_t *peer) {
  char tmp[10];

  /* if peer is already connected, then we are all set */
  if (peer->state != 2) {
    trace (NORM, CONFIG->trace, 
	   "** Strange, connection is not in connect from %s (%d) [state =%d]\n",
	   prefix_toa (peer->prefix), peer->state);
    return (0);
  }

  select_delete_fd (peer->sockfd);
  peer->state = 1;

  select_add_fd (peer->sockfd, 1, (void *) schedule_peer_recv, peer);
  read (peer->sockfd, tmp, 1);

  trace (NORM, CONFIG->trace, 
	 "UPING_PEER connection to %s completed! (%d)\n", 
	 prefix_toa (peer->prefix), peer->sockfd);

  return (1);
}


int uping_accept_peer_connection () {
  int sockfd;
  int len; 
  uping_peer_t *uping_peer;
  struct sockaddr_in addr;
  len = sizeof (addr);

  trace (NORM, CONFIG->trace, "Received connection request...\n");

  if ((sockfd = accept (CONFIG->sockfd, (struct sockaddr *) &addr, &len)) < 0) {
      trace (NORM, CONFIG->trace, "UPING peer accept succeeded\n");
      return (-1);
  }

  select_enable_fd (CONFIG->sockfd);

  /* scan through peers */
  LL_Iterate (PEER_THREAD->ll_peer, uping_peer) {
    if (!memcmp (prefix_tochar (uping_peer->prefix), &addr.sin_addr, 4)) {
      if (uping_peer->state != 0) {
	trace (NORM, CONFIG->trace,
	       "** Peer already connected (state %d) %s\n", 
	       uping_peer->state, 
	       inet_ntoa (addr.sin_addr));
      }
      trace (NORM, CONFIG->trace,
	     "UPING Peer Valid connection from %s\n", inet_ntoa (addr.sin_addr));
      select_delete_fd (uping_peer->sockfd); /* just in case */
      uping_peer->sockfd = sockfd;
      uping_peer->state = 1;
      select_add_fd (sockfd, 1, (void *) schedule_peer_recv, uping_peer);
      select_enable_fd (sockfd);
      return (1);
    }
  }
  
  if (CONFIG->unconfig_peer == 1) {
    trace (NORM, CONFIG->trace, "UPING Peer %s unconfigured -- ALLOWED\n",
	   inet_ntoa (addr.sin_addr));
    uping_add_peer (New_Prefix (AF_INET, (char *) &addr.sin_addr, 32), sockfd);
    return (1);
  }


  /* otherwise ... */
  trace (NORM, CONFIG->trace, "UPING Peer ERROR -- Unconfigured peer. Refusing. %s\n",
	 inet_ntoa (addr.sin_addr));
  uping_close_peer (uping_peer);
  return (-1);
}



int init_uping_peer_listen () {
   struct sockaddr_in serv_addr;
   int optval = 1;

   /* check that NOT listening to portmaster! */
   serv_addr.sin_port = htons (8888);
   serv_addr.sin_family = AF_INET;
   serv_addr.sin_addr.s_addr = INADDR_ANY;

   if ( (CONFIG->sockfd = socket (AF_INET, SOCK_STREAM, 0)) < 0) {
      trace (NORM, CONFIG->trace, "ERROR -- Could not get socket (%s)\n",
	     strerror (errno));
      return (-1);
   }

   /* allow the reuse this port */
   if (setsockopt (CONFIG->sockfd, SOL_SOCKET, SO_REUSEADDR, 
		   (char *) &optval, sizeof (optval)) < 0) 
     trace (NORM, CONFIG->trace, "ERROR -- UPING Peer setsockopt failed (%s)\n",
	    strerror (errno));

   if (bind (CONFIG->sockfd, 
	     (struct sockaddr *) &serv_addr, sizeof (serv_addr)) < 0) {
      trace (NORM, CONFIG->trace, "UPING Peer ERROR -- Could not bind to port %d (%s)\n",
	     8888, strerror (errno));
      return (-1);
   }
   
   listen (CONFIG->sockfd, 5);

   trace (NORM, CONFIG->trace, "listening for peer connections on port %d\n", 
	  8888);

   select_add_fd (CONFIG->sockfd, 1, (void *) schedule_accept_connection, NULL);
   /*select_enable_fd (CONFIG->sockfd);*/


   return (1);
}



int show_peers (uii_connection_t *uii) {
  uping_peer_t *uping_peer;

  uii_send_data (uii, "Rectry timer: %d seconds\r\n", time_left (retry_timer));

  LL_Iterate (PEER_THREAD->ll_peer,  uping_peer) {
    uii_send_data (uii, "peer %s (socket %d) state:%d\r\n", 
		   prefix_toa (uping_peer->prefix), uping_peer->sockfd,
		   uping_peer->state);
  }
}




/* peer_thread_retry
 * retry TCP connections to remote peers so we can echo back UDP receipit
 * information
 */
void peer_thread_retry () {
  uping_peer_t *uping_peer;

  LL_Iterate (PEER_THREAD->ll_peer, uping_peer) {
    if (uping_peer->state == 0) {
      trace (NORM, CONFIG->trace, "Retrying connection to %s\n", 
	     prefix_toa (uping_peer->prefix));
      uping_peer_connect (uping_peer);
    }
  }
}


int peer_thread () {
#ifdef HAVE_LIBPTHREAD
  while (1) 
      schedule_wait_for_event (PEER_THREAD->schedule);
   exit (0);
#else
   return (0);
#endif /* HAVE_LIBPTHREAD */
}


int init_peer_thread (trace_t *default_trace) {
  PEER_THREAD = New (peer_thread_t);
  PEER_THREAD->schedule = (schedule_t *) New_Schedule ("Peer thread", default_trace);
  PEER_THREAD->ll_peer = LL_Create (NULL);
  PEER_THREAD->trace = default_trace;
}


int start_peer_thread () {
  mrt_thread_create ("Peer Thread", PEER_THREAD->schedule, 
		     (void *)  peer_thread, PEER_THREAD->trace);
}
