/*
 * $Id: config.h,v 1.2 1997/04/03 15:44:35 labovit Exp $
 */

#ifndef _CONFIG_H
#define _CONFIG_H

#include <mrt.h>
#include <interface.h>

typedef struct _config_master_t {
  int		line;		/* when parsing file, current lineno */
  interface_t   *interface;     /* umm, not interface number ... */
  interface_t   *tunnel_source; /* to memorize when parsing */
  /* I'm not sure the following are used */
  int		sockfd;		/* socket if being configured by user */
  int		state;          /* router, interface, etc */
  int		instance;	/* protocol, or interface number */
  int		negate;		/* command prefeced by a "no" */
  char          *password;      /* non-encrypted password */
  trace_t	*trace;
  LINKED_LIST   *ll_static_dest;
  LINKED_LIST   *ll_static_attr;
  prefix_t	*source_ip;
  int		packet_size;	/* how many bytes to send out */
  char		log_dir[100];	/* where to log info */
  char		device[64];	/* name of the interface to use */
  char		name[100];	/* some descripive name for this host */
  u_int		interval;
  u_int		jitter;
  u_int		interface_type;	/* 0 = ethernet, 1 = fddi */
  u_int		sequence;
  prefix_t	*publish_prefix;/* salamander webcasting */
  u_long	key;		/* salamander webcasting */
  int unconfig_peer;		/* flag: 1 == allow unconfigured peers */
  /* int		sockfd;		socket listening on uping peer connections */

} config_master_t;

typedef struct _config_command_t {
  char *name;
  int (*call_fn)();
  char *format;
  char *description;
} config_command_t;

#endif /* _CONFIG_H */
