#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <malloc.h>
#include <signal.h>
#include <New.h>
#include <io.h>

#define MYTYPE		MSG_PROTOCOL_BGP
#define MYSUBTYPE	MSG_BGP_NULL

#define IO_READ		1
#define IO_WRITE	2

void print_clear_msg(mrt_msg_t *msg);
void cleanup(int arg);

int io_mode;
io_t *IO;

int
main(int argc, char **argv)
{
   char buf[MAX_MSG_SIZE];
   int arg;
   int errs = 0;
   char *id = NULL;
   long tstamp;
   int type;
   int subtype;
   mrt_msg_t *msg;
   char *p;
   extern char *optarg;


   while((arg = getopt(argc, argv, "rwi:")) != EOF) {
      switch(arg) {
      case 'r':
	 io_mode = IO_READ;
	 printf("Mode set to READ\n");
	 break;
      case 'w':
	 io_mode = IO_WRITE;
	 printf("Mode set to WRITE\n");
	 break;
      case 'i':
	 id = optarg;
	 printf("Client ID is \"%s\"\n", id);
	 break;
      case '?':
	 errs++;
	 break;
      }
   }

   if(errs || io_mode == 0 || id == NULL) {
      fprintf(stderr, "usage: testio [-r|-w] -i client-id\n");
      exit(1);
   }

   IO = (io_t *) New_IO ();

   if(io_mode == IO_READ) {
      if(io_set(IO, IO_INMSGQ, id, NULL) < 0) {
	 perror("set_io");
	 exit(1);
      }
   } else if(io_mode == IO_WRITE) {
      if(io_set(IO, IO_OUTMSGQ, id, NULL) < 0) {
	 perror("set_io");
	 exit(1);
      }
   } else {
      printf("bad I/O mode: %d\n", io_mode);
      exit(1);
   }

   signal(SIGHUP, cleanup);
   signal(SIGINT, cleanup);
   signal(SIGTERM, cleanup);

   if(io_mode == IO_READ) {
      printf("reader: waiting for input\n");
      while(msg = io_read(IO)) {
	 print_clear_msg(msg);
	 Delete(msg);
	 printf("reader: waiting for input\n");
      }
   } else if(io_mode == IO_WRITE) {
      while(1) {
	 printf("type: ");
	 fgets(buf, MAX_MSG_SIZE, stdin);
	 type = atoi(buf);
      
	 printf("subtype: ");
	 fgets(buf, MAX_MSG_SIZE, stdin);
	 subtype = atoi(buf);
      
	 printf("value: ");
	 fgets(buf, MAX_MSG_SIZE, stdin);
	 if((p = strchr(buf, '\n')) != NULL)
	    *p = '\0';

	 printf("calling io_write\n");
	 if(io_write(IO, 0L, type, subtype, strlen(buf), buf) < 0)
	    perror("io_write");
      }
   }

   exit(0);
}


void
print_clear_msg(mrt_msg_t *msg)
{
   char *timestr;
   time_t t;

   timestr = ctime(&(msg->tstamp));
   timestr[24] = '\0';
   msg->value[msg->length] = '\0';

   printf("priority=%d, tstamp=%s, type=%d, subtype=%d, str=\"%s\"\n",
	  msg->priority, timestr, msg->type, msg->subtype, msg->value);
}


void
cleanup(int arg)
{
   printf("cleanup called\n");
   if(io_mode == IO_READ) {
      printf("cleanup: setting I/O mode IO_INNONE\n");
      io_set(IO, IO_INNONE, NULL, NULL);
   } else if(io_mode == IO_WRITE) {
      printf("cleanup: setting I/O mode IO_OUTNONE\n");
      io_set(IO, IO_OUTNONE, NULL, NULL);
   }

   exit(0);
}
