#!/usr/local/bin/perl5
#
# $Id: bgp_check.pl,v 1.1 1997/03/31 01:16:47 labovit Exp $
#
# Name: cisco_check
# Author: Craig Labovitz (Merit Network, Inc.)
# Description: 
#	Process "show ip bgp" output from cisco.
# Algorithm:
#	For every cisco prefix/aspath, grab the last AS before the IGP ('i')
#	marker. Query the RADB server for all prefixes originating from the AS,
#	and cache the results. If the prefix is not in list of prefixes, query
#	the RADB for the origin listed in the route_object for the prefix.
#	
#	The script also checks each prefix for violation of RFC1597.
#
# Changes:
# 8/27/95 get aspath from column 60 (ack jhawk@mit.edu)
# 8/27/95 now works with Perl4 as well
# 8/28/95 fixed more bugs
# 8/29/95 fixed problem with looking at bad entry lines
# 8/30/94 worked-around radb server silliness in message buffering


require "IRR_util.pl";

$SERVER = "snoopy.merit.edu";
$PORT = 5006;
$SOCKADDR_IN = "S n a4 x8";
$debug = 0;


# origin cache stuff
$SIZE = 100;
$CURRENT = 0;

if (($#ARGV != 0) && ($#ARGV != 1)) {
    print "\nUsage: cisco_check datafile [default_as]\n";
    exit;
}

$DEFAULT_AS = $ARGV[1];
$SIG{'PIPE'} = 'handler';

open (FILE, $ARGV[0]) || die "\nCould not open $ARGV[0]";
&open_IRR_connection ($SERVER);

main:
while (<FILE>) {
    chop;
    if ($_ =~ /^.{3,3}([\d+\.\/]{6,37}).*/) {
	$prefix = $1;
	if (!($prefix =~ /([\d\.]+)\//)) {
	    $prefix = "$prefix/32";
	}
	    

	# aspath starts at column 60
	$aspath = substr ($_, 59);

	if ($aspath =~ /(\d+)\s+i/) {
	    $origin = $1;
	}
	else {next;}

	#print "[$origin] $aspath\n";
	
	# Test RFC1597
	$bogus = 0;
	@quads = split (/\./, $prefix);
	#print "$quads[0]\n";
	if (($quads[0] == 10) ||
	    (($quads[0] == 172) && ($quads[1] >= 16) &&
	     ($quads[1] <= 31)) ||
	    (($quads[0] == 192) && ($quads[1] == 168))) {
	    print "1597 VIOLATION $prefix $aspath\n";
	    next;
	}
    
	&check_prefix ($prefix, $origin, $aspath);
    }
    
    print S "quit\n";
}


sub check_prefix {
    local ($prefix, $origin, $aspath) = @_;

    #print "CHECKING $prefix $origin\n";

    $result = &IRR_command("!r$prefix,o");

    if ($result ne "") {
	@as = split (/[\s\n]+/, $data);
    
	foreach $as (@as) {
	    if ($as eq "AS$origin") {
		return;
	    }
	}

	printf "$prefix \t[@as] $aspath\n"; 
	return;
    }

    # look for less specific
    $data = &IRR_command("!r$prefix,l");
    @data = split (/[\n]+/, $data);
    @list = ();
    foreach $d (@data) {
	if ($d =~ /^\*or\:\s+(AS\d+)/i) {
	    if (! (&present ($1, @list))) { push (@list, "$1");}
	}
	elsif ($d =~ /^\origin\:\s+(AS\d+)/i) {
	    if (! (&present ($1, @list))) { push (@list, "$1");}
	}
    }


    foreach $l (@list) {
	if ($l eq "AS$origin") {
	    #rint " MATCH [@list]\n";
	    return;
	}
    }


    printf "$prefix \t[@list] $aspath\n"; 
    return;
}



sub present {
    local ($a, @liste);
    local ($l);

    foreach $l (@liste) {
	if ($l == $a) {return (1);}
    }

    return (0);
}
