/*
 * $Id: packet.c,v 1.4 1996/12/23 14:37:32 masaki Exp $
 */

#include <mrt.h>
#include <stdarg.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/time.h>
#include <sys/stat.h>
#include <netinet/in.h>
#include <netinet/tcp.h>
#include <netdb.h>
#include <stdlib.h>
#include <arpa/inet.h>
#include <stdio.h>
#include <netdb.h>
#include <signal.h>
#include <fcntl.h>
#include <errno.h>
#include <trace.h>
#include <rip.h>


rip_attr_t *New_Rip_Attr (int metric) {
   rip_attr_t *tmp;

   tmp = New (rip_attr_t);

   tmp->type = PROTO_RIP;
   
   tmp->metric = metric;

   return (tmp);
}



void Delete_Rip_Attr (rip_attr_t *tmp) {
   Delete (tmp);
}


int rip_process_packet (gateway_t *gateway, char *update, int bytes,
			LINKED_LIST **ll_prefixes, LINKED_LIST **ll_attr) {
   char *cp;
   prefix_t *prefix;
   u_char command, version;
   rip_attr_t *p_attr;

   *ll_prefixes = (LINKED_LIST *) LL_Create (0);
   *ll_attr = (LINKED_LIST *) LL_Create (0);


   cp = update;

   UTIL_GET_BYTE (command, cp);
   UTIL_GET_BYTE (version, cp);

   cp+=2; /* unused */

   while (cp < update + bytes) {
     u_short	tag;
     u_long	addr, mask, next_hop, metric;

     if (version == 1) {	/* version 1 */
       cp+=4;
     } else {			/* version 2 */
       cp +=2;
       UTIL_GET_SHORT (tag, cp);
       tag = htons (tag); /* should be ntohs ? -- masaki */
     }

     UTIL_GET_NETLONG (addr, cp);
     /* version 1 */
     if (version == 1) {
       cp +=4;
       cp +=4;
     }
     /* version 2 */
     else {
       UTIL_GET_NETLONG (mask, cp);
       mask = ntohl (mask);
       UTIL_GET_NETLONG (next_hop, cp);
       next_hop = ntohl (next_hop);
     }
     UTIL_GET_LONG (metric, cp);
     metric = ntohl (metric);

     prefix = (prefix_t *) New_Prefix (AF_INET, (u_char *) &addr, 32);
     p_attr = (rip_attr_t *) New_Rip_Attr (metric);
     p_attr->gateway = gateway;
     p_attr->nexthop = gateway->prefix;
     p_attr->metric = metric;

     LL_Add ((*ll_prefixes), prefix);
     LL_Add ((*ll_attr), p_attr);
   }
}

