/*
 * $Id: radix.h,v 1.1.1.1 1996/04/09 15:51:00 labovit Exp $
 */

#ifndef _RADIX_H
#define _RADIX_H

typedef struct _radix_node_t {
   int bit;			/* flag if this node used */
   prefix_t *prefix;		/* who we are in radix tree */
   void *data;			/* pointer to data */
   struct _radix_node_t *l, *r;	/* left and right children */
   void	*user1;			/* pointer to usr data (ex. route flap info) */
} radix_node_t;




typedef struct _radix_tree_t {
   radix_node_t 	*head;
   int		maxbits;	/* for IP, 32 bit addresses */
} radix_tree_t;



radix_node_t *radix_search (radix_tree_t *radix, prefix_t *prefix);
radix_node_t *radix_insert (radix_tree_t *radix, prefix_t *prefix);
radix_tree_t *New_Radix (int maxbits);


#endif /* _RADIX_H */
