/*
 * $Id: defs.h,v 1.2 1997/03/21 10:31:32 masaki Exp $
 */

#ifndef _DEFS_H
#define _DEFS_H

#define MAXLINE		512

#define BIT_SET(f, b)   ((f) |= b)
#define BIT_RESET(f, b) ((f) &= ~(b))
#define BIT_FLIP(f, b)  ((f) ^= (b))
#define BIT_TEST(f, b)  ((f) & (b))
#define BIT_MATCH(f, b) (((f) & (b)) == (b))
#define BIT_COMPARE(f, b1, b2)  (((f) & (b1)) == b2)
#define BIT_MASK_MATCH(f, g, b) (!(((f) ^ (g)) & (b)))

#ifndef byte
#define byte u_char
#endif


#if defined(_XOPEN_SOURCE) && (_XOPEN_SOURCE_EXTENDED - 1 == 0)
typedef unsigned char	u_char;
typedef unsigned int	u_int;
typedef unsigned short	u_short;
typedef unsigned long	u_long;
#endif /* defined(_XOPEN_SOURCE) && (_XOPEN_SOURCE_EXTENDED - 1 == 0) */


#endif /* _DEFS_H */

