/*
 * property list header file.
 *
 * G. Robert Malan (rmalan@eecs.umich.edu)
 * 2/20/97
 *
 * $Id: propertyList.h,v 1.1 1997/03/31 01:17:32 labovit Exp $
 */

#ifndef _PROPERTY_H_
#define _PROPERTY_H_ 1

/**
 * Some Well-Known Properties:
 */

#define NAME_PROPERTY		"NAME"
#define TIMESTAMP_PROPERTY	"TIMESTAMP"

/**
 * System properties:
 */

#define OBJ_SIZE_PROPERTY	"OBJ_SIZE"
#define	COMMAND_PROPERTY	"COMMAND"

/*
 * Supplier and Client commands:
 */
#    define PUBLISH_COMMAND	"PUBLISH"
#    define QUERY_COMMAND	"QUERY"
#    define QUERY_RESPONSE	"QUERY RESPONSE"
#    define WHATS_UP_COMMAND "WHATS UP?"
/*
 * Administrative commands:
 */
#    define ENUM_CONNECTIONS	"ENUMERATE CONNECTIONS"
#    define ENUM_CONNECTIONS_RESPONSE "ENUMERATE CONNECTIONS RESPONSE"
#    define ENUM_QUEUES	"ENUMERATE QUEUES"
#    define ENUM_QUEUES_RESPONSE	 "ENUMERATE QUEUES RESPONSE"
#    define DUMP_QUEUE	"DUMP QUEUE"
#    define DUMP_QUEUE_RESPONSE	 "DUMP QUEUE RESPONSE"
#    define REMOTE_CONNECT	"REMOTE CONNECT"
#    define REMOTE_CONNECT_RESPONSE	"REMOTE CONNECT RESPONSE"
#      define HOSTNAME_PROPERTY		"HOSTNAME"



/*
 * Data struct for current implementation.
 */

typedef struct plist_entry {
        char * key;
        char * value;
        struct plist_entry * previous;
        struct plist_entry * next;
} * plist_entry_t;

typedef struct plist {
	plist_entry_t	head;
} * plist_t;

/*
 * Prototypes:
 */

plist_t createPropertyList(void);
void destroyPropertyList(plist_t plist);
int updateProperty(plist_t plist, char * key, char * value);
plist_t copyPropertyList(plist_t from);
void deleteProperty(plist_t list, char * key);
char * getProperty(plist_t plist, char * key);
int iteratePropertyList(plist_t plist, plist_entry_t * cookie,  
			char ** key, char ** value);
void dumpPropertyList(plist_t plist);


#endif	/* _PROPERTY_H_ */
