/*
 * $Id: ping_thread.c,v 1.1 1997/04/03 15:44:41 labovit Exp $
 */

#include <sys/types.h>
#include <sys/stropts.h>
#include <mrt.h>
#ifdef HAVE_SYS_DLPI_H 
#include <sys/dlpi.h>
#include <sys/ethernet.h>
#endif /* HAVE_SYS_DLPI_H */
#include <stdio.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/types.h> 
#include <sys/timeb.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <netinet/in.h>
#include <netinet/in_systm.h>
#include <netinet/ip.h>
#include <time.h>
#include <timer.h>
#ifdef HAVE_SYS_DLPI_H 
#include "dltest.h"
#endif /*  HAVE_SYS_DLPI_H */
#include "uping.h"
#include "config.h"
#include "propertyList.h"
#include "salamanderInterface.h"


extern config_master_t *CONFIG;

void schedule_update_stats (ping_stats_t *stats) {
  schedule_event (PING_THREAD->schedule, (void *) update_stats, 1, stats);
}


/*void schedule_uping_recv () {
  schedule_event (PING_THREAD->schedule, (void *) uping_recv, 0, NULL);
}*/


void schedule_uping_timer (mtimer_t *timer) {
  schedule_event (PING_THREAD->schedule, (void *) uping_timer, 0, NULL);
}

void schedule_calculate_statistics (mtimer_t *timer) {
  schedule_event (PING_THREAD->schedule, (void *) calculate_statistics, 0, NULL);
}

void schedule_show_stats (uii_connection_t *uii) {
  schedule_event (PING_THREAD->schedule, (void *) ping_show_stats, 1, uii);
}

/* ping_calculate_statistic
 * ping thread job to run through last 30 seconds of data and publish
 * statistics
 */
void calculate_statistics () { 
  uping_dst_t *uping_dst;
  ping_t *ping, *ping_tmp;
  u_long now;
  int packets;


  LL_Iterate (PING_THREAD->ll_uping_dst,  uping_dst) {
    uping_dst->delay = 0;
    uping_dst->sent = 0;
    uping_dst->recv = 0;
    now = time (NULL);
    
    LL_Iterate (uping_dst->ll_sent, ping) {
      ping_tmp = LL_GetPrev (uping_dst->ll_sent, ping);
      uping_dst->sent++;
      if (ping->delay < -1) {
	uping_dst->recv++;
	uping_dst->delay += ping->delay;
      }
      

      /* leave 20 seconds room */
      if (now - ping->sent_sec <= 10) {
	/* report stats */

	if (uping_dst->recv > 0) 
	  uping_dst->delay = ((float) uping_dst->delay) / ((float) uping_dst->recv);

	trace (NORM, PING_THREAD->trace, 
	       "ping %s [%d sent, %d recv, %d delay, %d duplicate]\n", 
	       prefix_toa (uping_dst->dst),
	       uping_dst->sent, uping_dst->recv, uping_dst->delay, uping_dst->duplicate);
	publish (uping_dst);
	uping_dst->duplicate = 0;
	LL_Remove (uping_dst->ll_sent, ping);
	Delete (ping);
	ping = ping_tmp;
	break;
      }

      LL_Remove (uping_dst->ll_sent, ping);
      Delete (ping);
      ping = ping_tmp;
    }
  }
}






/*
 * void update_local_stat ()
 * find the ping entry that correspond to this time and msec. Update
 * this entry with the delay and mark that it has been received
 */
void update_stats (ping_stats_t *stats) {
  uping_dst_t *uping_dst;
  ping_t *ping;
  long delay, sent, recv;

  LL_Iterate (PING_THREAD->ll_uping_dst,  uping_dst) {


    /* look for match where as and destination are the same */
    if ((uping_dst->AS == stats->AS) && 
	(!memcmp ((char *) &(stats->dst), prefix_tochar (uping_dst->dst), 4))) {
      
      /* now look through all the packets we sent */
      LL_Iterate (uping_dst->ll_sent, ping) {
	if ((ping->sent_sec == stats->sec) && (ping->sent_msec == stats->msec)) {
	  sent = stats->sec * 1000 + stats->msec;
	  recv = stats->rsec *1000 + stats->rmsec;
	  delay = recv - sent;
	  if (delay < 0) {delay = 0;}
	  trace (TRACE|TR_PACKET, PING_THREAD->trace, "Delay %d\n",
		 delay);
	  if (ping->delay != -1 ) {
	    uping_dst->duplicate++;
	  }
	  ping->delay = delay;
	  Delete (stats);
	  return;
	}
      }
    }
  }

  Delete (stats);
  trace (NORM, PING_THREAD->trace, 
	 "*** ERROR *** bogus packet received (echo or udp to subnet)\n");
}





/* uping_timer
 * service periodic uping timer and send udp packets to local and
 * remote peers 
 */
void uping_timer () {
  uping_dst_t *uping_dst;
  int i;

  LL_Iterate (PING_THREAD->ll_uping_dst,  uping_dst) {
    for (i=0; i< CONFIG->sequence; i++) {

      if (uping_dst->interface == UPING_UDP) {
	send_udp_stack (PING_THREAD->udp_fd, uping_dst, 512);
      }
#ifdef HAVE_SYS_DLPI_H 
      /* ethernet */
      else if (uping_dst->interface == UPING_ETHERNET) {
	
	/* bad interface */
	if (PING_THREAD->fd == -1) 
	  return;

	send_udp_mac (PING_THREAD->fd, &PING_THREAD->ether_addr, uping_dst, 
		      CONFIG->packet_size);
      }
#endif /* HAVE_SYS_DLPI_H */
    }
  }
}


int ping_show_stats (uii_connection_t *uii) {
  uping_dst_t *uping_dst;
  char *type[] = {"local ", "remote"};

  LL_Iterate (PING_THREAD->ll_uping_dst,  uping_dst) {
#ifdef HAVE_SYS_DLPI_H
    uii_send_data (uii, "\r\n%s AS%d %s via %s [DLPI ETHERNET]\r\n", type[uping_dst->type], 
		   uping_dst->AS, prefix_toa (uping_dst->dst), 
		   ether_ntoa (uping_dst->ether_addr));
#else
    uii_send_data (uii, "%s AS%d %s [STACK UDP]\r\n", type[uping_dst->type], 
		   uping_dst->AS, prefix_toa (uping_dst->dst));
#endif /* HAVE_SYS_DLPI_H */
    uii_send_data (uii, "\tsent %d, recv %d, delay %d, duplicate %d\r\n",
		   uping_dst->sent, uping_dst->recv, uping_dst->delay, uping_dst->duplicate);
  }
}  


/* ping
 * thread waits for new events like timer firing
 */
int ping () {
#ifdef HAVE_LIBPTHREAD
  while (1) 
      schedule_wait_for_event (PING_THREAD->schedule);
   exit (0);
#else
   return (0);
#endif /* HAVE_LIBPTHREAD */
}



int init_ping_thread (trace_t *default_trace) {
  PING_THREAD = New (ping_thread_t);
  PING_THREAD->schedule = (schedule_t *) New_Schedule ("UPING pings", default_trace);
  PING_THREAD->trace = default_trace;
  PING_THREAD->ll_uping_dst = LL_Create (NULL);
  return (1);
}



int start_ping_thread () {
  PING_THREAD->udp_fd = socket (AF_INET, SOCK_DGRAM, 0);
#ifdef HAVE_SYS_DLPI_H
  PING_THREAD->fd = init_dlpi (&PING_THREAD->ether_addr);
#endif /* HAVE_SYS_DLPI_H */

  mrt_thread_create ("Ping Thread", PING_THREAD->schedule, 
		     (void *)  ping, PING_THREAD->trace);

  return (1);
}



int ping_add_dst (uping_dst_t *dst) {
  LL_Add (PING_THREAD->ll_uping_dst, dst);
}

int schedule_ping_add_dst (uping_dst_t *dst) {
  schedule_event (PING_THREAD->schedule, (void *) ping_add_dst, 1, dst);
}


/* send_udp_stack
 * build and send a UDP ping packet using kernel stack (i.e. sendto)
 */
int send_udp_stack (int fd,  uping_dst_t *uping_dst, int size) 
{ 
  u_char buf[1024], *cp;
  struct sockaddr_in to;
  struct timeb tp;
  ping_t *ping;
  int s;

  ping = New (ping_t);
  
  to.sin_family = AF_INET;
  to.sin_port = htons (PORT);
  memcpy (&to.sin_addr, prefix_tochar (uping_dst->dst), sizeof (struct  in_addr));

  /* 
   * data section (minimum of 14 bytes)
   * 1 type | 4 time | 2 mill time | 2 AS | 4 src | 4 dst 
   */
  cp = buf;
  UTIL_PUT_BYTE (uping_dst->type, cp);
  ftime (&tp);
  UTIL_PUT_LONG (htonl (tp.time), cp);   /* time */
  UTIL_PUT_SHORT (htons (tp.millitm), cp);   /* sequence num */
  UTIL_PUT_SHORT (htons (uping_dst->AS), cp);   /* AS */
  UTIL_PUT_LONG (htonl (prefix_tolong (CONFIG->source_ip)), cp);   /* src ip */
  UTIL_PUT_LONG (htonl (prefix_tolong (uping_dst->dst)), cp);   /* dst ip */

  if (sendto(fd, buf, 512, 0, (struct sockaddr *) &to, sizeof (to)) == -1) {
    perror ("sendto failed");
    exit (0);
  }

  trace (TRACE|TR_PACKET, PING_THREAD->trace, "Sending uping to %s %d.%d [STACK UDP]\n", 
	 prefix_toa (uping_dst->dst), tp.time, tp.millitm);

  ping->sent_sec = tp.time;
  ping->sent_msec = tp.millitm;
  ping->delay = -1;
  LL_Add (uping_dst->ll_sent, ping); 
}



#ifdef HAVE_SYS_DLPI_H
/* generate a MAC layer version of a UDP packet so we can specify the nexthop ourselvese.
 * deal with the checksum and other garbage 
 */
int send_udp_mac (int fd, 
	      struct ether_addr *ether_addr,
	      uping_dst_t *uping_dst, int size) 
{ 

  u_char		xmitbuf[9024];
  u_char *dstmac; 
  u_char addr[1024]; 
  u_char localphys[6]; 
  u_char *phys, *iph, *cp;
  u_char *checksum, *udph, *udp_checksum, *data;
  struct	ether_header	*ehp;
  struct timeb tp;
  ping_t *ping;

  /* 
   * Ethernet header
   */
  ehp = (struct ether_header*) xmitbuf;

  memcpy(&ehp->ether_dhost, 
	 (u_char *) &uping_dst->ether_addr, ETHERADDRL); /* dst */
  memcpy(&ehp->ether_shost, ether_addr, ETHERADDRL);   /* src */
  ehp->ether_type = (u_short) 0x0800; /*  ETHERTYPE_IP */

  if (strioctl(fd, DLIOCRAW, -1, 0, 0) < 0)
    perror ("ioctl DLIOCRAW");

  
  /*
   * IP Header creation
   */
	
  iph = cp = xmitbuf + 14;
  UTIL_PUT_BYTE (69, cp);   /* version & IHL */
  UTIL_PUT_BYTE (0, cp);   /*  TOS */
  UTIL_PUT_SHORT (28 + size, cp);  /*  total length */

  UTIL_PUT_SHORT (34783, cp);   /*  ID */
  UTIL_PUT_BYTE  (64, cp);   /*  flags & offset */
  UTIL_PUT_BYTE  (0, cp);   /*  flags & offset */
	
  UTIL_PUT_BYTE (255, cp);   /*  TTL */
  UTIL_PUT_BYTE (IPPROTO_UDP, cp);   /*  protocol */
  checksum = (u_char *) cp;
  UTIL_PUT_SHORT (0, cp);   /* set checksum to 0 for now */

  UTIL_PUT_LONG (htonl (prefix_tolong (CONFIG->source_ip)), cp); /* src */
  UTIL_PUT_LONG (htonl (prefix_tolong (uping_dst->dst)), cp); /* dst */
  
  /* UTIL_PUT_LONG (0, cp);  options */
	
  /* now calculate checksum */
  UTIL_PUT_SHORT (in_cksum(iph), checksum);

  /* 
   * now on to the UDP part 
   */
  udph = cp;
  UTIL_PUT_SHORT (34583, cp);   /*  source port      */
  UTIL_PUT_SHORT (PORT, cp);   /*  destination port */
  /*UTIL_PUT_SHORT (0x09, cp);     length */
  UTIL_PUT_SHORT (8 + size, cp);    /* length */

  udp_checksum = cp;
  UTIL_PUT_SHORT (0x0, cp);   /* checksum */

  /* 
   * data section (minimum of 14 bytes)
   * 1 type | 4 time | 2 mill time | 2 AS | 4 src | 4 dst 
   */
  data = cp;
  UTIL_PUT_BYTE (uping_dst->type, cp);
  ftime (&tp);
  UTIL_PUT_LONG (htonl (tp.time), cp);   /* time */
  UTIL_PUT_SHORT (htons (tp.millitm), cp);   /* sequence num */
  UTIL_PUT_SHORT (htons (uping_dst->AS), cp);   /* AS */
  UTIL_PUT_LONG (htonl (prefix_tolong (CONFIG->source_ip)), cp);   /* src ip */
  UTIL_PUT_LONG (htonl (prefix_tolong (uping_dst->dst)), cp);   /* dst ip */

  {
    /* build and checksum the pseudoheader */
    char yu[9046];
    cp = yu;
    UTIL_PUT_LONG (htonl (prefix_tolong (CONFIG->source_ip)), cp); /* src */
    UTIL_PUT_LONG (htonl (prefix_tolong (uping_dst->dst)), cp); /* dst */
    UTIL_PUT_BYTE (0, cp);
    UTIL_PUT_BYTE (IPPROTO_UDP, cp);   /*  protocol */
    UTIL_PUT_SHORT (8 + size, cp);   /*  length */
    memcpy (cp, udph, 8 + size);


    /*UTIL_PUT_SHORT (chksum(yu, 12 + 10), udp_checksum);*/
    UTIL_PUT_SHORT (chksum(yu, 12 + 8 + size), udp_checksum);
  }

	

  if (write(fd, xmitbuf, 28 + size + 100) < 28+size) 
    perror ("write");

  trace (TR_PACKET|TRACE, PING_THREAD->trace, 
	 "Sent packet %d.%d to %s via %s\n", tp.time, tp.millitm,
	 prefix_toa (uping_dst->dst), ether_ntoa (uping_dst->ether_addr));

  ping = New (ping_t);
  ping->sent_sec = tp.time;
  ping->sent_msec = tp.millitm;
  ping->delay = -1;
  LL_Add (uping_dst->ll_sent, ping); 

  return (0);
}
#endif /* HAVE_SYS_DLPI_H */


/*
 * compute an IP header checksum.
 * don't modifiy the packet.
 */
int in_cksum(u_char *ip)
{
        register const u_short *sp = (u_short *)ip;
        register u_long sum = 0;
        register int count;

        /*
         * No need for endian conversions.
         */
        for (count = 10; --count >= 0; )
                sum += *sp++;
        while (sum > 0xffff)
                sum = (sum & 0xffff) + (sum >> 16);
        sum = ~sum & 0xffff;

        return (sum);
}



u_short chksum(buf,len)
u_short *buf;
int     len;
{
        u_long  sum = 0;
        int     nwords = len >> 1;

        for(; nwords > 0; nwords--)
                sum += *buf++;
        sum = (sum>>16) + (sum & 0xffff);
        sum += (sum >>16);
        return (~sum);
}


/* 
 * uping_recv
 * receive and process UDP echo packet arriving on port
 */
void uping_recv () {
  char tmp[1024];
  u_char *cp = tmp;
  int n;
  struct timeb tp;
  ping_stats_t *stats;

  ftime (&tp);
  stats = New (ping_stats_t);

  trace (TRACE | TR_PACKET, PING_THREAD->trace, "Recevived packet %d.%d\n",
	 tp.time, tp.millitm);

  n = read (PING_THREAD->sockfd, tmp, 17); 
  select_enable_fd (PING_THREAD->sockfd);  

  UTIL_GET_BYTE (stats->type, cp);	/* type */
  UTIL_GET_NETLONG (stats->sec, cp); /* time */
  UTIL_GET_SHORT (stats->msec, cp);  /* sequence number */
  UTIL_GET_SHORT (stats->AS, cp);      
  UTIL_GET_LONG (stats->src, cp);
  UTIL_GET_LONG (stats->dst, cp);

  stats->rsec = tp.time;
  stats->rmsec = tp.millitm;

  if (stats->type == 0) {
    schedule_update_stats (stats);
  }
  else {
    schedule_update_peer (stats);
  }
}
