/*
 * $Id: main.c,v 1.1 1997/04/03 15:44:38 labovit Exp $
 */

#include <sys/types.h>
#include <sys/stropts.h>
#include <mrt.h>
#ifdef HAVE_SYS_DLPI_H 
#include <sys/dlpi.h>
#include <sys/ethernet.h>
#endif /* HAVE_SYS_DLPI_H */
#include <stdio.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/types.h> 
#include <sys/timeb.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <netinet/in.h>
#include <netinet/in_systm.h>
#include <netinet/ip.h>
#include <time.h>
#include <timer.h>
#ifdef HAVE_SYS_DLPI_H 
#include "dltest.h"
#endif /*  HAVE_SYS_DLPI_H */
#include "uping.h"
#include "config.h"
#include "propertyList.h"
#include "salamanderInterface.h"

mtimer_t	*ping_timer;		/* send out pings */
mtimer_t	*stats_timer;	        /* calculate and publish statistics */
mtimer_t	*retry_timer;		/* retry down connections (peer and salamander) */

trace_t			*default_trace;
extern config_master_t	*CONFIG;
peer_thread_t		*PEER_THREAD;
ping_thread_t		*PING_THREAD;


main(int argc, char *argv[])
{
  char *name = (char *) argv[0];
  int daemon = 0;
  char tmp[100];
  extern char *optarg;	/* getopt stuff */
  extern int optind;	/* getopt stuff */
  char c;
  char *config_file = NULL;
  char *port = "mrt";
  int errors = 0;

  char *usage ="Usage: %s [-f config_file] [-p uii_port ] [-v] [-n]\n";

  default_trace = New_Trace ();

  while ((c = getopt (argc, argv, "hnvf:p:")) != -1) 
     switch (c) {
     case 'v': /* verbose */
       set_trace (default_trace, TRACE_FLAGS, NORM | TR_ALL, 
		  TRACE_LOGFILE, "stdout",
		  NULL);
	daemon = 0;
       break;
     case 'f': /* config file */
       config_file = optarg;
       break;
     case 'p': /* uii port number */
       port = optarg;
       break;
     case 'h':
     default:
       errors++;
       break;
     }

   if (errors) {
     fprintf(stderr, usage, name);
     printf ("\nMRT %s compiled on %s\n\n",
	     MRT_VERSION, __DATE__);
     exit (1);
   }
  
  init_trace (name, daemon);
  init_mrt (default_trace);
  init_config (default_trace);

  init_ping_thread (default_trace);
  init_peer_thread (default_trace);

  /*
   * READ Configuration file 
   */
  config_from_file (config_file);

  start_ping_thread ();
  start_peer_thread ();


  init_publish ();	/* salamander webcasting */
  init_recv ();

  ping_timer = 
    New_Timer ((void *) schedule_uping_timer, CONFIG->interval, "UPing timer", NULL);
  timer_set_jitter (ping_timer, CONFIG->jitter);
  Timer_Turn_ON (ping_timer);

  stats_timer = 
    New_Timer ((void *) schedule_calculate_statistics, 30, "Stats timer", NULL);
  Timer_Turn_ON (stats_timer);

  retry_timer =   New_Timer ((void *) schedule_peer_retry, 60, "Retry Timer", NULL);
  Timer_Turn_ON (retry_timer);

  UII->initial_state = 0;
  set_uii (UII, UII_PROMPT, 0, "password> ");
  set_uii (UII, UII_PROMPT, 1, "UPING-1.0> ");
  uii_add_command (0, "", (void *) check_passwd);
  uii_add_command (1, "show stats", (void *) schedule_show_stats);
  uii_add_command (1, "show peers", (void *) show_peers);
  listen_uii2 (port);

  init_uping_peer_listen ();

  while (1) {
#ifndef HAVE_LIBPTHREAD
    while (process_all_schedules()); /* process all first */
    mrt_select ();
#else
    signal (SIGPIPE, mrt_process_signal);
    sleep (1);
#endif /* THREADS */
  }
}



#ifdef HAVE_SYS_DLPI_H
int init_dlpi (struct ether_addr *ether_addr) {
  int	fd;
  long	buf[MAXDLBUF];
  union DL_primitives *dlp;

  int	i;

  /* initialize buf[] */
  for (i = 0; i < MAXDLBUF; i++)
    buf[i] = (unsigned char) i & 0xff;

  /*
   * Open the device.
   */
  if ((fd = open(CONFIG->device, 2)) < 0) {
    trace (NORM, default_trace, "ERROR ** could not open %s **\n", CONFIG->device);
    return (-1);
  }
  
  /*
   * Attach.
   */
  dlattachreq(fd, 0); /* just use 0 for ppa */
  dlokack(fd, buf);

  /*
   * Bind.
   */
  dlbindreq(fd, 0, 0, DL_CLDLS, 0, 0);
  dlbindack(fd, buf);


  /*
   * Get our physical address.
   */
  dlphysaddrreq(fd, DL_CURR_PHYS_ADDR);
  dlphysaddrack(fd, buf);
  dlp = (union DL_primitives*) buf;
  memcpy(ether_addr, OFFADDR(dlp, dlp->physaddr_ack.dl_addr_offset), ETHERADDRL);

  return (fd);
}
#endif /* HAVE_SYS_DLPI_H */


/* 
 * init_recv
 * start listening for UDP ping packets from remote peers and from ourselves (if
 * ping local subnet machines)
 */
int init_recv () {
  struct sockaddr_in serv_addr;
  char buffer[100];
  struct sockaddr from;
  int fromlen;

  /*serv_addr.sin_port = htons (5670);*/
  serv_addr.sin_port = PORT;
  serv_addr.sin_family = AF_INET;
  serv_addr.sin_addr.s_addr = htonl (INADDR_ANY);

  if ( (PING_THREAD->sockfd = socket (AF_INET, SOCK_DGRAM, 0)) < 0) {
    trace (NORM, default_trace, "ERROR -- Could not get socket (%s)\n",
	   strerror (errno));
    return (-1);
  }

  if (bind (PING_THREAD->sockfd, (struct sockaddr *) &serv_addr, sizeof (serv_addr)) < 0) {
      trace (NORM, default_trace, "ERROR -- BIND Failed in init_recv (%s)\n",
	     strerror (errno));
      return (-1);
  }

  trace (NORM, default_trace, "Listening for uping packets  on port %d\n", 
	 5670);

   select_add_fd (PING_THREAD->sockfd, 1, (void *) uping_recv, NULL);
   select_enable_fd (PING_THREAD->sockfd);
}


/* init publish
 * initialize routines for the Salamander webcasting server connection 
 */
int init_publish () {
  int ret;
  int sskey = 1234567;

  if (CONFIG->publish_prefix != NULL) {
    ret = connectToSalamanderServer(prefix_toa (CONFIG->publish_prefix), CONFIG->key);
    trace (NORM, default_trace, "Connecting to Salamander Server %s (key %d)\n", 
	   prefix_toa (CONFIG->publish_prefix), CONFIG->key);
  }
}



/* publish
 * transmit statistics data update to Salamander webcasting server
 */
int publish (uping_dst_t *uping_dst) {
  plist_t plist;
  char tmp[1000];
  int ret;

  if (CONFIG->publish_prefix == NULL) {
    return (0);
  }
  
  plist = createPropertyList();
  updateProperty(plist, COMMAND_PROPERTY, PUBLISH_COMMAND);
  updateProperty(plist, NAME_PROPERTY, "netnow");
  updateProperty(plist, "LOCATION", CONFIG->name);
  sprintf (tmp, "%d", time (NULL));
  updateProperty(plist, "TIME", tmp);
  memset (tmp, 0, 100);
  sprintf (tmp, "%d", uping_dst->type);
  updateProperty(plist, "SCOPE", tmp);

  sprintf (tmp, "%s %d send:%d recv:%d delay:%d duplicate:%d scope:%d",
	   prefix_toa (uping_dst->dst),
	   uping_dst->AS, 
	   uping_dst->sent, uping_dst->recv, 
	   uping_dst->delay, uping_dst->duplicate,
	   uping_dst->type);

  ret = salamanderSendServerData(plist, tmp, strlen (tmp));

  destroyPropertyList(plist);

  if (ret != SALAMANDER_OK) {
    trace (NORM, default_trace, "Salamdaner error!\n");
    init_publish ();
  }

}






