#!/usr/local/bin/perl

require "getopts.pl";

&Getopts("f:i:");
if(defined $opt_f) { $INPUT = $opt_f;}
if(defined $opt_i) { $INPUT = $opt_i;}
if ($INPUT eq "") {&error;}




open (INPUT, "$INPUT") || die "Could not open $INPUT $!\n";


while ($buf = &get(16)) {
    ($time, $seq, $as, $s1, $s2, $s3, $s4,
     $d1, $d2, $d3, $d4) = unpack ("NSSC4C4", $buf);

    ($sec, $min, $hour, $mday, $mon, $year, @junk) = localtime ($time);
    $mon++;

    print "Time: $mon/$mday/$year $hour:$min:$sec\n";
    print "Seq: $time $seq\n";

    printf "Src: $s1.$s2.$s3.$s3  AS$as\n";
    printf "Dst: $d1.$d2.$d3.$d3  AS$as\n";

    
    print "\n";


}



sub get {
    local ($bytes) = @_;
    
    $buf = "";
    if (($n = read (INPUT, $buf, $bytes)) != $bytes) {
        if (($n == 0) && ($bytes == 12)) {exit;}
        #print "read $n bytes, expected $bytes\n";
        exit;
    }
    
    $read += $bytes;
    return ($buf);
}


sub error {
    print "Usage: decode.pl -i binary_data_file\n";
    exit;
}
la
