#!/bin/perl
#
#
# cron job that
#   1) moves SBGP datafile off
#   2) sends HUP to sbgp process
#   3) munges SBGP data


$DATAFILE = "/tmp/sbgp.data";
$MUNGEDDATA = "/yusr/httpd/htdocs/route_stats/report";

#
# get sbgp pid
#
$pid = 0;
open (PROCESS, "ps -e |");

while (<PROCESS>) {
    if (!(/sbgp/)) {next;}
    if (/^\s+(\d+)/) {$pid = $1;}
}

if ($pid == 0) {&error ("SBGO process not found");}

rename ($DATAFILE, "$DATAFILE.0") || die ("rename error: $!");
kill (SIGHUP, $pid);

$output = `route_btoa -mi $DATAFILE.0 > /tmp/temp`;
$output = `routeflap /tmp/temp /tmp/temp.0`;
$output = `flapsort /tmp/temp.0 > $MUNGEDDATA`;



sub error {
    local ($mesg) = @_;

    print "$mesg\n";

    exit;
}
