#include <sys/types.h>
#include <sys/ipc.h>
#include <sys/msg.h>
#include <hash.h>
#include <io.h>
#include <New.h>
#include "msgserver.h"

void
handle_setmbox(HASH_TABLE *mqhash, ARB_MSG_Struct *msg)
{
   MQINFO_Struct *info, *old;

   info = New(MQINFO_Struct);
   memcpy(info, &msg->mqinfo, sizeof(MQINFO_Struct));

   if ((old = HASH_Lookup (mqhash, info)) != NULL) {
     printf ("already hashed... deleting... 0x%x\n", old->key);
     if (msgctl(msgget (old->key, 0), IPC_RMID, (struct msqid_ds *) NULL) == -1) {
       perror ("Could not delete key");
     }
     HASH_Remove (mqhash, old);
   }

   HASH_Insert(mqhash, info);
   return;
}

int
handle_getmbox(HASH_TABLE *mqhash, ARB_MSG_Struct *msg)
{
   MQINFO_Struct *info;
   int sender_qid;

#ifdef DEBUG
   fprintf(stderr, "getting qid for key 0x%x\n", msg->sender);
#endif

   if((sender_qid = msgget(msg->sender, 0222)) < 0) {
#ifdef DEBUG
      fprintf(stderr, "couldn't get qid: %s\n", strerror(errno));
#endif
      return(-1);
   } else {
#ifdef DEBUG
      fprintf(stderr, "got sender_qid=%d\n", sender_qid);
#endif
      ;
   }

   if((info = HASH_Lookup(mqhash, msg->mqinfo.client)) != NULL) {
#ifdef DEBUG
      fprintf(stderr, "found key 0x%x for client \"%s\"\n", info->key,
	      msg->mqinfo.client);
#endif
      msg->mqinfo.key = info->key;
   } else {
      /* client not registered */
#ifdef DEBUG
      fprintf(stderr, "client \"%s\" not found\n", msg->mqinfo.client);
#endif
      msg->mqinfo.key = -1;
   }

   if(msgsnd(sender_qid, (struct msgbuf *)msg, sizeof(ARB_MSG_Struct), 0) < 0) {
#ifdef DEBUG
      fprintf(stderr, "couldn't send response to qid %d: %s\n", sender_qid,
	      strerror(errno));
#endif
      return -1;
   } else {
#ifdef DEBUG
      fprintf(stderr, "response successfully sent to qid %d\n", sender_qid);
#endif
      return 0;
   }
}

void
handle_clrmbox(HASH_TABLE *mqhash, ARB_MSG_Struct *msg)
{
   MQINFO_Struct *info;

   if((info = HASH_Lookup(mqhash, msg->mqinfo.client)) != NULL) {
      HASH_RemoveByKey(mqhash, msg->mqinfo.client);
      Delete(info);
   }
}

void handle_dump(HASH_TABLE *mqhash, ARB_MSG_Struct *msg)
{
   MQINFO_Struct *info;

   HASH_Iterate(mqhash, info) {
      printf("Hash table dump: client=\"%s\", key=0x%x\n",
	     info->client, info->key);
   }

   return;
}
