/*
 * $Id: monitord.c,v 1.8 1997/03/21 10:32:57 masaki Exp $
 */

#include <stdio.h>
#include <string.h>
#include <mrt.h>
#include <trace.h>
#include <interface.h>
#include <bgp.h>
#include <signal.h>
#include <patricia.h>
#include "monitord.h"

int show_ip_routes (int fd, char *line);
int show_exact (uii_connection_t *uii);
int show_less (uii_connection_t *uii);

patricia_t PT;
pstack_t S;
rsd_route_head_t *current_head;

main (int argc, char *argv[]) {
  char c;
  extern char *optarg;	/* getopt stuff */
  extern int optind;	/* getopt stuff */
  int errors = 0;

  char *usage ="Usage: monitord [-v]\n";
  trace_t *default_trace = NULL;
  
  while ((c = getopt(argc, argv, "v")) != -1) 
     switch (c) {
     case 'v': /* verbose */
       default_trace = New_Trace ();
       set_trace (default_trace, TRACE_FLAGS, TR_ALL, 
		  TRACE_LOGFILE, "stdout",
		  NULL);
       break;
     case 'f': /* config file */
       /*config_file = strdup ((char *) (optarg));*/
       break;
     case 'h':
     default:
       errors++;
       break;
     }


   if (errors) {
     fprintf(stderr, usage);
     printf ("\nMRT version (%s) compiled on %s\n\n",
	     MRT_VERSION, __DATE__);
     exit (0);
   }
  

   init_mrt ();

   stack_init(&S);
   PT =(patricia_t ) patricia_new(0, 0, MAX_BIT+1); 

   set_uii (UII, UII_PROMPT, 1, "RSd-monitor> ");
   set_uii (UII, UII_PROMPT, 2, "RSd-monitor-config> ");

   uii_add_command (1, "show less", (void *) show_less);
   uii_add_command (1, "show more", (void *) show_ip_routes);
   uii_add_command (1, "show exact", (void *) show_exact);
   read_fastdump ();
   listen_uii ();

#ifndef HAVE_LIBPTHREAD
   while (1) {
     process_all_schedules();
     mrt_select ();
   }
#endif /* HAVE_LIBPTHREAD */

   /* loop */
   while (1);
}


int show_ip_routes (int fd, char *line) {
  

}



/* read_fastdump
 */
int read_fastdump () {
  FILE *fd;
  char line[MAXLINE], ip[MAXLINE], mask[MAXLINE];
  int r;
  int start = 0;
  unsigned p3, p2, p1, p0;
  u_long temp, mask_long, mask_len;
  u_char *c;
  patricia_t PN;
  rsd_route_t *route;

  if ((fd = fopen ("/yusr/tmp/rsd_dump", "r")) == NULL) {
    perror ("read failed");
    exit (0);
  }

  while (fgets (line, MAXLINE, fd) != 0) {
    if (start == 1) {
      char *cp;
      char *aspath;
      u_int l;
      
      if (line[0] == 'V') {continue;}
      if (line[0] == '\n') {start = 0; continue;}

      if (line[0] != 'R') {printf ("Error %s\n", line); exit (0);}
      
      if ((cp = strstr (line, "A=")) == NULL) {continue;}
      route = new_rsd_route (cp);

      if ((cp = strstr (line, "R=")) == NULL) {continue;}
      cp +=2;
      parse_line (cp, "%d", &l);
      route->peer_as = (short) l;

      if ((cp = strstr (line, "N=")) == NULL) {continue;}
      cp +=2;

      parse_line (cp, "%p", &(route->nexthop));
      LL_Add (current_head->ll_routes, route);
    }
    else if ((line[0] == 'D') && (line[1] == '[')) {
      start = 1;

      printf ("%s", line);
      sscanf (line, "D[%[0123456789.]/%[0123456789.]]: r=%d", ip, mask, &r);

      if (r <= 0) {continue;}

      p3 = p2 = p1 = p0 = 0;
      sscanf(ip, "%d.%d.%d.%d", &p3, &p2, &p1, &p0);
      temp =  ipp_to_num(p3, p2, p1, p0);

      p3 = p2 = p1 = p0 = 0;
      sscanf(mask, "%d.%d.%d.%d", &p3, &p2, &p1, &p0);
      mask_long = ipp_to_num(p3, p2, p1, p0);

      mask_len = 0;
      while (mask_long <<= 1) {
	mask_len++;
      }
      mask_len++;

      /*printf ("** %s/%s %d\n", ip, mask, mask_len);*/

      PN = patricia_insert2(temp, mask_len, &PT);
      if (PN->data == NULL) {
	PN->data = current_head = new_rsd_route_head ();
      }
    }      
    else {
      start = 0;
    }
    memset (line, 0, MAXLINE);
  }
}

int show_exact (uii_connection_t *uii) {
  prefix_t *prefix;
  patricia_t T2 = NULL;
  u_long k, k2;
  int n;
  u_char *c1, *c2;

  if ((n= parse_line (uii->cp, "%p", &prefix)) != 1) {
    uii_send_data (uii, "ERROR: show exact xx.xx.xx.xx\r\n");
    return (-1);
  }

  k = prefix_tolong (prefix); 
  c1 = (u_char *) &k;
  /*c2 = (u_char *) &k2;
  c2[0] = c1[3];
  c2[1] = c1[2];
  c2[2] = c1[1];
  c2[3] = c1[0];*/

  if ((T2 = patricia_find(k, PT)) == NULL) {
    uii_send_data (uii, "%s exact not found\r\n", prefix_toa (prefix));
    return (-1);
  }

  show_node (uii, T2);

}


int show_less (uii_connection_t *uii) {
  prefix_t *prefix;
  patricia_t PN, T2 = NULL;
  u_long k, k2;
  int n;
  u_char *c1, *c2;

  if ((n= parse_line (uii->cp, "%p", &prefix)) != 1) {
    uii_send_data (uii, "ERROR: show less xx.xx.xx.xx\r\n");
    return (-1);
  }

  k = prefix_tolong (prefix); 
  c1 = (u_char *) &k;
  /*c2 = (u_char *) &k2;
  c2[0] = c1[3];
  c2[1] = c1[2];
  c2[2] = c1[1];
  c2[3] = c1[0];*/


  if ((PN = patricia_find2(k, 32, PT)) == NULL) {
    uii_send_data (uii, "%s parent not found\r\n", prefix_toa (prefix));
    return (-1);
  }

  show_node (uii, PN);

}


int show_node (uii_connection_t *uii, patricia_t node) {
  rsd_route_head_t *head;
  rsd_route_t *route;
  u_char *c;

  head = node->data;
  c = (u_char *)&node->key;

  uii_send_data (uii, "Prefix: %d.%d.%d.%d/%d\n\r", c[0], c[1], c[2], c[3],
		 node->pref_len);

  LL_Iterate (head->ll_routes, route) {
    route->aspath[strlen(route->aspath) -1] = '\0';
    uii_send_data (uii, "\tR=%d N=%s %s\r\n", 
		   route->peer_as, prefix_toa (route->nexthop), route->aspath);
  }

}


rsd_route_head_t* new_rsd_route_head () {
  rsd_route_head_t *tmp;
  
  tmp = New (rsd_route_head_t);
  tmp->ll_routes = LL_Create (0);

  return (tmp);
}


rsd_route_t* new_rsd_route (char *aspath) {
  rsd_route_t *tmp;

  tmp = New (rsd_route_t);
  memcpy (tmp->aspath, aspath, strlen (aspath));

  if (LL_GetCount (current_head->ll_routes) >= 1) {
    /*printf ("here\n");*/
  }
  /*LL_Add (curre_head->ll_routes, tmp);*/

  return (tmp);
}
