/*
 * $Id: rm_util.c,v 1.1.1.1 1996/04/09 15:50:27 labovit Exp $
 */


#include <stdio.h>
#include <sys/types.h>
#include <stack.h>
#include <mrt.h>
#include <radix.h>
#include <route_manager.h>

/*-----------------------------------------------------------
 *  Name: 	New_Route_Node
 *  Created:	Mon Feb 20 14:34:02 1995
 *  Author: 	Craig Labovitz   <labovit@snoopy.merit.net>
 *  DESCR:  	allocate Route_Node memory
 */

route_node_t *New_Route_Node (route_head_t *route_head,
			      int pref, generic_attr_t *attr) {

   route_node_t *tmp = (route_node_t *) New (route_node_t);
   tmp->route_head = route_head;
   tmp->pref = pref;
   tmp->attr = attr;
   
   attr->ref_count++;
   return (tmp);
}



/*-----------------------------------------------------------
 *  Name: 	New_Route_Head
 *  Created:	Tue May 16 22:12:18 1995
 *  Author: 	Craig Labovitz   <labovit@snoopy.merit.net>
 *  DESCR:  	
 */

route_head_t *New_Route_Head (radix_node_t *radix_node) {
  route_head_t *tmp = New (route_head_t);
  
  tmp->radix_node = radix_node;
  tmp->ll_route_nodes = LL_Create (NULL);
  tmp->active = NULL;
   
   return (tmp);
}


/*-----------------------------------------------------------
 *  Name: 	Delete_Route_Node
 *  Created:	Sun Apr 23 13:07:58 1995
 *  Author: 	Craig Labovitz   <labovit@snoopy.merit.net>
 *  DESCR:  	
 */

void Delete_Route_Node (route_node_t *rt_node) {
   generic_attr_t *attr;
   
   attr = (generic_attr_t *) rt_node->attr;

   attr->ref_count--;
   if (attr->ref_count <= 0) {
      /*lbgp_print_attr (rt_node->p_attr);*/
      /*printf ("\nRef count now %d", rt_node->p_attr->ref_count);*/
     /*rm_delete_attr (rt_node->p_attr);*/
   }
   Delete (rt_node);

}

/*-----------------------------------------------------------
 *  Name: 	New_Route_Manager
 *  Created:	Mon Feb 20 14:34:25 1995
 *  Author: 	Craig Labovitz   <labovit@snoopy.merit.net>
 *  DESCR:  	allocate Route_Manager_Struct memory
 */

route_manager_t *New_Route_Manager (int maxbitlen)
{
   route_manager_t *tmp = New (route_manager_t);

   tmp->radix = (radix_tree_t *) New_Radix (maxbitlen);
   /*tmp->ll_route_nodes = LL_Create (NULL);*/
   tmp->ll_changed_route_nodes = LL_Create (NULL);
   
   /*if (LL_ATTR_MEMORY == NULL)
      init_attr_memory ();*/

   pthread_mutex_init (&tmp->mutex_lock, NULL);

   return (tmp);
}
