
#include <stdio.h>
#include <mrt.h>
#include <trace.h>
#include <interface.h>
#include <rip.h>
#include <signal.h>

rip_t *RIP;
void rip_recv_update ();
void quit ();
int rip_uii (char *str);
void show_routing_table (int fd);

main (int argc, char *argv[]) {
  char c;
  extern char *optarg;	/* getopt stuff */
  extern int optind;	/* getopt stuff */
  int errors = 0;
  char *usage ="Usage: srip\n";
  trace_t *default_trace = NULL;
  

#ifdef SOLARIS
   thr_setconcurrency (10);
#else
   pthread_init ();
#endif
   signal (SIGINT, quit);

   while ((c = getopt(argc, argv, "v")) != -1) 
     switch (c) {
     case 'v': /* verbose */
       VERBOSE_ERROR_FLAG = 1;
       default_trace = New_Trace ();
       set_trace (default_trace, TRACE_FLAGS, TR_ALL, 
		  TRACE_LOGFILE, "stdout",
		  NULL);
       break;
     case 'h':
     default:
       errors++;
       break;
     }


   if (errors) {
     fprintf(stderr, usage);
     printf ("\nMRT version (%s) compiled on %s\n\n",
	     MRT_VERSION, __DATE__);
     exit (0);
   }
   
   init_mrt (default_trace);
   init_rip (default_trace);


   config_from_file ("./config");
   start_rip ();


   /* loop */
   while (1);
}



void rip_recv_update (prefix_t *neighbor, char *buf, int len) {
  prefix_t *prefix, *p;
  LINKED_LIST *ll_prefixes, *ll_attr;
  rip_attr_t *rip_attr;
  char tmp[MAXLINE];
  /*printf ("\nHere in recv_update!");*/
  

  /*rip_process_update (prefix, buf, len, &ll_prefixes, &ll_attr);

  rip_attr = LL_GetHead (ll_attr);
  LL_Iterate (ll_prefixes, p) {
    trace (NORM, RIP->trace, "recv RIP %s metric %d", 
	   r_inet_ntoa (tmp, MAXLINE, p->dest, p->bitlen),
	   rip_attr->metric);
    rip_attr = LL_GetNext (ll_attr, rip_attr);
  }*/

}

void quit () {
  printf ("\nQUIT\n");
  select_shutdown ();
  exit (0);
}


