/* 
 * $Id: config.c,v 1.1.1.1 1996/04/09 15:50:24 labovit Exp $
 */

#include <sys/types.h>
#include <sys/socket.h>
#include <sys/time.h>
#include <sys/stat.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <signal.h>
#include <fcntl.h>
#include <errno.h>
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <mrt.h>
#include <trace.h>
#include <io.h>
#include <select.h>
#include <stdarg.h>
#include "user.h"

int start_config (int sockfd, FILE *fd, uii_connection_t *uii_connection) {
  char buffer[MAXLINE], *line, *token;
  line = buffer;
  
  if (uii_connection)
    uii_send_data (sockfd, "config> ");

  if (sockfd != 0) {
    if (read (sockfd, line, MAXLINE) == 0) {
      printf("\nConnection closed");
      shutdown (sockfd, 2);
      return (0);
    }
  }
  else {
    if (fgets (line, MAXLINE, fd) == 0) {
      /* printf("\nConnection closed");*/
      return (0);
    }
  }

  if (((token = uii_parse_line (&line)) == NULL) ||
      (!strcasecmp (token, "exit"))) {
    return (0);
  }

  
  if (!strcasecmp (token, "no")) {
    if ((token = uii_parse_line (&line)) == NULL)
      return (0);
    /* state = negate */
  }

  /* comment */
  if (!strcasecmp (token, "!")) 
    return (1);

  if (!strcasecmp (token, "ip")) {
    if ((token = uii_parse_line (&line)) == NULL)
      return (0);
    
    /* static routing */
    if (!strcasecmp (token, "route")) {
      prefix_t *prefix, *next_hop;
      if ((token = uii_parse_line (&line)) == NULL) return (-1);
      prefix = New_Prefix_from_String (token);
      if (prefix == NULL) return (-1);
      if ((token = uii_parse_line (&line)) == NULL) return (-1);
      next_hop = New_Prefix_from_String (token);
    }
  }

  
  /* routing protocol instance */
  if (!strcasecmp (token, "router")) {
    while (config_router_rip (sockfd, fd, uii_connection));
    return (1);
  }

  if (!strcasecmp (token, "?")) {
    uii_send_data (sockfd, "Configure commands:\n");
    uii_send_data (sockfd, "  router\tEnable a routing process\n");
    uii_send_data (sockfd, "  trace\tEnable logging\n");
    return (1);
  }

  /* default */
  if (uii_connection)
    uii_send_data (sockfd, "Unrecognized Configuration Directive\n");
  return (1);
}

int config_from_file (char *filename) {
  FILE *fd;
  char line[MAXLINE];

  if ((fd = fopen (filename, "r")) == NULL)
    return (-1);

  while (start_config (0, fd, NULL));
}




