/*
 * $Id: timer.h,v 1.8 1997/04/03 15:43:09 labovit Exp $
 */

#ifndef _TIMER_H
#define _TIMER_H

#include <sys/types.h>
#include <signal.h>
#include <New.h>
#include <linked_list.h>

#ifndef HAVE_PTHREAD_H
#include <pthread_fake.h>
#ifdef HAVE_SIGSET
typedef unsigned long sigset_t;
#endif
#else
#include <pthread.h>
#endif /* HAVE_PTHREAD_H */

#define TIMER_ONE_SHOT		1 /* a one-shot timer (i.e. not periodic */

typedef struct _mtimer_t {
   int time_interval;		/* seconds between firing (plus jitter) */ 
  int time_interval_base;	/* seconds between firing base */
   int time_next_fire;		/* real time after which should fire */
   int jitter;			/* 0 no jitter, else random between +/- value */
   void (*call_fn)();		/* function to call when timer fires */
   void *arg;			/* arguments to give to called function */
   u_char on;			/* timer is turned ON if this set to 1 */
   char *name;			/* used for logging and debugging */
   u_long flags;		/* one-shot, etc */
} mtimer_t;


typedef struct _Timer_Master {
   int time_interval;		/* seconds btwn firing (debugging purposes) */
   int time_next_fire;		/* real time after which should fire */
   pthread_mutex_t mutex_lock;
   LINKED_LIST *ll_timers;	/* linked list of period timers */
   trace_t *trace;
} Timer_Master;

extern Timer_Master *TIMER_MASTER;


void init_timer ();
void Timer_Master_Update (mtimer_t *timer);
int Timer_Compare (mtimer_t *t1, mtimer_t *t2);
void Destroy_Timer_Master (Timer_Master *timer);
void Timer_Turn_OFF (mtimer_t *timer);
void Timer_Turn_ON (mtimer_t *timer);
mtimer_t *New_Timer (void (*call_fn)(), int interval, char *name, void *arg);
void Timer_Set_Time (mtimer_t *timer, int interval);
void Timer_Reset_Time (mtimer_t *timer);

void timer_set_flags (mtimer_t *timer, int flags);
int timer_set_jitter (mtimer_t *timer, int jitter);
int timer_left (mtimer_t *timer);

sigset_t block_signal (int sig);
void recover_signal (sigset_t old);

#endif /* _TIMER_H */
