/*
 * $Id: aspath.h,v 1.4 1996/12/23 14:36:23 masaki Exp $
 */

#ifndef ASPATH_H
#define ASPATH_H

typedef struct _aspath_segment_t {
   u_char	type;		/* PA_PATH_SET | PA_PATH_SEQ */
   u_char	len;
   short	*as;		/* AS's */
} aspath_segment_t;


typedef struct aspath_t {
  LINKED_LIST *ll_segments;
} aspath_t;


/*
 * Bit definitions for the attribute flags byte
 */
#define	PA_FLAG_OPT	0x80	/* attribute is optional */
#define	PA_FLAG_TRANS	0x40	/* attribute is transitive */
#define	PA_FLAG_PARTIAL	0x20	/* incomplete optional, transitive attribute */
#define	PA_FLAG_EXTLEN	0x10	/* extended length flag */

#define	PA_FLAG_ALL  (PA_FLAG_OPT|PA_FLAG_TRANS|PA_FLAG_PARTIAL|PA_FLAG_EXTLEN)
#define	PA_FLAG_OPTTRANS	(PA_FLAG_OPT|PA_FLAG_TRANS)


/*
 * BGP version 4 attribute type codes (the dorks moved metric!).
 */
#define	PA4_TYPE_INVALID	0
#define	PA4_TYPE_ORIGIN		1
#define	PA4_TYPE_ASPATH		2
#define	PA4_TYPE_NEXTHOP	3
#define	PA4_TYPE_METRIC		4
#define	PA4_TYPE_LOCALPREF	5
#define	PA4_TYPE_ATOMICAGG	6
#define	PA4_TYPE_AGGREGATOR	7
#define	PA4_TYPE_COMMUNITY	8
#define PA4_TYPE_DPA		11
#define	PA4_MAXTYPE		11


/*
 * BGP4 well-known attributes
 */
#define COMMUNITY_NO_EXPORT (0xFFFFFF01)
         /* MUST NOT be advertised outside a BGP confederation boundary */
#define COMMUNITY_NO_ADVERTISE (0xFFFFFF02)
         /* MUST NOT be advertised to other BGP peers */
#define COMMUNITY_NO_EXPORT_SUBCONFED (0xFFFFFF03)
         /* MUST NOT be advertised to external BGP peers */

#define	PA_COMMUNITY_MAXLEN	255	/* maximum length */

/*
 * BGP4 subcodes for the AS_PATH attribute
 */
#define	PA_PATH_NOTSETORSEQ	0	/* not a valid path type */
#define	PA_PATH_SET		1
#define	PA_PATH_SEQ		2
#define	PA_PATH_MAXSEGLEN	255	/* maximum segment length */


/*
 * Macro for retrieving attribute information from a byte stream
 */
#define	GET_PATH_ATTR(flags, code, len, cp) \
    do { \
        register u_int Xtmp; \
        Xtmp = (u_int)(*(cp)++); \
        (flags) = Xtmp & ~((u_int)(PA_FLAG_EXTLEN)); \
        (code) = *(cp)++; \
        if (Xtmp & PA_FLAG_EXTLEN) { \
	    Xtmp = (int)((*(cp)++) << 8); \
	    Xtmp |= (int)(*(cp)++); \
	    (len) = Xtmp; \
	} else { \
	     (len) = (*(cp)++); \
	} \
    } while (0)



/*
 * Macro for inserting a path attribute header into a buffer.  The
 * extended length bit is set in the flag as appropriate.
 */
#define	PATH_PUT_ATTR(flag, code, len, cp) \
    do { \
        register u_int Xtmp; \
        Xtmp = (len); \
        if (Xtmp > 255) { \
	    *(cp)++ = (byte)((flag) | PA_FLAG_EXTLEN); \
	    *(cp)++ = (byte)(code); \
	    *(cp)++ = (byte) (Xtmp >> 8); \
	    *(cp)++ = (byte) Xtmp; \
	} else { \
	    *(cp)++ = (byte)((flag) & ~((u_int)(PA_FLAG_EXTLEN))); \
	    *(cp)++ = (byte)(code); \
	    *(cp)++ = (byte) Xtmp; \
	} \
    } while (0)



aspath_t* munge_aspath (int len, u_char **p_cp);
aspath_t *aspth_from_string (char *path);
int aspath_length (aspath_t *aspath, short as);
u_char* unmunge_aspath (aspath_t *aspath, u_char *cp, short as);
char *aspath_toa (aspath_t *aspath);
int Delete_ASPATH (aspath_t *aspath);
int compare_aspaths (aspath_t* aspath1, aspath_t *aspath2);
#endif /* ASPATH_H */
