/*
 * $Id: uping.h,v 1.2 1997/03/20 14:25:27 labovit Exp $
 */

#ifndef _UPING_H
#define _UPING_H

#include <mrt.h>

#define PORT 5670


#define byte u_char

#define	ABS(x)		((x) < 0 ? -(x) : (x))
#define	BITSPERBYTE	(8)


#define UTIL_PUT_BYTE(val, cp)   (*(cp)++ = (byte)(val))

#define UTIL_PUT_SHORT(val, cp) \
        do { \
                register u_short Xv; \
                Xv = (u_short)(val); \
                *(cp)++ = (byte)(Xv >> 8); \
                *(cp)++ = (byte)Xv; \
        } while (0)

#define UTIL_PUT_LONG(val, cp) \
        do { \
                register u_long Xv; \
                Xv = (u_long)(val); \
                *(cp)++ = (byte)(Xv >> 24); \
                *(cp)++ = (byte)(Xv >> 16); \
                *(cp)++ = (byte)(Xv >>  8); \
                *(cp)++ = (byte)Xv; \
        } while (0)

#define UTIL_GET_BYTE(val, cp)   ((val) = *(cp)++)

#define UTIL_GET_SHORT(val, cp) \
        do { \
                register unsigned int Xv; \
                Xv = (*(cp)++) << 8; \
                Xv |= *(cp)++; \
                (val) = Xv; \
        } while (0)

#define UTIL_GET_LONG(val, cp) \
        do { \
                register u_long Xv; \
                Xv = (*(cp)++) << 24; \
                Xv |= (*(cp)++) << 16; \
                Xv |= (*(cp)++) << 8; \
                Xv |= *(cp)++; \
                (val) = Xv; \
        } while (0)

#define UTIL_GET_NETLONG(val, cp) \
        do { \
                register u_char *Xvp; \
                u_long Xv; \
                Xvp = (u_char *) &Xv; \
                *Xvp++ = *(cp)++; \
                *Xvp++ = *(cp)++; \
                *Xvp++ = *(cp)++; \
                *Xvp++ = *(cp)++; \
                (val) = Xv; \
        } while (0)


typedef struct _uping_dst_t {
  u_char		type;		/* 0 = local, 1 = remote */
  prefix_t		*dst;		/* ip address of destination host */
  pthread_mutex_t	mutex_lock;
#ifdef HAVE_SYS_DLPI_H 
  struct ether_addr	ether_addr;	/* mac address of the next hop */
#endif
  u_short		AS;		/* AS of network we are testing */
  LINKED_LIST		*ll_sent;
  /* STATISTICS */
  u_long		duplicate;
  u_long		delay;
  u_long		sent;
  u_long		recv;
} uping_dst_t;

typedef struct _ping_t {
  u_long	sent_sec;
  u_short	sent_msec;
  u_long	delay;
} ping_t;


typedef struct _uping_peer_t {
  int		sockfd;
  int		state;	/* 1 = coonected */
  prefix_t	*prefix;
} uping_peer_t;

extern LINKED_LIST	*ll_uping_dst;
extern LINKED_LIST	*ll_peer;

#endif /* _UPING_H */
