/*
 * CCTL Interface Module's Header File
 *
 * G. Robert Malan (rmalan@eecs.umich.edu).
 * 2/18/97
 *
 * This represents the interface library bewteen the Corona suppliers
 * and clients, and a CCTL server.
 *
 * $Id: salamanderInterface.h,v 1.1 1997/03/20 14:25:24 labovit Exp $
 */

#ifndef	_SALAMANDER_INTERFACE_H_
#define	_SALAMANDER_INTERFACE_H_	1

#include <sys/types.h>
#include "propertyList.h"

#if	TESTING
#	define	SALAMANDER_UDP_PORT	8087
#else	TESTING
#	define	SALAMANDER_UDP_PORT	8087
#endif	TESTING

#define SALAMANDER_MAX_UDP_MSGSIZE	1024

/*
 * UDP Commands:
 */
#define SALAMANDER_QUERY_TCP_PORT	1


/*
 * Library Return codes:
 */
#define	SALAMANDER_OK			0
#define SALAMANDER_LOCAL_ERROR		1
#define SALAMANDER_SERVER_TIMEOUT	2
#define SALAMANDER_HOST_UNKNOWN		3
#define SALAMANDER_REMOTE_ERROR		4
#define SALAMANDER_ALREADY_CONNECTED	5
#define SALAMANDER_PUBLISH_GENERIC 	6
#define SALAMANDER_SEND_ERROR 		7
#define SALAMANDER_PROTOCOL_ERROR	8
#define SALAMANDER_INVALID_PLIST 	9
#define SALAMANDER_MEMORY_ERROR		10


/*
 * Administrative Control Port Commands:
 */
#define SALAMANDER_QUERY_CONNECTIONS	10
#define SALAMANDER_REMOVE_CONNECTION	11
#define SALAMANDER_EXIT			12
/* Used to construct distributed server tree: */
#define SALAMANDER_REMOTE_PUBLISH	13
#define SALAMANDER_REMOTE_SUBSCRIBE	14


/**
 * XXX.  Make dynamic.  Ad hoc maximum to a property key or value length.
 */
#define MAX_PROP_LEN    1024


/*
 * Todo list:
 *
 * Remotely control archiving.
 * Remotely view each connection's status:
 *  - queue
 *  - subscription 
 *  - publishing record
 *  - qos status
 * QoS module placement and manipulation
 *
 */


/*
 * Function prototypes:
 */
int connectToSalamanderServer(char * hostname, u_long sskey);
void disconnectFromSalamanderServer(void);
int salamanderSendServerData(plist_t plist, void * data, u_long data_length);
int salamanderReadServerData(plist_t *plist, void **data, u_long *data_length);



#endif	/* _SALAMANDER_INTERFACE_H_ */

