/*
 * $Id: send_mrt.c,v 1.1.1.1 1996/04/09 15:50:35 labovit Exp $
 */ 

/* send_mrt: send an arbitrary mrt_msg_t. */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/ipc.h>
#include <sys/msg.h>
#include <io.h>

int
main(int argc, char **argv)
{
  mrt_msg_t msg;
  int mqid;
  key_t key;

  if(argc != 6) {
    fprintf(stderr, "usage: send_mrt key priority type subtype str\n");
    exit(1);
  }

  key = strtol(argv[1], (char **) NULL, 0);

  if((mqid = msgget(key, 0222)) < 0) {
    perror("msgget");
    exit(1);
  }

  printf("got mqid=%d, key=0x%x\n", mqid, key);

  msg.priority = atol(argv[2]);
  msg.tstamp = time((time_t *) NULL);
  msg.type = atoi(argv[3]);
  msg.subtype = atoi(argv[4]);
  strcpy(msg.value, argv[5]);
  msg.length = strlen(msg.value);

  if(msgsnd(mqid, &msg, sizeof(mrt_msg_t), 0) != 0) {
    perror("msgsnd");
    exit(1);
  }
}

