#include <stdio.h>
#include <patricia.h> 

void ipn_to_p(unsigned *p3, unsigned *p2, unsigned *p1, unsigned *p0, unsigned n)
{
   *p3 = (n >> 24) & 0xFF;
   *p2 = (n >> 16) & 0xFF;
   *p1 = (n >> 8) & 0xFF;
   *p0 = n & 0xFF;
}

unsigned ipp_to_num(unsigned p3, unsigned p2, unsigned p1, unsigned p0)
{
   if ((p3 > 255) || (p2 > 255) || (p1 > 255) || (p0 > 255)) 
     serr("Illegal IP address");
   return (p3*256*256*256 + p2*256*256 + p1*256 + p0);
}

void ip_input(long *key, unsigned *len)
{
   unsigned p3, p2, p1, p0;

   scanf("%d.%d.%d.%d/%d", &p3, &p2, &p1, &p0, len);
   *key =  ipp_to_num(p3, p2, p1, p0);
}


void ip_output(long num, unsigned len)
{
   unsigned P3, P2, P1, P0;
   
   ipn_to_p(&P3, &P2, &P1, &P0, num);
   printf("%d.%d.%d.%d/%d\n", P3, P2, P1, P0, len);
}

void fip_in(FILE *fd, long *key, unsigned *len)
{
   unsigned p3, p2, p1, p0;

   fscanf(fd, "*rt: %d.%d.%d.%d/%d\n", &p3, &p2, &p1, &p0, len);
   *key =  ipp_to_num(p3, p2, p1, p0);
}

KEY_TYPE cont_mask(unsigned len)
{
  if (len > 0)
    return (0xffffffff >> (32 - len)) << (32 - len);
  else 
    return (0);
}




