/* 
 * $Id: gateway.c,v 1.9 1997/03/21 09:12:05 masaki Exp $
 */

#include <stdio.h>
#include <string.h>
#include <strings.h>
#include <sys/types.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <mrt.h>
#include <interface.h>

/* New_Gateway
 */
gateway_t *New_Gateway (prefix_t *prefix, int AS) {
  gateway_t *gateway;

#ifndef HAVE_IPV6
  assert (prefix->family == AF_INET && prefix->bitlen == 32);
#else
  assert ((prefix->family == AF_INET && prefix->bitlen == 32)
       || (prefix->family == AF_INET6 && prefix->bitlen == 128));
#endif /* HAVE_IPV6 */
  gateway = New (gateway_t);
  gateway->prefix = Ref_Prefix (prefix);
  gateway->AS = AS;
  /* neighbor x.x.x.x name xx replaces this */
  gateway->name = strdup (prefix_toa (prefix));

  return (gateway);
}


/* gateway_toa
 * convert gateway info into a ascii string
 * this should really use thread-specific data!! FIXME!
 */
char *gateway_toa (char *tmp, gateway_t *gateway) {
  memset (tmp, 0, MAXLINE);

  if (gateway->AS > 0)
    sprintf (tmp, "%s AS%d", gateway->name, gateway->AS);
  else
    sprintf (tmp, "%s", gateway->name);

  return (tmp);
}




/* add_gateway
 * find gateway or create a new one if it does not exit
 */
gateway_t *add_gateway (prefix_t *prefix, int AS, interface_t *interface) {
   gateway_t *gateway;

   pthread_mutex_lock (&MRT->mutex_lock);

   /* check if gateway already exists */
   LL_Iterate (MRT->ll_gateways, gateway) {
     if (gateway->prefix == NULL) continue;
     if ((prefix_compare (gateway->prefix, prefix)) &&
	 (gateway->AS == AS)) {
       pthread_mutex_unlock (&MRT->mutex_lock);
       if (gateway->interface == NULL && interface) {
 	  gateway->interface = interface;
          trace (TR_STATE, MRT->trace, "add_gateway: %s on %s (change)\n",
	     prefix_toa (gateway->prefix), (interface)?interface->name:"?");
       }
       if (interface && gateway->interface != interface) {
          trace (ERROR, MRT->trace, "gateway %s was on %s but now on %s\n",
	     prefix_toa (gateway->prefix), 
             gateway->interface->name, interface->name);
       }
       return (gateway);
     }
   }

   gateway = New_Gateway (prefix, AS);
   if (interface == NULL)
      interface = find_interface (prefix);
   gateway->interface = interface;

   LL_Add (MRT->ll_gateways, gateway);
   pthread_mutex_unlock (&MRT->mutex_lock);
   trace (TR_STATE, MRT->trace, "add_gateway: %s on %s (new)\n",
	prefix_toa (gateway->prefix), (interface)?interface->name:"?");
   
   return (gateway);
}


/* find_gateway
 */
gateway_t *find_gateway (prefix_t *prefix, int AS) {
   gateway_t *gateway;

   pthread_mutex_lock (&MRT->mutex_lock);

   /* check if gateway already exists */
   LL_Iterate (MRT->ll_gateways, gateway) {
      if ((prefix_compare (gateway->prefix, prefix)) &&
	  ((gateway->AS == AS) || (AS == 0))) {
	pthread_mutex_unlock (&MRT->mutex_lock);
	return (gateway);
      }
   }

   pthread_mutex_unlock (&MRT->mutex_lock);
   return (NULL);
}

