/* 
 * $Id: trace.h,v 1.4 1997/03/21 09:11:51 masaki Exp $
 */

#ifndef _TRACE_H
#define _TRACE_H

#include <sys/types.h>
#include <New.h>

#ifndef HAVE_PTHREAD_H
#include <pthread_fake.h>
#else
#include <pthread.h>
#endif /* HAVE_PTHREAD_H */

#ifndef TRUE
#define TRUE 1
#endif

#ifndef FALSE
#define FALSE 0
#endif

/* logging/error conditions */
#define TR_FATAL	0x0001	/* fatal error -- die after receiving */
#define TR_ERROR	0x0002	/* non fatal error -- continuing */
#define TR_WARN		0x0004	/* warning -- inform to syslog */

#define TR_INFO		0x0008	/* normal events */
#define TR_TRACE	0x0010	/* verbose tracing, like keepalives */

#define FATAL		TR_FATAL	/* backward compatibility */
#define ERROR		TR_ERROR	/* backward compatibility */
#define INFO		TR_INFO	/* backward compatibility */
#define NORM		TR_INFO	/* backward compatibility */
#define TRACE		TR_TRACE	/* backward compatibility */

#define TR_PARSE	0x0020	/* trace parsing of config files */
#define TR_PACKET	0x0040	/* trace packet comming and goings */
#define TR_STATE	0x0080	/* trace state changes and events */
#define TR_TIMER	0x0100	/* trace timer changes and events */
#define TR_POLICY	0x0200	/* trace policy changes and events */

#define TR_THREAD	0x0400	/* thread tracing */
#define TR_DEBUG	0x0800	/* debugging */

#define TR_ALL		0xffff


#define TR_DEFAULT_LOGFILE	"/tmp/mrt.log"
#define TR_DEFAULT_FLAGS	(TR_FATAL|TR_ERROR|TR_WARN)
#define TR_DEFAULT_APPEND	TRUE
#define TR_DEFAULT_FLOCK	TRUE




typedef struct _trace_t {
    char *logfile_name;
    FILE *logfd;

    pthread_mutex_t mutex_lock;
    pthread_t thread_id;	/* a thread can have trace "open" for 
				   multi-line tracing */
    int flags;
    u_char append_flag;		/* if 1, append to log file */
    u_char flock_flag;		/* if 1, use flock to access trace file */
} trace_t;



enum Trace_Attr {
    TRACE_LOGFILE = 1,
    TRACE_FLAGS,
    TRACE_FLOCK,		/* use flock when accessing trace file */
    TRACE_APPEND,		/* append to log file */
    TRACE_ADD_FLAGS,
    TRACE_DEL_FLAGS,
};


/* public functions */
trace_t *New_Trace (void);
int set_trace (trace_t * tr, int first,...);
int trace (int severity, trace_t * tr,...);
int trace_open (trace_t * tr);
int trace_close (trace_t * tr);
trace_t *trace_copy (trace_t * tr);
u_int trace_flag (char *str);

#endif /* _TRACE_H */
